/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.File;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.util.FileUtils;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.ObjectSerializer;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.cache.DQPContextCache;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManager;
import org.teiid.dqp.internal.datamgr.impl.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.impl.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class VDBDeployer
extends AbstractSimpleRealDeployer<VDBMetaData> {
    private VDBRepository vdbRepository;
    private ConnectorManagerRepository connectorManagerRepository;
    private TranslatorRepository translatorRepository;
    private DQPContextCache contextCache;
    private ObjectSerializer serializer;
    private ContainerLifeCycleListener shutdownListener;

    public VDBDeployer() {
        super(VDBMetaData.class);
        this.setInput(VDBMetaData.class);
        this.setOutput(VDBMetaData.class);
        this.setRelativeOrder(3001);
    }

    public void deploy(DeploymentUnit unit, VDBMetaData deployment) throws DeploymentException {
        List errors;
        boolean preview;
        if (this.vdbRepository.getVDB(deployment.getName(), deployment.getVersion()) != null) {
            this.vdbRepository.removeVDB(deployment.getName(), deployment.getVersion());
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("redeploying_vdb", new Object[]{deployment}));
        }
        if (!(preview = deployment.isPreview()) && (errors = deployment.getValidityErrors()) != null && !errors.isEmpty()) {
            throw new DeploymentException(RuntimePlugin.Util.getString("validity_errors_in_vdb", new Object[]{deployment}));
        }
        MetadataStoreGroup store = (MetadataStoreGroup)unit.getAttachment(MetadataStoreGroup.class);
        for (Translator t : deployment.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            Translator parent = this.translatorRepository.getTranslatorMetaData(null, type);
            if (parent == null) {
                throw new DeploymentException(RuntimePlugin.Util.getString("translator_type_not_found", new Object[]{unit.getName()}));
            }
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            this.translatorRepository.addTranslatorMetadata(new VDBKey(deployment.getName(), deployment.getVersion()), data.getName(), data);
        }
        this.createConnectorManagers(deployment);
        if (store == null && deployment.isDynamic()) {
            MetadataStoreGroup dynamicStore = new MetadataStoreGroup();
            for (Model model : deployment.getModels()) {
                if (model.getName().equals("SYS")) continue;
                dynamicStore.addStore(this.buildDynamicMetadataStore((VFSDeploymentUnit)unit, deployment, (ModelMetaData)model));
            }
            store = dynamicStore;
        }
        if (store == null) {
            LogManager.logError((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("failed_matadata_load", new Object[]{deployment.getName(), deployment.getVersion()}));
        }
        UDFMetaData udf = (UDFMetaData)unit.getAttachment(UDFMetaData.class);
        LinkedHashMap visibilityMap = null;
        IndexMetadataFactory indexFactory = (IndexMetadataFactory)unit.getAttachment(IndexMetadataFactory.class);
        if (indexFactory != null) {
            visibilityMap = indexFactory.getEntriesPlusVisibilities();
        }
        deployment.removeAttachment(IndexMetadataFactory.class);
        deployment.removeAttachment(UDFMetaData.class);
        this.vdbRepository.addVDB(deployment, store, visibilityMap, udf);
        try {
            this.saveMetadataStore((VFSDeploymentUnit)unit, deployment, store);
        }
        catch (IOException e1) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e1, (String)RuntimePlugin.Util.getString("vdb_save_failed", new Object[]{deployment.getName() + "." + deployment.getVersion()}));
        }
        boolean valid = true;
        if (!preview) {
            valid = this.validateSources(deployment);
            if (valid) {
                deployment.setStatus(VDB.Status.ACTIVE);
            } else {
                deployment.setStatus(VDB.Status.INACTIVE);
            }
        } else {
            deployment.setStatus(VDB.Status.ACTIVE);
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_deployed", new Object[]{deployment, valid ? "active" : "inactive"}));
    }

    private void createConnectorManagers(VDBMetaData deployment) throws DeploymentException {
        IdentityHashMap<Translator, ExecutionFactory> map = new IdentityHashMap<Translator, ExecutionFactory>();
        for (Model model : deployment.getModels()) {
            if (model.getName().equals("SYS")) continue;
            for (String source : model.getSourceNames()) {
                if (this.connectorManagerRepository.getConnectorManager(source) != null) continue;
                String name = model.getSourceTranslatorName(source);
                Translator translator = this.translatorRepository.getTranslatorMetaData(new VDBKey(deployment.getName(), deployment.getVersion()), name);
                if (translator == null) {
                    throw new DeploymentException(RuntimePlugin.Util.getString("translator_not_found", new Object[]{name}));
                }
                ExecutionFactory ef = (ExecutionFactory)map.get(translator);
                if (ef == null) {
                    ef = TranslatorUtil.buildExecutionFactory(translator);
                    map.put(translator, ef);
                }
                ConnectorManager cm = new ConnectorManager(name, model.getSourceConnectionJndiName(source));
                cm.setExecutionFactory(ef);
                this.connectorManagerRepository.addConnectorManager(source, cm);
            }
        }
    }

    private boolean validateSources(VDBMetaData deployment) {
        boolean valid = true;
        for (Model m : deployment.getModels()) {
            ModelMetaData model = (ModelMetaData)m;
            List mappings = model.getSourceMappings();
            for (SourceMappingMetadata mapping : mappings) {
                ConnectorManager cm;
                String msg;
                if (mapping.getName().equals("SYS") || (msg = (cm = this.connectorManagerRepository.getConnectorManager(mapping.getName())).getStausMessage()) == null || msg.length() <= 0) continue;
                valid = false;
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), cm.getStausMessage());
                LogManager.logInfo((String)"org.teiid.RUNTIME", (String)cm.getStausMessage());
            }
        }
        return valid;
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void undeploy(DeploymentUnit unit, VDBMetaData deployment) {
        super.undeploy(unit, (Object)deployment);
        for (Model model : deployment.getModels()) {
            if (model.getName().equals("SYS")) continue;
            for (String source : model.getSourceNames()) {
                if (this.connectorManagerRepository.getConnectorManager(source) == null) continue;
                this.connectorManagerRepository.removeConnectorManager(source);
            }
        }
        this.translatorRepository.removeVDBTranslators(new VDBKey(deployment.getName(), deployment.getVersion()));
        if (this.vdbRepository != null) {
            this.vdbRepository.removeVDB(deployment.getName(), deployment.getVersion());
        }
        if (this.contextCache != null) {
            this.contextCache.removeVDBScopedCache(deployment.getName(), deployment.getVersion());
        }
        try {
            this.deleteMetadataStore((VFSDeploymentUnit)unit, deployment);
        }
        catch (IOException e) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_delete_failed", new Object[]{e.getMessage()}));
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_undeployed", new Object[]{deployment}));
    }

    public void setContextCache(DQPContextCache cache) {
        this.contextCache = cache;
    }

    public void setObjectSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    public void setConnectorManagerRepository(ConnectorManagerRepository repo) {
        this.connectorManagerRepository = repo;
    }

    private void saveMetadataStore(VFSDeploymentUnit unit, VDBMetaData vdb, MetadataStoreGroup store) throws IOException {
        File cacheFileName = this.serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion());
        if (!cacheFileName.exists()) {
            this.serializer.saveAttachment(cacheFileName, store);
        }
    }

    private void deleteMetadataStore(VFSDeploymentUnit unit, VDBMetaData vdb) throws IOException {
        File cacheFileName;
        if (!(unit.getRoot().exists() && this.shutdownListener.isShutdownInProgress() || !(cacheFileName = this.serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion())).exists())) {
            FileUtils.removeDirectoryAndChildren((File)cacheFileName.getParentFile());
        }
    }

    private MetadataStore buildDynamicMetadataStore(VFSDeploymentUnit unit, VDBMetaData vdb, ModelMetaData model) throws DeploymentException {
        MetadataStore store;
        if (model.getSourceNames().isEmpty()) {
            throw new DeploymentException(RuntimePlugin.Util.getString("fail_to_deploy", new Object[]{vdb.getName() + "-" + vdb.getVersion(), model.getName()}));
        }
        boolean cache = "cached".equalsIgnoreCase(vdb.getPropertyValue("UseConnectorMetadata"));
        File cacheFile = null;
        if (cache && (store = this.serializer.loadSafe(cacheFile = this.buildCachedFileName(unit, vdb, model.getName()), MetadataStore.class)) != null) {
            return store;
        }
        Throwable exception = null;
        for (String sourceName : model.getSourceNames()) {
            ConnectorManager cm = this.connectorManagerRepository.getConnectorManager(sourceName);
            if (cm == null) continue;
            try {
                MetadataStore store2 = cm.getMetadata(model.getName(), this.vdbRepository.getBuiltinDatatypes(), model.getProperties());
                if (cache) {
                    this.serializer.saveAttachment(cacheFile, store2);
                }
                return store2;
            }
            catch (TranslatorException e) {
                if (exception != null) continue;
                exception = e;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        throw new DeploymentException(RuntimePlugin.Util.getString("failed_to_retrive_metadata", new Object[]{vdb.getName() + "-" + vdb.getVersion(), model.getName()}), exception);
    }

    private File buildCachedFileName(VFSDeploymentUnit unit, VDBMetaData vdb, String modelName) {
        return this.serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion() + "_" + modelName);
    }

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }

    public void setContainerLifeCycleListener(ContainerLifeCycleListener listener) {
        this.shutdownListener = listener;
    }
}

