/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.TransformationMetadata;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final long serialVersionUID = 312177538191772674L;
    private Map<VDBKey, CompositeVDB> vdbRepo = new ConcurrentHashMap<VDBKey, CompositeVDB>();
    private MetadataStore systemStore;

    public void addVDB(VDBMetaData vdb, MetadataStoreGroup stores, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf) throws DeploymentException {
        if (this.getVDB(vdb.getName(), vdb.getVersion()) != null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("duplicate_vdb", new Object[]{vdb.getName(), vdb.getVersion()}));
        }
        if (this.systemStore == null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("system_vdb_load_error"));
        }
        this.vdbRepo.put(this.vdbId(vdb), new CompositeVDB(vdb, stores, visibilityMap, udf, this.systemStore));
    }

    public VDBMetaData getVDB(String name, int version) {
        CompositeVDB v = this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        return vdbs;
    }

    protected VDBKey vdbId(VDBMetaData vdb) {
        return new VDBKey(vdb.getName(), vdb.getVersion());
    }

    public VDBMetaData getActiveVDB(String vdbName) throws VirtualDatabaseException {
        int latestVersion = 0;
        for (VDBKey key : this.vdbRepo.keySet()) {
            if (!key.getName().equalsIgnoreCase(vdbName)) continue;
            VDBMetaData vdb = this.vdbRepo.get(key).getVDB();
            if (vdb.getStatus() == VDB.Status.ACTIVE_DEFAULT) {
                latestVersion = vdb.getVersion();
                break;
            }
            latestVersion = Math.max(latestVersion, Integer.parseInt(key.getVersion()));
        }
        if (latestVersion == 0) {
            throw new VirtualDatabaseException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, "latest"}));
        }
        VDBMetaData vdb = this.getVDB(vdbName, latestVersion);
        if (vdb.getStatus() == VDB.Status.ACTIVE || vdb.getStatus() == VDB.Status.ACTIVE_DEFAULT) {
            return vdb;
        }
        throw new VirtualDatabaseException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, latestVersion}));
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
    }

    public synchronized void removeVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        this.vdbRepo.remove(key);
        for (CompositeVDB other : this.vdbRepo.values()) {
            other.removeChild(key);
        }
    }

    public Map<String, Datatype> getBuiltinDatatypes() {
        Collection datatypes = this.systemStore.getDatatypes();
        HashMap<String, Datatype> datatypeMap = new HashMap<String, Datatype>();
        block0: for (Class typeClass : DataTypeManager.getAllDataTypeClasses()) {
            for (Datatype datatypeRecordImpl : datatypes) {
                if (!datatypeRecordImpl.getJavaClassName().equals(typeClass.getName())) continue;
                datatypeMap.put(DataTypeManager.getDataTypeName((Class)typeClass), datatypeRecordImpl);
                continue block0;
            }
        }
        return datatypeMap;
    }

    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        CompositeVDB source = this.vdbRepo.get(new VDBKey(sourceVDBName, sourceVDBVersion));
        if (source == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        CompositeVDB target = this.vdbRepo.get(new VDBKey(targetVDBName, targetVDBVersion));
        if (target == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        target.addChild(source);
    }
}

