/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.jar.JarUtils;

public class VDBStructure
extends AbstractVFSStructureDeployer {
    public VDBStructure() {
        this.setRelativeOrder(1000);
        JarUtils.addJarSuffix((String)".vdb");
    }

    public boolean determineStructure(StructureContext structureContext) throws DeploymentException {
        VirtualFile file = structureContext.getFile();
        try {
            if (!VDBStructure.isLeaf((VirtualFile)file) && file.getName().endsWith(".vdb")) {
                VirtualFile metainf = file.getChild("META-INF");
                if (metainf == null) {
                    return false;
                }
                if (metainf.getChild("vdb.xml") == null) {
                    return false;
                }
                this.createContext(structureContext, new String[]{"/", "META-INF", "runtime-inf"});
                return true;
            }
        }
        catch (IOException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error determining structure: " + file.getName()), (Throwable)e);
        }
        return false;
    }
}

