/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.cache.CacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.dqp.internal.cache.DQPContextCache;
import org.teiid.dqp.service.BufferService;
import org.teiid.runtime.RuntimePlugin;

@ManagementObject(componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class BufferServiceImpl
implements BufferService,
Serializable {
    private static final long serialVersionUID = -6217808623863643531L;
    private BufferManagerImpl bufferMgr;
    private File bufferDir;
    private boolean useDisk = true;
    private DQPContextCache contextCache;
    private int processorBatchSize = 512;
    private int connectorBatchSize = 1024;
    private CacheFactory cacheFactory;
    private int maxOpenFiles = 64;
    private long maxFileSize = 2048L;
    private int maxProcessingBatchesColumns = 128;
    private int maxReserveBatchColumns = 16384;

    void cleanDirectory(File file) {
        FileUtils.removeChildrenRecursively((File)file);
    }

    public void start() {
        try {
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.setConnectorBatchSize(Integer.valueOf(this.connectorBatchSize).intValue());
            this.bufferMgr.setProcessorBatchSize(Integer.valueOf(this.processorBatchSize).intValue());
            this.bufferMgr.setMaxReserveBatchColumns(this.maxReserveBatchColumns);
            this.bufferMgr.setMaxProcessingBatchColumns(this.maxProcessingBatchesColumns);
            this.bufferMgr.initialize();
            if (this.useDisk) {
                FileStorageManager fsm = new FileStorageManager();
                fsm.setStorageDirectory(this.bufferDir.getCanonicalPath());
                fsm.setMaxFileSize(this.maxFileSize);
                fsm.setMaxOpenFiles(this.maxOpenFiles);
                fsm.initialize();
                this.bufferMgr.setStorageManager((StorageManager)fsm);
                this.cleanDirectory(this.bufferDir);
            } else {
                this.bufferMgr.setStorageManager((StorageManager)new MemoryStorageManager());
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
    }

    public void stop() {
        this.bufferMgr.shutdown();
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public DQPContextCache getContextCache() {
        return this.contextCache;
    }

    public void setContextCache(DQPContextCache cache) {
        this.contextCache = cache;
    }

    public void setUseDisk(boolean flag) {
        this.useDisk = flag;
    }

    public void setDiskDirectory(String dir) {
        this.bufferDir = new File(dir, "buffer");
        if (!this.bufferDir.exists()) {
            this.bufferDir.mkdirs();
        }
    }

    public void setProcessorBatchSize(int size) {
        this.processorBatchSize = size;
    }

    public void setConnectorBatchSize(int size) {
        this.connectorBatchSize = size;
    }

    public File getBufferDirectory() {
        return this.bufferDir;
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    @ManagementProperty(description="The max row count of a batch sent internally within the query processor. Should be <= the connectorBatchSize. (default 256)")
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    @ManagementProperty(description="The max row count of a batch from a connector. Should be even multiple of processorBatchSize. (default 512)")
    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public CacheFactory getCacheFactory() {
        return this.cacheFactory;
    }

    public void setCacheFactory(CacheFactory cf) {
        this.cacheFactory = cf;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxReserveBatchColumns(int value) {
        this.maxReserveBatchColumns = value;
    }

    public void setMaxProcessingBatchesColumns(int value) {
        this.maxProcessingBatchesColumns = value;
    }

    @ManagementProperty(description="Max file size for buffer files (default 2GB)")
    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    @ManagementProperty(description="Max open buffer files (default 64)")
    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    @ManagementProperty(description="#The number of batch columns guarenteed to a processing operation.  Set this value lower if the workload typicallyprocesses larger numbers of concurrent queries with large intermediate results from operations such as sorting, grouping, etc. (default 128)")
    public int getMaxProcessingBatchesColumns() {
        return this.maxProcessingBatchesColumns;
    }

    @ManagementProperty(description="#The number of batch columns to allow in memory (default 16384).  This value should be set lower or higher depending on the available memory to Teiid in the VM.  16384 is considered a good default for a dedicated 32-bit VM running Teiid with a 1 gig heap.")
    public int getMaxReserveBatchColumns() {
        return this.maxReserveBatchColumns;
    }
}

