/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates;

import java.io.Serializable;
import java.util.Map;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.teiid.deployers.ManagedPropertyUtil;

public class TranslatorTemplateInfo
extends BasicDeploymentTemplateInfo {
    private static final long serialVersionUID = 9066758787789280783L;
    static final String TYPE_NAME = "type";
    static final String NAME = "name";
    private String executionFactoryName;

    public TranslatorTemplateInfo(String name, String description, Map<String, ManagedProperty> properties, String executionFactoryName) {
        super(name, description, properties);
        this.executionFactoryName = executionFactoryName;
    }

    public void start() {
        this.populate();
    }

    public TranslatorTemplateInfo copy() {
        TranslatorTemplateInfo copy = new TranslatorTemplateInfo(this.getName(), this.getDescription(), this.getProperties(), this.executionFactoryName);
        super.copy((BasicDeploymentTemplateInfo)copy);
        copy.populate();
        return copy;
    }

    private void populate() {
        this.addProperty(TranslatorTemplateInfo.buildTemplateProperty(this.getName()));
        this.addProperty(ManagedPropertyUtil.createProperty("execution-factory-class", (MetaType)SimpleMetaType.STRING, "Execution Factory Class name", "The translator's execution factory name", true, true, (Serializable)((Object)this.executionFactoryName)));
        this.addProperty(ManagedPropertyUtil.createProperty(NAME, (MetaType)SimpleMetaType.STRING, NAME, "Name of the Translator", true, true, (Serializable)((Object)this.getName())));
        this.addProperty(ManagedPropertyUtil.createProperty("property", (MetaType)new MapCompositeMetaType((MetaType)SimpleMetaType.STRING), "property", "Additional Translator properties", false, false, null));
    }

    static ManagedProperty buildTemplateProperty(String name) {
        return ManagedPropertyUtil.createProperty(TYPE_NAME, (MetaType)SimpleMetaType.STRING, "Base Tanslator Type Name", "The Name of the Teiid Traslator", true, true, (Serializable)((Object)name.substring("translator-".length())));
    }
}

