/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.HashMap;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.ClientServiceRegistry;

public class ClientServiceRegistryImpl
implements ClientServiceRegistry {
    private HashMap<String, ClientService> clientServices = new HashMap();
    private SecurityHelper securityHelper;

    @Override
    public <T> T getClientService(Class<T> iface) throws ComponentNotFoundException {
        ClientService cs = this.getClientService(iface.getName());
        return iface.cast(cs.getInstance());
    }

    public ClientService getClientService(String iface) throws ComponentNotFoundException {
        ClientService cs = this.clientServices.get(iface);
        if (cs == null) {
            throw new ComponentNotFoundException(RuntimePlugin.Util.getString("ServerWorkItem.Component_Not_Found", new Object[]{iface}));
        }
        return cs;
    }

    public <T> void registerClientService(Class<T> iface, T instance, String loggingContext) {
        this.clientServices.put(iface.getName(), new ClientService(instance, loggingContext, new ReflectionHelper(iface)));
    }

    @Override
    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public static class ClientService {
        private Object instance;
        private String loggingContext;
        private ReflectionHelper reflectionHelper;

        public ClientService(Object instance, String loggingContext, ReflectionHelper reflectionHelper) {
            this.instance = instance;
            this.loggingContext = loggingContext;
            this.reflectionHelper = reflectionHelper;
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getLoggingContext() {
            return this.loggingContext;
        }

        public ReflectionHelper getReflectionHelper() {
            return this.reflectionHelper;
        }
    }
}

