/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.util.Collection;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferFactory;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.handler.stream.ChunkedStream;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectOutputStream;

@ChannelPipelineCoverage(value="all")
public class ObjectEncoder
implements ChannelDownstreamHandler {
    private static final byte[] LENGTH_PLACEHOLDER = new byte[4];
    private static final int CHUNK_SIZE = 65536;
    private final int estimatedLength;

    public ObjectEncoder() {
        this(512);
    }

    public ObjectEncoder(int estimatedLength) {
        if (estimatedLength < 0) {
            throw new IllegalArgumentException("estimatedLength: " + estimatedLength);
        }
        this.estimatedLength = estimatedLength;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        if (e.getMessage() instanceof ChunkedInput) {
            ctx.sendDownstream(evt);
            return;
        }
        ChannelBufferOutputStream bout = new ChannelBufferOutputStream(ChannelBuffers.dynamicBuffer((int)this.estimatedLength, (ChannelBufferFactory)ctx.getChannel().getConfig().getBufferFactory()));
        bout.write(LENGTH_PLACEHOLDER);
        CompactObjectOutputStream oout = new CompactObjectOutputStream((OutputStream)bout);
        oout.writeObject(e.getMessage());
        ExternalizeUtil.writeCollection((ObjectOutput)oout, (Collection)oout.getReferences());
        oout.flush();
        oout.close();
        ChannelBuffer encoded = bout.buffer();
        encoded.setInt(0, encoded.writerIndex() - 4);
        Channels.write((ChannelHandlerContext)ctx, (ChannelFuture)e.getFuture(), (Object)encoded, (SocketAddress)e.getRemoteAddress());
        for (InputStream is : oout.getStreams()) {
            Channels.write((Channel)ctx.getChannel(), (Object)((Object)new AnonymousChunkedStream(new BufferedInputStream(is, 65536))));
        }
    }

    static class AnonymousChunkedStream
    extends ChunkedStream {
        public AnonymousChunkedStream(InputStream in) {
            super(in, 65536);
        }

        public Object nextChunk() throws Exception {
            ChannelBuffer cb = (ChannelBuffer)super.nextChunk();
            int length = cb.capacity();
            ChannelBuffer prefix = ChannelBuffers.wrappedBuffer((byte[])new byte[2]);
            prefix.setShort(0, (short)length);
            if (!this.hasNextChunk()) {
                return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{prefix, cb, ChannelBuffers.wrappedBuffer((byte[])new byte[2])});
            }
            return ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{prefix, cb});
        }
    }
}

