/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.spi.deployer.helpers.AbstractAnnotationDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractAnnotationProcessor;
import org.jboss.deployers.spi.deployer.helpers.AnnotationProcessor;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.Translator;

public class TranslatorAnnotationScanningDeployer
extends AbstractAnnotationDeployer
implements ManagedObjectCreator {
    private TranslatorRepository translatorRepository;
    private VDBStatusChecker vdbChecker;
    private ManagedObjectFactory mof;

    public TranslatorAnnotationScanningDeployer() {
        super(new AnnotationProcessor[]{new TranslatorAnnotationProcessor()});
    }

    public void deploy(DeploymentUnit unit, AnnotationEnvironment deployment) throws DeploymentException {
        super.deploy(unit, deployment);
        Collection group = unit.getAttachments().values();
        for (Object anObj : group) {
            if (!(anObj instanceof TranslatorMetaData)) continue;
            TranslatorMetaData data = (TranslatorMetaData)anObj;
            String translatorName = data.getName();
            if (translatorName == null) {
                throw new DeploymentException(RuntimePlugin.Util.getString("name_not_found", new Object[]{unit.getName()}));
            }
            Properties props = TranslatorUtil.getTranslatorPropertiesAsProperties(data.getExecutionFactoryClass());
            data.setProperties(props);
            data.addProperty("execution-factory-class", data.getExecutionFactoryClass().getName());
            this.translatorRepository.addTranslatorMetadata(translatorName, (VDBTranslatorMetaData)data);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("translator_added", new Object[]{translatorName}));
            this.vdbChecker.translatorAdded(translatorName);
        }
    }

    public void undeploy(DeploymentUnit unit, AnnotationEnvironment deployment) {
        super.undeploy(unit, (Object)deployment);
        Collection group = unit.getAttachments().values();
        for (Object anObj : group) {
            if (!(anObj instanceof TranslatorMetaData)) continue;
            TranslatorMetaData data = (TranslatorMetaData)anObj;
            String translatorName = data.getName();
            if (this.translatorRepository == null) continue;
            this.translatorRepository.removeTranslatorMetadata(translatorName);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("translator_removed", new Object[]{translatorName}));
            this.vdbChecker.translatorRemoved(translatorName);
        }
    }

    public void build(DeploymentUnit unit, Set<String> attachmentNames, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        Collection group = unit.getAttachments().values();
        for (Object anObj : group) {
            if (!(anObj instanceof TranslatorMetaData)) continue;
            TranslatorMetaData data = (TranslatorMetaData)anObj;
            ManagedObject mo = this.mof.initManagedObject((Object)data, TranslatorMetaData.class, data.getName(), data.getName());
            if (mo == null) {
                throw new DeploymentException("could not create managed object");
            }
            managedObjects.put(mo.getName(), mo);
        }
    }

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }

    public void setVDBStatusChecker(VDBStatusChecker checker) {
        this.vdbChecker = checker;
    }

    public void setManagedObjectFactory(ManagedObjectFactory mof) {
        this.mof = mof;
    }

    private static class TranslatorAnnotationProcessor
    extends AbstractAnnotationProcessor<Translator, TranslatorMetaData> {
        private TranslatorAnnotationProcessor() {
        }

        public Class<Translator> getAnnotation() {
            return Translator.class;
        }

        public Class<TranslatorMetaData> getOutput() {
            return TranslatorMetaData.class;
        }

        protected TranslatorMetaData createMetaDataFromClass(Class<?> clazz, Translator bean) {
            String name = bean.name();
            if (name == null) {
                throw new IllegalArgumentException("Null Translator name: " + clazz);
            }
            TranslatorMetaData data = new TranslatorMetaData();
            data.setName(bean.name());
            data.setExecutionFactoryClass(clazz);
            return data;
        }
    }
}

