/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.virtual.VirtualFile;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.BaseMultipleVFSParsingDeployer;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.ObjectSerializer;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.runtime.RuntimePlugin;
import org.xml.sax.SAXException;

public class VDBParserDeployer
extends BaseMultipleVFSParsingDeployer<VDBMetaData>
implements ManagedObjectCreator {
    private ObjectSerializer serializer;
    private VDBRepository vdbRepository;
    private ManagedObjectFactory mof;

    public VDBParserDeployer() {
        super(VDBMetaData.class, VDBParserDeployer.getCustomMappings(), ".INDEX", IndexMetadataFactory.class, ".xmi", UDFMetaData.class);
        this.setAllowMultipleFiles(true);
    }

    private static Map<String, Class<?>> getCustomMappings() {
        HashMap mappings = new HashMap();
        mappings.put("vdb.xml", VDBMetaData.class);
        mappings.put("undefined", UDFMetaData.class);
        return mappings;
    }

    @Override
    protected <U> U parse(VFSDeploymentUnit unit, Class<U> expectedType, VirtualFile file, Object root) throws Exception {
        if (expectedType.equals(VDBMetaData.class)) {
            Unmarshaller un = VDBParserDeployer.getUnMarsheller();
            VDBMetaData def = (VDBMetaData)un.unmarshal(file.openStream());
            return expectedType.cast(def);
        }
        if (expectedType.equals(UDFMetaData.class)) {
            if (root == null && (root = unit.getAttachment(UDFMetaData.class)) == null) {
                root = new UDFMetaData();
                unit.addAttachment(UDFMetaData.class, UDFMetaData.class.cast(root));
            }
            UDFMetaData udf = (UDFMetaData)UDFMetaData.class.cast(root);
            udf.addModelFile(file);
            return expectedType.cast(udf);
        }
        if (expectedType.equals(IndexMetadataFactory.class)) {
            if (root == null && (root = unit.getAttachment(IndexMetadataFactory.class)) == null) {
                root = new IndexMetadataFactory();
            }
            IndexMetadataFactory imf = (IndexMetadataFactory)IndexMetadataFactory.class.cast(root);
            imf.addIndexFile(file);
            unit.addAttachment(IndexMetadataFactory.class, (Object)imf);
            return expectedType.cast(imf);
        }
        throw new IllegalArgumentException("Cannot match arguments: expectedClass=" + expectedType);
    }

    static Unmarshaller getUnMarsheller() throws JAXBException, SAXException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{VDBMetaData.class});
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(VDBMetaData.class.getResource("/vdb-deployer.xsd"));
        Unmarshaller un = jc.createUnmarshaller();
        un.setSchema(schema);
        return un;
    }

    protected VDBMetaData mergeMetaData(VFSDeploymentUnit unit, Map<Class<?>, List<Object>> metadata) throws Exception {
        VDBMetaData vdb = (VDBMetaData)this.getInstance(metadata, VDBMetaData.class);
        UDFMetaData udf = (UDFMetaData)this.getInstance(metadata, UDFMetaData.class);
        IndexMetadataFactory imf = (IndexMetadataFactory)this.getInstance(metadata, IndexMetadataFactory.class);
        if (vdb == null) {
            LogManager.logError((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("invlaid_vdb_file", new Object[]{unit.getRoot().getName()}));
            return null;
        }
        vdb.setUrl(unit.getRoot().toURL());
        if (imf != null) {
            imf.addEntriesPlusVisibilities(unit.getRoot(), vdb);
            unit.addAttachment(IndexMetadataFactory.class, (Object)imf);
            File cacheFile = this.serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion());
            MetadataStoreGroup stores = this.serializer.loadSafe(cacheFile, MetadataStoreGroup.class);
            if (stores == null) {
                stores = new MetadataStoreGroup();
                stores.addStore(imf.getMetadataStore(this.vdbRepository.getSystemStore().getDatatypes()));
            }
            unit.addAttachment(MetadataStoreGroup.class, (Object)stores);
        }
        if (udf != null) {
            for (Model model : vdb.getModels()) {
                if (!model.getModelType().equals((Object)Model.Type.FUNCTION)) continue;
                String path = ((ModelMetaData)model).getPath();
                if (path == null) {
                    throw new DeploymentException(RuntimePlugin.Util.getString("invalid_udf_file", new Object[]{model.getName()}));
                }
                udf.buildFunctionModelFile(path);
            }
            unit.addAttachment(UDFMetaData.class, (Object)udf);
        }
        LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + unit.getRoot().getName() + " has been parsed."});
        return vdb;
    }

    public void setVdbRepository(VDBRepository vdbRepository) {
        this.vdbRepository = vdbRepository;
    }

    public void setObjectSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    public void build(DeploymentUnit unit, Set<String> attachmentNames, Map<String, ManagedObject> managedObjects) throws DeploymentException {
        ManagedObject vdbMO = managedObjects.get(VDBMetaData.class.getName());
        if (vdbMO != null) {
            ManagedObject mo;
            VDBMetaData vdb = (VDBMetaData)vdbMO.getAttachment();
            for (Model m : vdb.getModels()) {
                if (m.getName().equals("SYS") || m.getName().equals("pg_catalog")) continue;
                mo = this.mof.initManagedObject((Object)m, ModelMetaData.class, m.getName(), m.getName());
                if (mo == null) {
                    throw new DeploymentException("could not create managed object");
                }
                managedObjects.put(mo.getName(), mo);
            }
            for (Translator t : vdb.getOverrideTranslators()) {
                mo = this.mof.initManagedObject((Object)t, VDBTranslatorMetaData.class, t.getName(), t.getName());
                if (mo == null) {
                    throw new DeploymentException("could not create managed object");
                }
                managedObjects.put(mo.getName(), mo);
            }
        }
    }

    public void setManagedObjectFactory(ManagedObjectFactory mof) {
        this.mof = mof;
    }
}

