/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineCoverage;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCClientRemote;

@ChannelPipelineCoverage(value="one")
public class PgBackendProtocol
implements ChannelDownstreamHandler,
ODBCClientRemote {
    private static final int PG_TYPE_VARCHAR = 1043;
    private static final int PG_TYPE_BOOL = 16;
    private static final int PG_TYPE_BYTEA = 17;
    private static final int PG_TYPE_BPCHAR = 1042;
    private static final int PG_TYPE_INT8 = 20;
    private static final int PG_TYPE_INT2 = 21;
    private static final int PG_TYPE_INT4 = 23;
    private static final int PG_TYPE_TEXT = 25;
    private static final int PG_TYPE_OID = 26;
    private static final int PG_TYPE_FLOAT4 = 700;
    private static final int PG_TYPE_FLOAT8 = 701;
    private static final int PG_TYPE_UNKNOWN = 705;
    private static final int PG_TYPE_TEXTARRAY = 1009;
    private static final int PG_TYPE_DATE = 1082;
    private static final int PG_TYPE_TIME = 1083;
    private static final int PG_TYPE_TIMESTAMP_NO_TMZONE = 1114;
    private static final int PG_TYPE_NUMERIC = 1700;
    private DataOutputStream dataOut;
    private ByteArrayOutputStream outBuffer;
    private char messageType;
    private Properties props;
    private Charset encoding = Charset.forName("UTF-8");
    private ReflectionHelper clientProxy = new ReflectionHelper(ODBCClientRemote.class);
    private ChannelHandlerContext ctx;
    private MessageEvent message;

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent me = (MessageEvent)evt;
        if (!(me.getMessage() instanceof ServiceInvocationStruct)) {
            ctx.sendDownstream(evt);
            return;
        }
        this.ctx = ctx;
        this.message = me;
        ServiceInvocationStruct serviceStruct = (ServiceInvocationStruct)me.getMessage();
        try {
            Method m = this.clientProxy.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                m.invoke((Object)this, serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Override
    public void initialized(Properties props) {
        this.props = props;
        this.encoding = Charset.forName(props.getProperty("client_encoding", "UTF-8"));
    }

    @Override
    public void useClearTextAuthentication() {
        try {
            this.sendAuthenticationCleartextPassword();
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void authenticationSucess(int processId, int screctKey) {
        try {
            this.sendAuthenticationOk();
            this.sendParameterStatus("client_encoding", this.encoding.name());
            this.sendParameterStatus("DateStyle", this.props.getProperty("DateStyle"));
            this.sendParameterStatus("integer_datetimes", "off");
            this.sendParameterStatus("is_superuser", "off");
            this.sendParameterStatus("server_encoding", "SQL_ASCII");
            this.sendParameterStatus("server_version", "8.1.4");
            this.sendParameterStatus("session_authorization", this.props.getProperty("user"));
            this.sendParameterStatus("standard_conforming_strings", "off");
            this.sendParameterStatus("application_name", this.props.getProperty("application_name", "ODBCClient"));
            this.sendParameterStatus("TimeZone", "CET");
            this.sendBackendKeyData(processId, screctKey);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void prepareCompleted(String preparedName) {
        this.sendParseComplete();
    }

    @Override
    public void bindComplete() {
        this.sendBindComplete();
    }

    @Override
    public void errorOccurred(String msg) {
        try {
            this.sendErrorResponse(msg);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void errorOccurred(Throwable t) {
        try {
            this.sendErrorResponse(t);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void ready(boolean inTransaction, boolean failedTransaction) {
        try {
            this.sendReadyForQuery(inTransaction, failedTransaction);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void setEncoding(Charset value) {
        this.encoding = value;
    }

    @Override
    public void sendParameterDescription(ParameterMetaData meta, int[] paramType) {
        try {
            try {
                int count = meta.getParameterCount();
                this.startMessage('t');
                this.writeShort(count);
                for (int i = 0; i < count; ++i) {
                    int type = paramType != null && paramType[i] != 0 ? paramType[i] : 1043;
                    this.writeInt(type);
                }
                this.sendMessage();
            }
            catch (SQLException e) {
                this.sendErrorResponse(e);
            }
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendResultSetDescription(ResultSetMetaData metaData) {
        try {
            try {
                this.sendRowDescription(metaData);
            }
            catch (SQLException e) {
                this.sendErrorResponse(e);
            }
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendResults(String sql, ResultSet rs, boolean describeRows) {
        try {
            try {
                if (describeRows) {
                    ResultSetMetaData meta = rs.getMetaData();
                    this.sendRowDescription(meta);
                }
                while (rs.next()) {
                    this.sendDataRow(rs);
                }
                this.sendCommandComplete(sql, 0);
            }
            catch (SQLException e) {
                this.sendErrorResponse(e);
            }
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendUpdateCount(String sql, int updateCount) {
        try {
            this.sendCommandComplete(sql, updateCount);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void statementClosed() {
        this.startMessage('3');
        this.sendMessage();
    }

    @Override
    public void terminated() {
        try {
            PgBackendProtocol.trace("channel being terminated");
            this.sendNoticeResponse("Connection closed");
            this.ctx.getChannel().close();
        }
        catch (IOException e) {
            PgBackendProtocol.trace(e.getMessage());
        }
    }

    @Override
    public void flush() {
        try {
            this.dataOut.flush();
            this.dataOut = null;
            Channels.write((Channel)this.ctx.getChannel(), null);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void emptyQueryReceived() {
        this.sendEmptyQueryResponse();
    }

    private void terminate(Throwable t) {
        PgBackendProtocol.trace("channel being terminated - " + t.getMessage());
        this.ctx.getChannel().close();
    }

    private void sendEmptyQueryResponse() {
        this.startMessage('I');
        this.sendMessage();
    }

    private void sendCommandComplete(String sql, int updateCount) throws IOException {
        String tag;
        this.startMessage('C');
        sql = sql.trim().toUpperCase();
        if (sql.startsWith("INSERT")) {
            tag = "INSERT 0 " + updateCount;
        } else if (sql.startsWith("DELETE")) {
            tag = "DELETE " + updateCount;
        } else if (sql.startsWith("UPDATE")) {
            tag = "UPDATE " + updateCount;
        } else if (sql.startsWith("SELECT") || sql.startsWith("CALL")) {
            tag = "SELECT";
        } else if (sql.startsWith("BEGIN")) {
            tag = "BEGIN";
        } else {
            PgBackendProtocol.trace("Check command tag: " + sql);
            tag = "UPDATE " + updateCount;
        }
        this.writeString(tag);
        this.sendMessage();
    }

    private void sendDataRow(ResultSet rs) throws SQLException, IOException {
        int columns = rs.getMetaData().getColumnCount();
        String[] values = new String[columns];
        for (int i = 0; i < columns; ++i) {
            values[i] = rs.getString(i + 1);
        }
        this.startMessage('D');
        this.writeShort(columns);
        for (String s : values) {
            if (s == null) {
                this.writeInt(-1);
                continue;
            }
            byte[] d2 = s.getBytes(this.encoding);
            this.writeInt(d2.length);
            this.write(d2);
        }
        this.sendMessage();
    }

    private void sendErrorResponse(Throwable t) throws IOException {
        PgBackendProtocol.trace(t.getMessage());
        TeiidSQLException e = TeiidSQLException.create((Throwable)t);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendNoData() {
        this.startMessage('n');
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData meta) throws SQLException, IOException {
        if (meta == null) {
            this.sendNoData();
        } else {
            int i;
            int columns = meta.getColumnCount();
            int[] types = new int[columns];
            int[] precision = new int[columns];
            String[] names = new String[columns];
            for (i = 0; i < columns; ++i) {
                names[i] = meta.getColumnName(i + 1);
                int type = meta.getColumnType(i + 1);
                type = PgBackendProtocol.convertType(type);
                precision[i] = meta.getColumnDisplaySize(i + 1);
                types[i] = type;
            }
            this.startMessage('T');
            this.writeShort(columns);
            for (i = 0; i < columns; ++i) {
                this.writeString(names[i].toLowerCase());
                this.writeInt(0);
                this.writeShort(0);
                this.writeInt(types[i]);
                this.writeShort(this.getTypeSize(types[i], precision[i]));
                this.writeInt(-1);
                this.writeShort(0);
            }
            this.sendMessage();
        }
    }

    private int getTypeSize(int pgType, int precision) {
        switch (pgType) {
            case 1043: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private void sendErrorResponse(String message) throws IOException {
        PgBackendProtocol.trace("Exception: " + message);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendNoticeResponse(String message) throws IOException {
        PgBackendProtocol.trace("notice: " + message);
        this.startMessage('N');
        this.write(83);
        this.writeString("ERROR");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() {
        this.startMessage('1');
        this.sendMessage();
    }

    private void sendBindComplete() {
        this.startMessage('2');
        this.sendMessage();
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage('R');
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage('R');
        this.writeInt(0);
        this.sendMessage();
    }

    private void sendReadyForQuery(boolean inTransaction, boolean failedTransaction) throws IOException {
        this.startMessage('Z');
        int c = failedTransaction ? 69 : (inTransaction ? 84 : 73);
        this.write((byte)c);
        this.sendMessage();
    }

    private void sendBackendKeyData(int processId, int screctKey) throws IOException {
        this.startMessage('K');
        this.writeInt(processId);
        this.writeInt(screctKey);
        this.sendMessage();
    }

    private void sendParameterStatus(String param, String value) throws IOException {
        this.startMessage('S');
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    private void writeString(String s) throws IOException {
        this.write(s.getBytes(this.encoding));
        this.write(0);
    }

    private void writeInt(int i) throws IOException {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) throws IOException {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) throws IOException {
        this.dataOut.write(data);
    }

    private void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    private void startMessage(char newMessageType) {
        this.messageType = newMessageType;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() {
        byte[] buff = this.outBuffer.toByteArray();
        int len = buff.length;
        this.outBuffer = null;
        this.dataOut = null;
        ChannelBuffer buffer = ChannelBuffers.directBuffer((int)(len + 5));
        buffer.writeByte((int)((byte)this.messageType));
        buffer.writeInt(len + 4);
        buffer.writeBytes(buff);
        Channels.write((ChannelHandlerContext)this.ctx, (ChannelFuture)this.message.getFuture(), (Object)buffer, (SocketAddress)this.message.getRemoteAddress());
    }

    private static void trace(String msg) {
        LogManager.logTrace((String)"org.teiid.ODBC", (Object[])new Object[]{msg});
    }

    private static int convertType(int type) {
        switch (type) {
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 2005: {
                return 25;
            }
            case 1: {
                return 1042;
            }
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 3: {
                return 1700;
            }
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -3: {
                return 17;
            }
            case 2004: {
                return 26;
            }
            case 2003: {
                return 1009;
            }
        }
        return 705;
    }
}

