/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.SessionToken;
import org.teiid.core.util.ArgCheck;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.TeiidLoginContext;

@ManagementObject(name="SessionService", componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class SessionServiceImpl
implements SessionService {
    public static final String SECURITY_DOMAINS = "securitydomains";
    private long sessionMaxLimit = 5000L;
    private long sessionExpirationTimeLimit = 0L;
    private VDBRepository vdbRepository;
    private SecurityHelper securityHelper;
    private DQPCore dqp;
    private Map<String, SessionMetadata> sessionCache = new ConcurrentHashMap<String, SessionMetadata>();
    private Timer sessionMonitor = new Timer("SessionMonitor", true);
    private LinkedList<String> securityDomains = new LinkedList();
    private LinkedList<String> adminSecurityDomains = new LinkedList();

    private void monitorSessions() {
        long currentTime = System.currentTimeMillis();
        for (SessionMetadata info : this.sessionCache.values()) {
            try {
                if (!info.isEmbedded() && currentTime - info.getLastPingTime() > 600000L) {
                    LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.keepaliveFailed", new Object[]{info.getSessionId()}));
                    this.closeSession(info.getSessionId());
                    continue;
                }
                if (this.sessionExpirationTimeLimit <= 0L || currentTime - info.getCreatedTime() <= this.sessionExpirationTimeLimit) continue;
                LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.expireSession", new Object[]{info.getSessionId()}));
                this.closeSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Throwable)e, (Object[])new Object[]{"error running session monitor, unable to monitor: " + info.getSessionId()});
            }
        }
    }

    public void closeSession(String sessionID) throws InvalidSessionException {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"closeSession", sessionID});
        SessionMetadata info = this.sessionCache.remove(sessionID);
        if (info == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        if (info.getVDBName() != null) {
            try {
                this.dqp.terminateSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (String)"Exception terminitating session");
            }
        }
        try {
            LoginContext context = info.getLoginContext();
            if (context != null) {
                context.logout();
            }
        }
        catch (LoginException e) {
            LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (String)"Exception terminitating session");
        }
    }

    public SessionMetadata createSession(String userName, Credentials credentials, String applicationName, Properties properties, boolean adminConnection, boolean authenticate) throws LoginException, SessionServiceException {
        ArgCheck.isNotNull((Object)applicationName);
        ArgCheck.isNotNull((Object)properties);
        LoginContext loginContext = null;
        String securityDomain = "none";
        Object securityContext = null;
        LinkedList<String> domains = this.securityDomains;
        if (adminConnection) {
            domains = this.adminSecurityDomains;
        }
        VDBMetaData vdb = null;
        String vdbName = properties.getProperty("VirtualDatabaseName");
        if (vdbName != null) {
            String vdbVersion = properties.getProperty("VirtualDatabaseVersion");
            vdb = this.getActiveVDB(vdbName, vdbVersion);
        }
        if (this.sessionMaxLimit > 0L && (long)this.getActiveSessionsCount() >= this.sessionMaxLimit) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("SessionServiceImpl.reached_max_sessions", new Object[]{new Long(this.sessionMaxLimit)}));
        }
        if (!domains.isEmpty() && authenticate) {
            boolean onlyAllowPassthrough = Boolean.valueOf(properties.getProperty("PassthroughAuthentication", "false"));
            TeiidLoginContext membership = this.authenticate(userName, credentials, applicationName, domains, this.securityHelper, onlyAllowPassthrough);
            loginContext = membership.getLoginContext();
            userName = membership.getUserName();
            securityDomain = membership.getSecurityDomain();
            securityContext = membership.getSecurityContext();
        }
        long creationTime = System.currentTimeMillis();
        SessionMetadata newSession = new SessionMetadata();
        newSession.setSessionToken(new SessionToken(userName));
        newSession.setSessionId(newSession.getSessionToken().getSessionID());
        newSession.setUserName(userName);
        newSession.setCreatedTime(creationTime);
        newSession.setApplicationName(applicationName);
        newSession.setClientHostName(properties.getProperty("clientHostName"));
        newSession.setIPAddress(properties.getProperty("clientIpAddress"));
        newSession.setSecurityDomain(securityDomain);
        if (vdb != null) {
            newSession.setVDBName(vdb.getName());
            newSession.setVDBVersion(vdb.getVersion());
        }
        newSession.setLoginContext(loginContext);
        newSession.setSecurityContext(securityContext);
        newSession.setVdb(vdb);
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful for \"", userName, "\" - created SessionID \"", "" + newSession.getSessionToken().getSessionID(), "\""});
        this.sessionCache.put(newSession.getSessionId(), newSession);
        return newSession;
    }

    VDBMetaData getActiveVDB(String vdbName, String vdbVersion) throws SessionServiceException {
        VDBMetaData vdb = null;
        int firstIndex = vdbName.indexOf(46);
        int lastIndex = vdbName.lastIndexOf(46);
        if (firstIndex != -1) {
            if (firstIndex != lastIndex || vdbVersion != null) {
                throw new SessionServiceException(RuntimePlugin.Util.getString("ambigious_name", new Object[]{vdbName, vdbVersion}));
            }
            vdbVersion = vdbName.substring(firstIndex + 1);
            vdbName = vdbName.substring(0, firstIndex);
        }
        try {
            if (vdbVersion == null) {
                vdbVersion = "latest";
                vdb = this.vdbRepository.getVDB(vdbName);
            } else {
                vdb = this.vdbRepository.getVDB(vdbName, Integer.parseInt(vdbVersion));
            }
        }
        catch (NumberFormatException e) {
            throw new SessionServiceException((Throwable)e, RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._3", new Object[]{vdbVersion}));
        }
        if (vdb == null) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._1", new Object[]{vdbName, vdbVersion}));
        }
        if (vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, vdbVersion}));
        }
        if (vdb.getConnectionType() == VDB.ConnectionType.NONE) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._4", new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, List<String> domains, SecurityHelper helper, boolean onlyallowPassthrough) throws LoginException {
        TeiidLoginContext membership = new TeiidLoginContext(helper);
        membership.authenticateUser(userName, credentials, applicationName, domains, onlyallowPassthrough);
        return membership;
    }

    public Collection<SessionMetadata> getActiveSessions() throws SessionServiceException {
        return new ArrayList<SessionMetadata>(this.sessionCache.values());
    }

    public SessionMetadata getActiveSession(String sessionID) {
        return this.sessionCache.get(sessionID);
    }

    public int getActiveSessionsCount() throws SessionServiceException {
        return this.sessionCache.size();
    }

    public Collection<SessionMetadata> getSessionsLoggedInToVDB(String VDBName, int vdbVersion) throws SessionServiceException {
        if (VDBName == null || vdbVersion <= 0) {
            return Collections.emptyList();
        }
        ArrayList<SessionMetadata> results = new ArrayList<SessionMetadata>();
        for (SessionMetadata info : this.sessionCache.values()) {
            if (!VDBName.equalsIgnoreCase(info.getVDBName()) || vdbVersion != info.getVDBVersion()) continue;
            results.add(info);
        }
        return results;
    }

    public void pingServer(String sessionID) throws InvalidSessionException {
        SessionMetadata info = this.getSessionInfo(sessionID);
        info.setLastPingTime(System.currentTimeMillis());
        this.sessionCache.put(sessionID, info);
    }

    public boolean terminateSession(String terminatedSessionID, String adminSessionID) {
        Object[] params = new Object[]{adminSessionID, terminatedSessionID};
        LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.terminateSession", params));
        try {
            this.closeSession(terminatedSessionID);
            return true;
        }
        catch (InvalidSessionException e) {
            LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (String)RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{e.getMessage()}));
            return false;
        }
    }

    public SessionMetadata validateSession(String sessionID) throws InvalidSessionException, SessionServiceException {
        SessionMetadata info = this.getSessionInfo(sessionID);
        return info;
    }

    private SessionMetadata getSessionInfo(String sessionID) throws InvalidSessionException {
        if (sessionID == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        SessionMetadata info = this.sessionCache.get(sessionID);
        if (info == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        return info;
    }

    @ManagementProperty(description="Maximum number of sessions allowed by the system (default 5000)")
    public long getSessionMaxLimit() {
        return this.sessionMaxLimit;
    }

    public void setSessionMaxLimit(long limit) {
        this.sessionMaxLimit = limit;
    }

    @ManagementProperty(description="Max allowed time before the session is terminated by the system, 0 indicates unlimited (default 0)")
    public long getSessionExpirationTimeLimit() {
        return this.sessionExpirationTimeLimit;
    }

    public void setSessionExpirationTimeLimit(long limit) {
        this.sessionExpirationTimeLimit = limit;
    }

    public void setSecurityDomains(String domainNameOrder) {
        if (domainNameOrder != null && domainNameOrder.trim().length() > 0) {
            String[] domainNames;
            LogManager.logInfo((String)"org.teiid.SECURITY", (String)"Security Enabled: true");
            for (String domainName : domainNames = domainNameOrder.split(",")) {
                this.securityDomains.addLast(domainName);
            }
        }
    }

    public void setAdminSecurityDomain(String domain) {
        this.adminSecurityDomains.add(domain);
        LogManager.logInfo((String)"org.teiid.SECURITY", (String)"Admin Security Enabled: true");
    }

    public void start() {
        this.sessionMonitor.schedule(new TimerTask(){

            @Override
            public void run() {
                SessionServiceImpl.this.monitorSessions();
            }
        }, 0L, 600000L);
    }

    public void stop() {
        this.sessionMonitor.cancel();
        this.sessionCache.clear();
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public void setDqp(DQPCore dqp) {
        this.dqp = dqp;
    }
}

