/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.teiid.core.util.Assertion;
import org.teiid.net.socket.SocketUtil;

public class SSLConfiguration {
    public static final String ONEWAY = "1-way";
    public static final String TWOWAY = "2-way";
    public static final String ANONYMOUS = "anonymous";
    public static final String LOGIN = "logIn";
    public static final String DISABLED = "disabled";
    public static final String ENABLED = "enabled";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private String mode = "logIn";
    private String sslProtocol = "TLSv1";
    private String keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
    private String keyStoreType = "JKS";
    private String keyStoreFileName;
    private String keyStorePassword = "";
    private String trustStoreFileName;
    private String trustStorePassword = "";
    private String authenticationMode = "1-way";

    public SSLEngine getServerSSLEngine() throws IOException, GeneralSecurityException {
        if (!this.isSslEnabled()) {
            return null;
        }
        SSLContext context = null;
        context = ANONYMOUS.equals(this.authenticationMode) ? SocketUtil.getAnonSSLContext() : SocketUtil.getSSLContext((String)this.keyStoreFileName, (String)this.keyStorePassword, (String)this.trustStoreFileName, (String)this.trustStorePassword, (String)this.keyManagerFactoryAlgorithm, (String)this.keyStoreType, (String)this.sslProtocol);
        SSLEngine result = context.createSSLEngine();
        result.setUseClientMode(false);
        if (ANONYMOUS.equals(this.authenticationMode)) {
            Assertion.assertTrue((boolean)Arrays.asList(result.getSupportedCipherSuites()).contains("TLS_DH_anon_WITH_AES_128_CBC_SHA"));
            result.setEnabledCipherSuites(new String[]{"TLS_DH_anon_WITH_AES_128_CBC_SHA"});
        }
        result.setNeedClientAuth(TWOWAY.equals(this.authenticationMode));
        return result;
    }

    public boolean isClientEncryptionEnabled() {
        return LOGIN.equals(this.mode);
    }

    public boolean isSslEnabled() {
        return ENABLED.equals(this.mode);
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setKeystoreFilename(String value) {
        this.keyStoreFileName = value;
    }

    public void setKeystorePassword(String value) {
        this.keyStorePassword = value;
    }

    public void setKeystoreType(String value) {
        this.keyStoreType = value;
    }

    public void setSslProtocol(String value) {
        this.sslProtocol = value;
    }

    public void setKeymanagementAlgorithm(String value) {
        this.keyManagerFactoryAlgorithm = value;
    }

    public void setTruststoreFilename(String value) {
        this.trustStoreFileName = value;
    }

    public void setTruststorePassword(String value) {
        this.trustStorePassword = value;
    }

    public void setAuthenticationMode(String value) {
        this.authenticationMode = value;
    }
}

