/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;

public class PgCatalogMetadataStore
extends MetadataFactory {
    private static final long serialVersionUID = 5391872008395637166L;
    private Random random;

    public PgCatalogMetadataStore(String modelName, Map<String, Datatype> dataTypes, Properties importProperties) throws TranslatorException {
        super(modelName, dataTypes, importProperties);
        this.add_pg_namespace();
        this.add_pg_class();
        this.add_pg_attribute();
        this.add_pg_type();
        this.add_pg_index();
        this.add_pg_am();
        this.add_pg_proc();
        this.add_pg_trigger();
        this.add_pg_attrdef();
        this.add_pg_database();
        this.add_pg_user();
    }

    protected void setUUID(AbstractMetadataRecord record) {
        byte[] randomBytes = new byte[8];
        if (this.random == null) {
            this.random = new Random(2010L);
        }
        this.random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        long msb = new BigInteger(randomBytes).longValue();
        this.random.nextBytes(randomBytes);
        randomBytes[0] = (byte)(randomBytes[0] & 0x3F);
        randomBytes[0] = (byte)(randomBytes[0] | 0x80);
        long lsb = new BigInteger(randomBytes).longValue();
        record.setUUID("mmuid:" + new UUID(msb, lsb));
    }

    private Table createView(String name) throws TranslatorException {
        Table t = this.addTable(name);
        t.setSystem(true);
        t.setSupportsUpdate(false);
        t.setVirtual(true);
        t.setTableType(Table.Type.Table);
        return t;
    }

    private Table add_pg_am() throws TranslatorException {
        Table t = this.createView("pg_am");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("amname", "string", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'btree' as amname";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attrdef() throws TranslatorException {
        Table t = this.createView("pg_attrdef");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("adsrc", "integer", (ColumnSet)t);
        this.addColumn("adrelid", "integer", (ColumnSet)t);
        this.addColumn("adnum", "integer", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 0 as adsrc, 0 as adrelid, 0 as adnum";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attribute() throws TranslatorException {
        Table t = this.createView("pg_attribute");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("attrelid", "integer", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        this.addColumn("atttypid", "integer", (ColumnSet)t);
        this.addColumn("attlen", "short", (ColumnSet)t);
        this.addColumn("attnum", "short", (ColumnSet)t);
        this.addColumn("atttypmod", "integer", (ColumnSet)t);
        this.addColumn("attnotnull", "boolean", (ColumnSet)t);
        this.addColumn("attisdropped", "boolean", (ColumnSet)t);
        this.addColumn("atthasdef", "boolean", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_attr", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, st.oid as attrelid, t1.Name as attname, pt.oid as atttypid,convert(t1.Length, short) as attlen, convert(t1.Position, short) as attnum, t1.Length as atttypmod, false as attnotnull, false as attisdropped, false as atthasdef FROM SYS.Columns as t1 LEFT OUTER JOIN SYS.Tables st ON (st.Name = t1.TableName AND st.SchemaName = t1.SchemaName) LEFT OUTER JOIN pg_catalog.pg_type pt ON (CASE WHEN (t1.DataType = 'clob' OR t1.DataType = 'blob') THEN 'lo' ELSE t1.DataType END = pt.typname)";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_class() throws TranslatorException {
        Table t = this.createView("pg_class");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("relname", "string", (ColumnSet)t);
        this.addColumn("relnamespace", "integer", (ColumnSet)t);
        this.addColumn("relkind", "char", (ColumnSet)t);
        this.addColumn("relam", "integer", (ColumnSet)t);
        this.addColumn("reltuples", "float", (ColumnSet)t);
        this.addColumn("relpages", "integer", (ColumnSet)t);
        this.addColumn("relhasrules", "boolean", (ColumnSet)t);
        this.addColumn("relhasoids", "string", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_class", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.name as relname, (SELECT OID FROM SYS.Schemas WHERE Name = t1.SchemaName) as relnamespace, convert((CASE t1.isPhysical WHEN true THEN 'r' ELSE 'v' END), char) as relkind,0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids FROM SYS.Tables t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_index() throws TranslatorException {
        Table t = this.createView("pg_index");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("indexrelid", "integer", (ColumnSet)t);
        this.addColumn("indrelid", "integer", (ColumnSet)t);
        this.addColumn("indisclustered", "boolean", (ColumnSet)t);
        this.addColumn("indisunique", "boolean", (ColumnSet)t);
        this.addColumn("indisprimary", "boolean", (ColumnSet)t);
        this.addColumn("indexprs", "string", (ColumnSet)t);
        this.addColumn("indkey", "string", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_index", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.OID as indexrelid, (SELECT OID FROM SYS.Tables WHERE SchemaName = t1.SchemaName AND Name = t1.TableName) as indrelid, false indisclustered, (CASE t1.KeyType WHEN 'Unique' THEN true ELSE false END) as indisunique, (CASE t1.KeyType WHEN 'Primary' THEN true ELSE false END) as indisprimary, '' as indexprs, 0 as indkey FROM SYS.KeyColumns as t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_namespace() throws TranslatorException {
        Table t = this.createView("pg_namespace");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("nspname", "string", (ColumnSet)t);
        String transformation = "SELECT t1.OID as oid, t1.Name as nspname FROM SYS.Schemas as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_proc() throws TranslatorException {
        Table t = this.createView("pg_proc");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("proname", "string", (ColumnSet)t);
        this.addColumn("proretset", "boolean", (ColumnSet)t);
        this.addColumn("prorettype", "integer", (ColumnSet)t);
        this.addColumn("pronargs", "short", (ColumnSet)t);
        this.addColumn("proargtypes", "object", (ColumnSet)t);
        this.addColumn("proargnames", "object", (ColumnSet)t);
        this.addColumn("proargmodes", "object", (ColumnSet)t);
        this.addColumn("proallargtypes", "object", (ColumnSet)t);
        this.addColumn("pronamespace", "integer", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_proc", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.Name as proname, false as proretset, (SELECT dt.OID FROM ProcedureParams pp, DataTypes dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type = 'ResultSet' AND pp.Position = 1 AND dt.Name = pp.DataType) as prorettype, convert((SELECT count(*) FROM ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName ), short) as pronargs, null as proargtypes, null as proargnames, null as proargmodes, null as proallargtypes, (SELECT OID FROM SYS.Schemas WHERE Name = t1.SchemaName) as pronamespace FROM SYS.Procedures as t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_trigger() throws TranslatorException {
        Table t = this.createView("pg_trigger");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("tgconstrrelid", "integer", (ColumnSet)t);
        this.addColumn("tgfoid", "integer", (ColumnSet)t);
        this.addColumn("tgargs", "integer", (ColumnSet)t);
        this.addColumn("tgnargs", "integer", (ColumnSet)t);
        this.addColumn("tgdeferrable", "boolean", (ColumnSet)t);
        this.addColumn("tginitdeferred", "boolean", (ColumnSet)t);
        this.addColumn("tgconstrname", "string", (ColumnSet)t);
        this.addColumn("tgrelid", "integer", (ColumnSet)t);
        String transformation = "SELECT 1 as oid, 1 as tgconstrrelid, 1 as tgfoid, 1 as tgargs, 1 as tgnargs, false as tgdeferrable, false as tginitdeferred, 'dummy' as tgconstrname, 1 as tgrelid FROM SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_type() throws TranslatorException {
        Table t = this.createView("pg_type");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("typnamespace", "integer", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addColumn("typrelid", "integer", (ColumnSet)t);
        String transformation = "SELECT 16 as oid,  'boolean' as typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(1, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid FROM (SELECT 1) X   union SELECT 1043 as oid,  'string' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(-1, short) as typlen, convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 25 as oid,  'text' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(-1, short) as typlen, convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 1042 as oid,  'char' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(1, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 21 as oid,  'short' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(2, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 20 as oid,  'long' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(8, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 23 as oid,  'int' as typname,   (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(4, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 26 as oid,  'oid' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typname,    convert(4, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 700 as oid,  'float' as typname,(SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(4, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 701 as oid,  'double' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(8, short) as typlen, convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 1082 as oid,  'date' as typname,  (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(4, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 1083 as oid,  'datetime' as typname,(SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(8, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 1114 as oid,  'timestamp' as typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace, convert(8, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 1700 as oid,  'decimal' as typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(-1, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 142 as oid,  'xml' as typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(-1, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X   union SELECT 14939 as oid,  'lo' as typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace,  convert(-1, short) as typlen,  convert('b', char) as typtype, 0 as typbasetype, -1 as typtypmod, 0 as typrelid  FROM (SELECT 1) X";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_database() throws TranslatorException {
        Table t = this.createView("pg_database");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("datname", "string", (ColumnSet)t);
        this.addColumn("encoding", "integer", (ColumnSet)t);
        this.addColumn("datlastsysoid", "integer", (ColumnSet)t);
        this.addColumn("datallowconn", "char", (ColumnSet)t);
        this.addColumn("datconfig", "object", (ColumnSet)t);
        this.addColumn("datacl", "object", (ColumnSet)t);
        this.addColumn("datdba", "integer", (ColumnSet)t);
        this.addColumn("dattablespace", "integer", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'teiid' as datname, 6 as encoding, 100000 as datlastsysoid, convert('t', char) as datallowconn, null, null, 0 as datdba, 0 as dattablespace";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_user() throws TranslatorException {
        Table t = this.createView("pg_user");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("usename", "string", (ColumnSet)t);
        this.addColumn("usecreatedb", "boolean", (ColumnSet)t);
        this.addColumn("usesuper", "boolean", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, null as usename, false as usecreatedb, false as usesuper ";
        t.setSelectTransformation(transformation);
        return t;
    }
}

