/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.deployers.spi.DeploymentException;
import org.teiid.adminapi.Translator;
import org.teiid.core.TeiidException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.ManagedPropertyUtil;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorProperty;

public class TranslatorUtil {
    public static Map<Method, TranslatorProperty> getTranslatorProperties(Class<?> attachmentClass) {
        HashMap<Method, TranslatorProperty> props = new HashMap<Method, TranslatorProperty>();
        TranslatorUtil.buildTranslatorProperties(attachmentClass, props);
        return props;
    }

    public static Properties getTranslatorPropertiesAsProperties(Class<?> attachmentClass) {
        Properties props = new Properties();
        try {
            Object instance = attachmentClass.newInstance();
            Map<Method, TranslatorProperty> tps = TranslatorUtil.getTranslatorProperties(attachmentClass);
            for (Method m : tps.keySet()) {
                Object defaultValue = ManagedPropertyUtil.getDefaultValue(instance, m, tps.get(m));
                if (defaultValue == null) continue;
                props.setProperty(TranslatorUtil.getPropertyName(m), defaultValue.toString());
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return props;
    }

    private static void buildTranslatorProperties(Class<?> attachmentClass, Map<Method, TranslatorProperty> props) {
        Class<?>[] baseInterfaces;
        Method[] methods;
        for (Method m : methods = attachmentClass.getMethods()) {
            TranslatorProperty tp = m.getAnnotation(TranslatorProperty.class);
            if (tp == null) continue;
            props.put(m, tp);
        }
        for (Class<?> clazz : baseInterfaces = attachmentClass.getInterfaces()) {
            TranslatorUtil.buildTranslatorProperties(clazz, props);
        }
        Class<?> superClass = attachmentClass.getSuperclass();
        if (superClass != null) {
            TranslatorUtil.buildTranslatorProperties(superClass, props);
        }
    }

    public static ExecutionFactory buildExecutionFactory(Translator data) throws DeploymentException {
        try {
            String executionClass = data.getPropertyValue("execution-factory-class");
            Object o = ReflectionHelper.create((String)executionClass, null, (ClassLoader)Thread.currentThread().getContextClassLoader());
            if (!(o instanceof ExecutionFactory)) {
                throw new DeploymentException(RuntimePlugin.Util.getString("invalid_class", new Object[]{executionClass}));
            }
            ExecutionFactory executionFactory = (ExecutionFactory)o;
            TranslatorUtil.injectProperties(executionFactory, data);
            executionFactory.start();
            return executionFactory;
        }
        catch (TeiidException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    private static void injectProperties(ExecutionFactory ef, Translator data) throws InvocationTargetException, IllegalAccessException, DeploymentException {
        Map<Method, TranslatorProperty> props = TranslatorUtil.getTranslatorProperties(ef.getClass());
        for (Method method : props.keySet()) {
            TranslatorProperty tp = props.get(method);
            String propertyName = TranslatorUtil.getPropertyName(method);
            String value = data.getPropertyValue(propertyName);
            if (value != null) {
                Method setterMethod = TranslatorUtil.getSetter(ef.getClass(), method);
                setterMethod.invoke((Object)ef, TranslatorUtil.convert(value, method.getReturnType()));
                continue;
            }
            if (!tp.required()) continue;
            throw new DeploymentException(RuntimePlugin.Util.getString("required_property_not_exists", new Object[]{tp.display()}));
        }
    }

    public static String getPropertyName(Method method) {
        String result = method.getName();
        if (result.startsWith("get") || result.startsWith("set")) {
            return result.substring(3);
        }
        if (result.startsWith("is")) {
            return result.substring(2);
        }
        return result;
    }

    public static Method getSetter(Class<?> clazz, Method method) throws SecurityException, DeploymentException {
        String setter = method.getName();
        setter = method.getName().startsWith("get") ? "set" + setter.substring(3) : (method.getName().startsWith("is") ? "set" + setter.substring(2) : "set" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1));
        try {
            return clazz.getMethod(setter, method.getReturnType());
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(method.getName(), method.getReturnType());
            }
            catch (NoSuchMethodException e1) {
                throw new DeploymentException(RuntimePlugin.Util.getString("no_set_method", new Object[]{setter, method.getName()}));
            }
        }
    }

    private static Object convert(Object value, Class<?> type) {
        if (value.getClass() == type) {
            return value;
        }
        if (value instanceof String) {
            String str = (String)value;
            return StringUtil.valueOf((String)str, type);
        }
        return value;
    }
}

