/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBException;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.virtual.VirtualFile;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.runtime.RuntimePlugin;

@ManagementObject
public class UDFMetaData {
    private Collection<Collection<FunctionMethod>> methods = new ArrayList<Collection<FunctionMethod>>();
    private HashMap<String, VirtualFile> files = new HashMap();

    public void addModelFile(VirtualFile file) {
        this.files.put(file.getPathName(), file);
    }

    void buildFunctionModelFile(String name) throws IOException, JAXBException {
        VirtualFile file;
        for (String f : this.files.keySet()) {
            if (!f.endsWith(name)) continue;
            name = f;
            break;
        }
        if ((file = this.files.get(name)) == null) {
            throw new IOException(RuntimePlugin.Util.getString("udf_model_not_found", new Object[]{name}));
        }
        this.methods.add(FunctionMetadataReader.loadFunctionMethods((InputStream)file.openStream()));
    }

    public Collection<Collection<FunctionMethod>> getFunctions() {
        return this.methods;
    }

    public void addFunctions(Collection<FunctionMethod> funcs) {
        this.methods.add(funcs);
    }

    public void addFunctions(UDFMetaData funcs) {
        this.methods.addAll(funcs.getFunctions());
    }
}

