/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import org.teiid.adminapi.Model;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

public class VDBStatusChecker {
    private static final String JAVA_CONTEXT = "java:";
    private VDBRepository vdbRepository;

    public void translatorAdded(String translatorName) {
        this.resourceAdded(translatorName, true);
    }

    public void translatorRemoved(String translatorName) {
        this.resourceremoved(translatorName, true);
    }

    public void dataSourceAdded(String dataSourceName) {
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        this.resourceAdded(dataSourceName, false);
    }

    public void dataSourceRemoved(String dataSourceName) {
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        this.resourceremoved(dataSourceName, false);
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceAdded(String resourceName, boolean translator) {
        for (VDBMetaData vdb : this.vdbRepository.getVDBs()) {
            if (vdb.getStatus() == VDB.Status.ACTIVE || vdb.isPreview()) continue;
            VDBMetaData vDBMetaData = vdb;
            synchronized (vDBMetaData) {
                ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
                for (Model m : vdb.getModels()) {
                    String sourceName;
                    ModelMetaData model = (ModelMetaData)m;
                    if (model.getErrors().isEmpty() || (sourceName = this.getSourceName(resourceName, model, translator)) == null) continue;
                    ConnectorManager cm = cmr.getConnectorManager(sourceName);
                    model.clearErrors();
                    String status = cm.getStausMessage();
                    if (status == null || status.length() <= 0) continue;
                    model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), status);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)status);
                }
                boolean valid = true;
                for (Model m : vdb.getModels()) {
                    ModelMetaData model = (ModelMetaData)m;
                    if (model.getErrors().isEmpty()) continue;
                    valid = false;
                    break;
                }
                if (valid) {
                    vdb.setStatus(VDB.Status.ACTIVE);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_activated", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceremoved(String resourceName, boolean translator) {
        for (VDBMetaData vdb : this.vdbRepository.getVDBs()) {
            if (vdb.isPreview()) continue;
            VDBMetaData vDBMetaData = vdb;
            synchronized (vDBMetaData) {
                for (Model m : vdb.getModels()) {
                    ModelMetaData model = (ModelMetaData)m;
                    String sourceName = this.getSourceName(resourceName, model, translator);
                    if (sourceName == null) continue;
                    vdb.setStatus(VDB.Status.INACTIVE);
                    String msg = null;
                    msg = translator ? RuntimePlugin.Util.getString("translator_not_found", new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName)}) : RuntimePlugin.Util.getString("datasource_not_found", new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName)});
                    model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), msg);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)msg);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_inactivated", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
        }
    }

    private String getSourceName(String translatorName, ModelMetaData model, boolean translator) {
        for (String sourceName : model.getSourceNames()) {
            if (translator) {
                if (!translatorName.equals(model.getSourceTranslatorName(sourceName))) continue;
                return sourceName;
            }
            String jndiName = model.getSourceConnectionJndiName(sourceName);
            if (jndiName.startsWith(JAVA_CONTEXT)) {
                jndiName = jndiName.substring(5);
            }
            if (!translatorName.equals(jndiName)) continue;
            return sourceName;
        }
        return null;
    }
}

