/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.transport.ChannelListener;

public class ODBCClientInstance
implements ChannelListener {
    private ODBCClientRemote client;
    private ODBCServerRemoteImpl server;
    private ReflectionHelper serverProxy = new ReflectionHelper(ODBCServerRemote.class);

    public ODBCClientInstance(final ObjectChannel channel, ODBCServerRemote.AuthenticationType authType) {
        this.client = (ODBCClientRemote)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ODBCClientRemote.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ServiceInvocationStruct message = new ServiceInvocationStruct(args, method.getName(), ODBCServerRemote.class);
                channel.write((Object)message);
                return null;
            }
        });
        this.server = new ODBCServerRemoteImpl(this.client, authType);
    }

    @Override
    public void disconnected() {
        this.server.terminate();
    }

    @Override
    public void exceptionOccurred(Throwable t) {
        this.server.terminate();
    }

    @Override
    public void onConnection() throws CommunicationException {
    }

    @Override
    public void receivedMessage(Object msg) throws CommunicationException {
        if (msg instanceof ServiceInvocationStruct) {
            this.processMessage((ServiceInvocationStruct)msg);
        }
    }

    private void processMessage(ServiceInvocationStruct serviceStruct) {
        try {
            Method m = this.serverProxy.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                m.invoke((Object)this.server, serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            this.client.errorOccurred(e);
        }
    }
}

