/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.UDFMetaData;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.vdb.runtime.VDBKey;

public class CompositeVDB {
    private VDBMetaData vdb;
    private MetadataStoreGroup stores;
    private LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap;
    private UDFMetaData udf;
    private LinkedHashMap<VDBKey, CompositeVDB> children;
    private MetadataStore[] additionalStores;
    private ConnectorManagerRepository cmr;
    private FunctionTree systemFunctions;
    private VDBMetaData mergedVDB;

    public CompositeVDB(VDBMetaData vdb, MetadataStoreGroup stores, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, FunctionTree systemFunctions, ConnectorManagerRepository cmr, MetadataStore ... additionalStores) {
        this.vdb = vdb;
        this.stores = stores;
        this.visibilityMap = visibilityMap;
        this.udf = udf;
        this.systemFunctions = systemFunctions;
        this.cmr = cmr;
        this.additionalStores = additionalStores;
        this.vdb.addAttchment(ConnectorManagerRepository.class, (Object)cmr);
        this.mergedVDB = vdb;
        this.update();
    }

    public void addChild(CompositeVDB child) {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        VDBMetaData childVDB = child.getVDB();
        this.children.put(new VDBKey(childVDB.getName(), childVDB.getVersion()), child);
        this.mergedVDB = null;
    }

    public void removeChild(VDBKey child) {
        if (this.children != null) {
            this.children.remove(child);
        }
        this.mergedVDB = null;
    }

    void update() {
        TransformationMetadata metadata = CompositeVDB.buildTransformationMetaData(this.mergedVDB, this.getVisibilityMap(), this.getMetadataStores(), this.getUDF(), this.systemFunctions, this.additionalStores);
        this.mergedVDB.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        this.mergedVDB.addAttchment(TransformationMetadata.class, (Object)metadata);
        TempTableStore globalTables = new TempTableStore("SYSTEM");
        this.mergedVDB.addAttchment(TempTableStore.class, (Object)globalTables);
    }

    private static TransformationMetadata buildTransformationMetaData(VDBMetaData vdb, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, MetadataStoreGroup stores, UDFMetaData udf, FunctionTree systemFunctions, MetadataStore[] additionalStores) {
        ArrayList<FunctionTree> udfs = new ArrayList<FunctionTree>();
        if (udf != null) {
            for (Map.Entry<String, Collection<FunctionMethod>> entry : udf.getFunctions().entrySet()) {
                udfs.add(new FunctionTree(entry.getKey(), (FunctionMetadataSource)new UDFSource(entry.getValue()), true));
            }
        }
        CompositeMetadataStore compositeStore = new CompositeMetadataStore(stores.getStores());
        for (MetadataStore s : additionalStores) {
            compositeStore.addMetadataStore(s);
            for (Schema schema : s.getSchemas().values()) {
                if (schema.getFunctions().isEmpty()) continue;
                udfs.add(new FunctionTree(schema.getName(), (FunctionMetadataSource)new UDFSource(schema.getFunctions().values()), true));
            }
        }
        TransformationMetadata metadata = new TransformationMetadata(vdb, compositeStore, visibilityMap, systemFunctions, udfs);
        return metadata;
    }

    public MetadataStore[] getAdditionalStores() {
        return this.additionalStores;
    }

    public VDBMetaData getVDB() {
        if (this.mergedVDB == null) {
            this.mergedVDB = this.buildVDB();
            this.update();
        }
        return this.mergedVDB;
    }

    private VDBMetaData buildVDB() {
        VDBMetaData newMergedVDB = new VDBMetaData();
        newMergedVDB.setName(this.vdb.getName());
        newMergedVDB.setVersion(this.vdb.getVersion());
        newMergedVDB.setModels(this.vdb.getModels());
        newMergedVDB.setDataPolicies(this.vdb.getDataPolicies());
        newMergedVDB.setDescription(this.vdb.getDescription());
        newMergedVDB.setStatus(this.vdb.getStatus());
        newMergedVDB.setJAXBProperties(this.vdb.getJAXBProperties());
        newMergedVDB.setConnectionType(this.vdb.getConnectionType());
        ConnectorManagerRepository mergedRepo = new ConnectorManagerRepository();
        mergedRepo.getConnectorManagers().putAll(this.cmr.getConnectorManagers());
        for (CompositeVDB child : this.children.values()) {
            for (Model m : child.getVDB().getModels()) {
                newMergedVDB.addModel((ModelMetaData)m);
            }
            for (DataPolicy p : child.getVDB().getDataPolicies()) {
                newMergedVDB.addDataPolicy((DataPolicyMetadata)p);
            }
            mergedRepo.getConnectorManagers().putAll(child.cmr.getConnectorManagers());
        }
        newMergedVDB.addAttchment(ConnectorManagerRepository.class, (Object)mergedRepo);
        return newMergedVDB;
    }

    private UDFMetaData getUDF() {
        Object funcs;
        UDFMetaData mergedUDF = new UDFMetaData();
        if (this.udf != null) {
            mergedUDF.addFunctions(this.udf);
        }
        if (this.stores != null) {
            for (MetadataStore store : this.stores.getStores()) {
                for (Schema schema : store.getSchemas().values()) {
                    Collection<FunctionMethod> funcs2 = schema.getFunctions().values();
                    mergedUDF.addFunctions(schema.getName(), funcs2);
                }
            }
        }
        if (this.cmr != null) {
            for (ConnectorManager cm : this.cmr.getConnectorManagers().values()) {
                funcs = cm.getPushDownFunctions();
                mergedUDF.addFunctions("SYS", (Collection<FunctionMethod>)funcs);
            }
        }
        if (this.children != null) {
            for (CompositeVDB child : this.children.values()) {
                funcs = child.getUDF();
                if (funcs == null) continue;
                mergedUDF.addFunctions((UDFMetaData)funcs);
            }
        }
        return mergedUDF;
    }

    private LinkedHashMap<String, TransformationMetadata.Resource> getVisibilityMap() {
        if (this.children == null || this.children.isEmpty()) {
            return this.visibilityMap;
        }
        LinkedHashMap<String, TransformationMetadata.Resource> mergedvisibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        if (this.visibilityMap != null) {
            mergedvisibilityMap.putAll(this.visibilityMap);
        }
        for (CompositeVDB child : this.children.values()) {
            LinkedHashMap<String, TransformationMetadata.Resource> vm = child.getVisibilityMap();
            if (vm == null) continue;
            mergedvisibilityMap.putAll(vm);
        }
        return mergedvisibilityMap;
    }

    public MetadataStoreGroup getMetadataStores() {
        if (this.children == null || this.children.isEmpty()) {
            return this.stores;
        }
        MetadataStoreGroup mergedStores = new MetadataStoreGroup();
        if (this.stores != null) {
            mergedStores.addStores(this.stores.getStores());
        }
        for (CompositeVDB child : this.children.values()) {
            MetadataStoreGroup childStores = child.getMetadataStores();
            if (childStores == null) continue;
            mergedStores.addStores(childStores.getStores());
        }
        return mergedStores;
    }
}

