/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.deployers.spi.DeploymentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.types.DataTypeManager;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final long serialVersionUID = 312177538191772674L;
    private NavigableMap<VDBKey, CompositeVDB> vdbRepo = new ConcurrentSkipListMap<VDBKey, CompositeVDB>();
    private MetadataStore systemStore;
    private MetadataStore odbcStore;
    private boolean odbcEnabled = false;
    private List<VDBLifeCycleListener> listeners = new CopyOnWriteArrayList<VDBLifeCycleListener>();
    private SystemFunctionManager systemFunctionManager;
    private MetadataRepository metadataRepository;

    public MetadataRepository getMetadataRepository() {
        return this.metadataRepository;
    }

    public void addVDB(VDBMetaData vdb, MetadataStoreGroup stores, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, ConnectorManagerRepository cmr) throws DeploymentException {
        if (this.getVDB(vdb.getName(), vdb.getVersion()) != null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("duplicate_vdb", new Object[]{vdb.getName(), vdb.getVersion()}));
        }
        if (this.systemStore == null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("system_vdb_load_error"));
        }
        if (this.odbcEnabled && this.odbcStore == null) {
            this.odbcStore = this.getODBCMetadataStore();
        }
        CompositeVDB cvdb = null;
        cvdb = this.odbcStore == null ? new CompositeVDB(vdb, stores, visibilityMap, udf, this.systemFunctionManager.getSystemFunctions(), cmr, this.systemStore) : new CompositeVDB(vdb, stores, visibilityMap, udf, this.systemFunctionManager.getSystemFunctions(), cmr, this.systemStore, this.odbcStore);
        this.vdbRepo.put(this.vdbId(vdb), cvdb);
        this.notifyAdd(vdb.getName(), vdb.getVersion());
    }

    private void updateFromMetadataRepository(CompositeVDB cvdb) {
        if (this.metadataRepository == null) {
            return;
        }
        String vdbName = cvdb.getVDB().getName();
        int vdbVersion = cvdb.getVDB().getVersion();
        LinkedList<MetadataStore> allStores = new LinkedList<MetadataStore>(cvdb.getMetadataStores().getStores());
        allStores.addAll(Arrays.asList(cvdb.getAdditionalStores()));
        this.metadataRepository.startLoadVdb(vdbName, vdbVersion);
        for (MetadataStore metadataStore : allStores) {
            LinkedHashSet<Object> records = new LinkedHashSet<Object>();
            for (Schema schema : metadataStore.getSchemas().values()) {
                records.add(schema);
                for (Table t : schema.getTables().values()) {
                    Boolean enabled;
                    records.add(t);
                    records.addAll(t.getColumns());
                    records.addAll(t.getAllKeys());
                    if (t.isPhysical()) {
                        TableStats stats = this.metadataRepository.getTableStats(vdbName, vdbVersion, t);
                        if (stats != null) {
                            t.setTableStats(stats);
                        }
                        for (Column c : t.getColumns()) {
                            ColumnStats cStats = this.metadataRepository.getColumnStats(vdbName, vdbVersion, c);
                            if (cStats == null) continue;
                            c.setColumnStats(cStats);
                        }
                        continue;
                    }
                    String def = this.metadataRepository.getViewDefinition(vdbName, vdbVersion, t);
                    if (def != null) {
                        t.setSelectTransformation(def);
                    }
                    if (!t.supportsUpdate()) continue;
                    def = this.metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, t, Table.TriggerEvent.INSERT);
                    if (def != null) {
                        t.setInsertPlan(def);
                    }
                    if ((enabled = this.metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, t, Table.TriggerEvent.INSERT)) != null) {
                        t.setInsertPlanEnabled(enabled.booleanValue());
                    }
                    if ((def = this.metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, t, Table.TriggerEvent.UPDATE)) != null) {
                        t.setUpdatePlan(def);
                    }
                    if ((enabled = this.metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, t, Table.TriggerEvent.UPDATE)) != null) {
                        t.setUpdatePlanEnabled(enabled.booleanValue());
                    }
                    if ((def = this.metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, t, Table.TriggerEvent.DELETE)) != null) {
                        t.setDeletePlan(def);
                    }
                    if ((enabled = this.metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, t, Table.TriggerEvent.DELETE)) == null) continue;
                    t.setDeletePlanEnabled(enabled.booleanValue());
                }
                for (Procedure p : schema.getProcedures().values()) {
                    String proc;
                    records.add(p);
                    records.addAll(p.getParameters());
                    if (p.getResultSet() != null) {
                        records.addAll(p.getResultSet().getColumns());
                    }
                    if (!p.isVirtual() || p.isFunction() || (proc = this.metadataRepository.getProcedureDefinition(vdbName, vdbVersion, p)) == null) continue;
                    p.setQueryPlan(proc);
                }
            }
            for (AbstractMetadataRecord abstractMetadataRecord : records) {
                LinkedHashMap p = this.metadataRepository.getProperties(vdbName, vdbVersion, abstractMetadataRecord);
                if (p == null) continue;
                abstractMetadataRecord.setProperties(p);
            }
        }
        this.metadataRepository.endLoadVdb(vdbName, vdbVersion);
    }

    public VDBMetaData getVDB(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        return vdbs;
    }

    protected VDBKey vdbId(VDBMetaData vdb) {
        return new VDBKey(vdb.getName(), vdb.getVersion());
    }

    public VDBMetaData getVDB(String vdbName) {
        int latestVersion = 0;
        for (VDBKey key : this.vdbRepo.tailMap(new VDBKey(vdbName, 0)).keySet()) {
            if (!key.getName().equalsIgnoreCase(vdbName)) break;
            VDBMetaData vdb = ((CompositeVDB)this.vdbRepo.get(key)).getVDB();
            switch (vdb.getConnectionType()) {
                case ANY: {
                    latestVersion = Math.max(vdb.getVersion(), latestVersion);
                    break;
                }
                case BY_VERSION: {
                    if (latestVersion != 0) break;
                    latestVersion = vdb.getVersion();
                }
            }
        }
        if (latestVersion == 0) {
            return null;
        }
        return this.getVDB(vdbName, latestVersion);
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }

    public MetadataStore getODBCStore() {
        return this.odbcStore;
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
    }

    public void setMetadataRepository(MetadataRepository metadataRepository) {
        this.metadataRepository = metadataRepository;
    }

    private MetadataStore getODBCMetadataStore() {
        try {
            PgCatalogMetadataStore pg = new PgCatalogMetadataStore("pg_catalog", this.getBuiltinDatatypes(), new Properties());
            return pg.getMetadataStore();
        }
        catch (TranslatorException e) {
            LogManager.logError((String)"org.teiid.PROCESSOR", (String)RuntimePlugin.Util.getString("failed_to_load_odbc_metadata"));
            return null;
        }
    }

    public void odbcEnabled() {
        this.odbcEnabled = true;
    }

    public boolean removeVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        CompositeVDB removed = (CompositeVDB)this.vdbRepo.remove(key);
        if (removed != null) {
            for (CompositeVDB other : this.vdbRepo.values()) {
                other.removeChild(key);
            }
            this.notifyRemove(key.getName(), key.getVersion());
            return true;
        }
        return false;
    }

    public Map<String, Datatype> getBuiltinDatatypes() {
        Collection datatypes = this.systemStore.getDatatypes();
        HashMap<String, Datatype> datatypeMap = new HashMap<String, Datatype>();
        block0: for (Class typeClass : DataTypeManager.getAllDataTypeClasses()) {
            for (Datatype datatypeRecordImpl : datatypes) {
                if (!datatypeRecordImpl.getJavaClassName().equals(typeClass.getName())) continue;
                datatypeMap.put(DataTypeManager.getDataTypeName((Class)typeClass), datatypeRecordImpl);
                continue block0;
            }
        }
        return datatypeMap;
    }

    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        CompositeVDB source = (CompositeVDB)this.vdbRepo.get(new VDBKey(sourceVDBName, sourceVDBVersion));
        if (source == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        CompositeVDB target = (CompositeVDB)this.vdbRepo.get(new VDBKey(targetVDBName, targetVDBVersion));
        if (target == null) {
            throw new AdminProcessingException(RuntimePlugin.Util.getString("vdb_not_found", new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        target.addChild(source);
    }

    public void start() {
        if (this.odbcEnabled) {
            this.odbcStore = this.getODBCMetadataStore();
        }
    }

    public void finishDeployment(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            this.updateFromMetadataRepository(v);
            v.update();
        }
    }

    public void addListener(VDBLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(VDBLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAdd(String name, int version) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.added(name, version);
        }
    }

    private void notifyRemove(String name, int version) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.removed(name, version);
        }
    }

    public void setSystemFunctionManager(SystemFunctionManager mgr) {
        this.systemFunctionManager = mgr;
    }
}

