/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.ScriptReader;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ODBCClientInstance;

public class ODBCServerRemoteImpl
implements ODBCServerRemote {
    private static final String UNNAMED = "UNNAMED";
    private static Pattern setPattern = Pattern.compile("(SET|set)\\s+(\\w+)\\s+(TO|to)\\s+'(\\w+\\d*)'");
    private static Pattern pkPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+).*");
    private static Pattern pkKeyPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_index i, pg_catalog.pg_namespace n where ic.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+) .*");
    private Pattern fkPattern = Pattern.compile("select\\s+((?:'[^']*')+)::name as PKTABLE_CAT,\\s+n2.nspname as PKTABLE_SCHEM,\\s+c2.relname as PKTABLE_NAME,\\s+a2.attname as PKCOLUMN_NAME,\\s+((?:'[^']*')+)::name as FKTABLE_CAT,\\s+n1.nspname as FKTABLE_SCHEM,\\s+c1.relname as FKTABLE_NAME,\\s+a1.attname as FKCOLUMN_NAME,\\s+i::int2 as KEY_SEQ,\\s+case ref.confupdtype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as UPDATE_RULE,\\s+case ref.confdeltype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as DELETE_RULE,\\s+ref.conname as FK_NAME,\\s+cn.conname as PK_NAME,\\s+case\\s+when ref.condeferrable then\\s+case\\s+when ref.condeferred then (\\d)::int2\\s+else (\\d)::int2\\s+end\\s+else (\\d)::int2\\s+end as DEFERRABLITY\\s+from\\s+\\(\\(\\(\\(\\(\\(\\( \\(select cn.oid, conrelid, conkey, confrelid, confkey,\\s+generate_series\\(array_lower\\(conkey, 1\\), array_upper\\(conkey, 1\\)\\) as i,\\s+confupdtype, confdeltype, conname,\\s+condeferrable, condeferred\\s+from pg_catalog.pg_constraint cn,\\s+pg_catalog.pg_class c,\\s+pg_catalog.pg_namespace n\\s+where contype = 'f' \\s+and  conrelid = c.oid\\s+and  relname = (E?(?:'[^']*')+)\\s+and  n.oid = c.relnamespace\\s+and  n.nspname = (E?(?:'[^']*')+)\\s+\\) ref\\s+inner join pg_catalog.pg_class c1\\s+on c1.oid = ref.conrelid\\)\\s+inner join pg_catalog.pg_namespace n1\\s+on  n1.oid = c1.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a1\\s+on  a1.attrelid = c1.oid\\s+and  a1.attnum = conkey\\[i\\]\\)\\s+inner join pg_catalog.pg_class c2\\s+on  c2.oid = ref.confrelid\\)\\s+inner join pg_catalog.pg_namespace n2\\s+on  n2.oid = c2.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a2\\s+on  a2.attrelid = c2.oid\\s+and  a2.attnum = confkey\\[i\\]\\)\\s+left outer join pg_catalog.pg_constraint cn\\s+on cn.conrelid = ref.confrelid\\s+and cn.contype = 'p'\\)\\s+order by ref.oid, ref.i");
    private static Pattern preparedAutoIncrement = Pattern.compile("select 1 \\s*from pg_catalog.pg_attrdef \\s*where adrelid = \\$1 AND adnum = \\$2 \\s*and pg_catalog.pg_get_expr\\(adbin, adrelid\\) \\s*like '%nextval\\(%'", 2);
    private static Pattern deallocatePattern = Pattern.compile("DEALLOCATE \"(\\w+\\d+_*)\"");
    private static Pattern releasePattern = Pattern.compile("RELEASE (\\w+\\d+_*)");
    private static Pattern savepointPattern = Pattern.compile("SAVEPOINT (\\w+\\d+_*)");
    private static Pattern rollbackPattern = Pattern.compile("ROLLBACK\\s*(to)*\\s*(\\w+\\d+_*)*");
    private TeiidDriver driver;
    private ODBCClientRemote client;
    private Properties props;
    private ODBCServerRemote.AuthenticationType authType;
    private ConnectionImpl connection;
    private boolean executing;
    private boolean errorOccurred;
    private volatile ResultsFuture<Boolean> executionFuture;
    private Map<String, Prepared> preparedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Portal> portalMap = Collections.synchronizedMap(new HashMap());

    public ODBCServerRemoteImpl(ODBCClientInstance client, ODBCServerRemote.AuthenticationType authType, TeiidDriver driver) {
        this.driver = driver;
        this.client = client.getClient();
        this.authType = authType;
    }

    @Override
    public void initialize(Properties props) {
        this.props = props;
        this.client.initialized(this.props);
        if (this.authType.equals((Object)ODBCServerRemote.AuthenticationType.CLEARTEXT)) {
            this.client.useClearTextAuthentication();
        } else if (this.authType.equals((Object)ODBCServerRemote.AuthenticationType.MD5)) {
            // empty if block
        }
    }

    @Override
    public void logon(String databaseName, String user, String password) {
        try {
            Properties info = new Properties();
            String url = "jdbc:teiid:" + databaseName + ";ApplicationName=ODBC";
            info.put("user", user);
            info.put("password", password);
            this.connection = (ConnectionImpl)this.driver.connect(url, info);
            int hash = this.connection.getConnectionId().hashCode();
            Enumeration<?> keys = this.props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StatementImpl stmt = this.connection.createStatement();
                stmt.execute("SET " + key + " '" + this.props.getProperty(key) + "'");
                stmt.close();
            }
            this.client.authenticationSucess(hash, hash);
            this.ready();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            this.terminate();
        }
    }

    @Override
    public void prepare(String prepareName, String sql, int[] paramType) {
        if (this.connection != null) {
            if (prepareName == null || prepareName.length() == 0) {
                prepareName = UNNAMED;
            }
            if (sql != null) {
                String modfiedSQL = this.fixSQL(sql);
                try {
                    Prepared previous = this.preparedMap.remove(prepareName);
                    if (previous != null) {
                        previous.stmt.close();
                    }
                    PreparedStatementImpl stmt = this.connection.prepareStatement(modfiedSQL);
                    this.preparedMap.put(prepareName, new Prepared(prepareName, sql, stmt, paramType));
                    this.client.prepareCompleted(prepareName);
                }
                catch (SQLException e) {
                    this.errorOccurred(e);
                }
            }
        } else {
            this.errorOccurred(RuntimePlugin.Util.getString("no_active_connection"));
        }
    }

    @Override
    public void bindParameters(String bindName, String prepareName, int paramCount, Object[] params, int resultCodeCount, int[] resultColumnFormat) {
        Prepared previous;
        this.portalMap.remove(UNNAMED);
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((previous = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("bad_binding", new Object[]{prepareName}));
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        try {
            for (int i = 0; i < paramCount; ++i) {
                previous.stmt.setObject(i + 1, params[i]);
            }
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
        this.portalMap.put(bindName, new Portal(bindName, prepareName, previous.sql, previous.stmt, resultColumnFormat));
        this.client.bindComplete();
    }

    @Override
    public void unsupportedOperation(String msg) {
        this.errorOccurred(msg);
    }

    @Override
    public void execute(String bindName, int maxRows) {
        Portal query;
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            if (query.sql.trim().isEmpty()) {
                this.client.emptyQueryReceived();
                return;
            }
            final PreparedStatementImpl stmt = query.stmt;
            try {
                if (maxRows != 0) {
                    stmt.setMaxRows(maxRows);
                }
                this.executionFuture = stmt.submitExecute();
                this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                    public void onCompletion(ResultsFuture<Boolean> future) {
                        ODBCServerRemoteImpl.this.executionFuture = null;
                        try {
                            ResultsFuture result = null;
                            if (((Boolean)future.get()).booleanValue()) {
                                result = new ResultsFuture();
                                ODBCServerRemoteImpl.this.client.sendResults(query.sql, stmt.getResultSet(), (ResultsFuture<Void>)result, true);
                            } else {
                                result = ResultsFuture.NULL_FUTURE;
                                ODBCServerRemoteImpl.this.client.sendUpdateCount(query.sql, stmt.getUpdateCount());
                                ODBCServerRemoteImpl.this.setEncoding();
                            }
                            result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Void>(){

                                public void onCompletion(ResultsFuture<Void> future) {
                                    try {
                                        future.get();
                                        ODBCServerRemoteImpl.this.doneExecuting();
                                    }
                                    catch (InterruptedException e) {
                                        throw new AssertionError((Object)e);
                                    }
                                    catch (ExecutionException e) {
                                        ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            ODBCServerRemoteImpl.this.errorOccurred(e);
                        }
                    }
                });
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    private String fixSQL(String sql) {
        String modified = this.modifySQL(sql);
        if (modified != null && !modified.equals(sql)) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object[])new Object[]{"Modified Query:", modified});
        }
        return modified;
    }

    private String modifySQL(String sql) {
        String modified = sql;
        if (sql == null) {
            return null;
        }
        if (StringUtil.startsWithIgnoreCase((String)sql, (String)"select")) {
            modified = sql.replace('\n', ' ');
            Matcher m = null;
            m = pkPattern.matcher(modified);
            if (m.matches()) {
                return new StringBuffer("SELECT k.Name AS attname, convert(Position, short) AS attnum, TableName AS relname, SchemaName AS nspname, TableName AS relname").append(" FROM SYS.KeyColumns k").append(" WHERE ").append(" UCASE(SchemaName)").append(" LIKE UCASE(").append(m.group(2)).append(")").append(" AND UCASE(TableName)").append(" LIKE UCASE(").append(m.group(1)).append(")").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY attnum").toString();
            }
            m = pkKeyPattern.matcher(modified);
            if (m.matches()) {
                String tableName = m.group(1);
                if (tableName.endsWith("_pkey'")) {
                    tableName = tableName.substring(0, tableName.length() - 6) + '\'';
                    return "select ia.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_namespace n, Sys.KeyColumns kc where ic.relname = " + tableName + " AND n.nspname = " + m.group(2) + " AND " + "n.oid = ic.relnamespace AND ia.attrelid = ic.oid AND kc.SchemaName = n.nspname " + "AND kc.TableName = ic.relname AND kc.KeyType = 'Primary' AND kc.Name = ia.attname order by ia.attnum";
                }
                return "SELECT NULL, NULL, NULL, NULL, NULL FROM (SELECT 1) as X WHERE 0=1";
            }
            m = this.fkPattern.matcher(modified);
            if (m.matches()) {
                return "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE PKTABLE_NAME LIKE " + m.group(14) + " and PKTABLE_SCHEM LIKE " + m.group(15);
            }
            if (modified.equalsIgnoreCase("select version()")) {
                return "SELECT 'Teiid " + ApplicationInfo.getInstance().getReleaseNumber() + "'";
            }
            if (modified.startsWith("SELECT name FROM master..sysdatabases")) {
                return "SELECT 'Teiid'";
            }
            if (modified.equalsIgnoreCase("select db_name() dbname")) {
                return "SELECT current_database()";
            }
            if (preparedAutoIncrement.matcher(modified).matches()) {
                return "SELECT 1 from matpg_relatt where attrelid = ? and attnum = ? and autoinc = true";
            }
            if (sql.equalsIgnoreCase("select current_schema()")) {
                return "SELECT ''";
            }
        } else {
            if (sql.equalsIgnoreCase("show max_identifier_length")) {
                return "select 63";
            }
            Matcher m = setPattern.matcher(sql);
            if (m.matches()) {
                return "SET " + m.group(2) + " " + m.group(4);
            }
            if (modified.equalsIgnoreCase("BEGIN")) {
                return "START TRANSACTION";
            }
            m = rollbackPattern.matcher(modified);
            if (m.matches()) {
                return "ROLLBACK";
            }
            m = savepointPattern.matcher(modified);
            if (m.matches()) {
                return "SELECT 'SAVEPOINT'";
            }
            m = releasePattern.matcher(modified);
            if (m.matches()) {
                return "SELECT 'RELEASE'";
            }
            m = deallocatePattern.matcher(modified);
            if (m.matches()) {
                this.closePreparedStatement(m.group(1));
                return "SELECT 'DEALLOCATE'";
            }
        }
        modified = sql;
        modified = modified.replaceAll("::[A-Za-z0-9]*", " ");
        modified = modified.replaceAll("'pg_toast'", "'SYS'");
        return modified;
    }

    @Override
    public void executeQuery(String query) {
        if (this.beginExecution()) {
            this.client.errorOccurred("Awaiting asynch result");
            this.ready();
            return;
        }
        this.portalMap.remove(UNNAMED);
        this.preparedMap.remove(UNNAMED);
        if (query.trim().length() == 0) {
            this.client.emptyQueryReceived();
            this.ready();
            return;
        }
        QueryWorkItem r = new QueryWorkItem(query);
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginExecution() {
        if (this.executionFuture != null) {
            return true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.executing = true;
        }
        return false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    @Override
    public void getParameterDescription(String prepareName) {
        Prepared query;
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((query = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{prepareName}));
        } else {
            try {
                this.client.sendParameterDescription(query.stmt.getParameterMetaData(), query.paramType);
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(String error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(Throwable error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    @Override
    public void getResultSetMetaDataDescription(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                this.client.sendResultSetDescription(query.stmt.getMetaData(), (Statement)query.stmt);
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    @Override
    public void sync() {
        this.ready();
    }

    protected synchronized void doneExecuting() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ready() {
        boolean inTxn = false;
        boolean failedTxn = false;
        try {
            if (!this.connection.getAutoCommit()) {
                inTxn = true;
            }
        }
        catch (SQLException e) {
            failedTxn = true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = false;
        }
        this.client.ready(inTxn, failedTxn);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void closeBoundStatement(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.remove(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                if (this.connection.getAutoCommit()) {
                    this.closePreparedStatement(bindName);
                }
            }
            catch (SQLException e) {
                this.closePreparedStatement(bindName);
            }
        }
    }

    @Override
    public void closePreparedStatement(String preparedName) {
        Prepared query;
        if (preparedName == null || preparedName.length() == 0) {
            preparedName = UNNAMED;
        }
        if ((query = this.preparedMap.remove(preparedName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{preparedName}));
        } else {
            this.portalMap.remove(preparedName);
            try {
                query.stmt.close();
                this.client.statementClosed();
            }
            catch (SQLException e) {
                this.errorOccurred(RuntimePlugin.Util.getString("error_closing_stmt", new Object[]{preparedName}));
            }
        }
    }

    @Override
    public void terminate() {
        for (Portal portal : this.portalMap.values()) {
            try {
                portal.stmt.close();
            }
            catch (SQLException e) {}
        }
        for (Prepared prepared : this.preparedMap.values()) {
            try {
                prepared.stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.client.terminated();
    }

    @Override
    public void flush() {
        this.client.flush();
    }

    @Override
    public void functionCall(int oid) {
        this.errorOccurred(RuntimePlugin.Util.getString("lo_not_supported"));
    }

    @Override
    public void sslRequest() {
        this.client.sslDenied();
    }

    private void setEncoding() {
        try {
            String encoding;
            StatementImpl t = this.connection.createStatement();
            ResultSet rs = t.executeQuery("show client_encoding");
            if (rs.next() && (encoding = rs.getString(1)) != null) {
                this.client.setEncoding(encoding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class Portal {
        String name;
        String preparedName;
        String sql;
        int[] resultColumnFormat;
        PreparedStatementImpl stmt;

        public Portal(String name, String preparedName, String sql, PreparedStatementImpl stmt, int[] resultColumnformat) {
            this.name = name;
            this.preparedName = preparedName;
            this.sql = sql;
            this.stmt = stmt;
            this.resultColumnFormat = resultColumnformat;
        }
    }

    static class Prepared {
        String name;
        String sql;
        PreparedStatementImpl stmt;
        int[] paramType;

        public Prepared(String name, String sql, PreparedStatementImpl stmt, int[] paramType) {
            this.name = name;
            this.sql = sql;
            this.stmt = stmt;
            this.paramType = paramType;
        }
    }

    private final class QueryWorkItem
    implements Runnable {
        private final ScriptReader reader;
        String modfiedSQL;
        String sql;

        private QueryWorkItem(String query) {
            this.reader = new ScriptReader(new StringReader(query));
        }

        @Override
        public void run() {
            try {
                if (this.modfiedSQL == null) {
                    this.sql = this.reader.readStatement();
                    this.modfiedSQL = ODBCServerRemoteImpl.this.fixSQL(this.sql);
                }
                if (this.modfiedSQL != null) {
                    try {
                        final StatementImpl stmt = ODBCServerRemoteImpl.this.connection.createStatement();
                        ODBCServerRemoteImpl.this.executionFuture = stmt.submitExecute(this.modfiedSQL);
                        ODBCServerRemoteImpl.this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                            public void onCompletion(ResultsFuture<Boolean> future) {
                                ODBCServerRemoteImpl.this.executionFuture = null;
                                try {
                                    ResultsFuture result = null;
                                    if (((Boolean)future.get()).booleanValue()) {
                                        if (stmt.getResultSet() != null) {
                                            result = new ResultsFuture();
                                            ODBCServerRemoteImpl.this.client.sendResults(QueryWorkItem.this.sql, stmt.getResultSet(), (ResultsFuture<Void>)result, true);
                                        } else {
                                            result = ResultsFuture.NULL_FUTURE;
                                            ODBCServerRemoteImpl.this.client.sendUpdateCount(QueryWorkItem.this.sql, 0);
                                        }
                                    } else {
                                        result = ResultsFuture.NULL_FUTURE;
                                        ODBCServerRemoteImpl.this.client.sendUpdateCount(QueryWorkItem.this.sql, stmt.getUpdateCount());
                                        ODBCServerRemoteImpl.this.setEncoding();
                                    }
                                    result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Void>(){

                                        /*
                                         * Exception decompiling
                                         */
                                        public void onCompletion(ResultsFuture<Void> future) {
                                            /*
                                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                             * 
                                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                             */
                                            throw new IllegalStateException("Decompilation failed");
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    ODBCServerRemoteImpl.this.client.errorOccurred(e);
                                    return;
                                }
                            }
                        });
                        return;
                    }
                    catch (SQLException e) {
                        ODBCServerRemoteImpl.this.client.errorOccurred(e);
                    }
                }
            }
            catch (IOException e) {
                ODBCServerRemoteImpl.this.client.errorOccurred(e);
            }
            ODBCServerRemoteImpl.this.doneExecuting();
            ODBCServerRemoteImpl.this.ready();
        }

        static /* synthetic */ ScriptReader access$700(QueryWorkItem x0) {
            return x0.reader;
        }
    }
}

