/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.transport.PGCharsetConverter;
import org.teiid.transport.pg.PGbytea;

public class PgBackendProtocol
implements ChannelDownstreamHandler,
ODBCClientRemote {
    private static final int PG_TYPE_VARCHAR = 1043;
    private static final int PG_TYPE_BOOL = 16;
    private static final int PG_TYPE_BYTEA = 17;
    private static final int PG_TYPE_BPCHAR = 1042;
    private static final int PG_TYPE_INT8 = 20;
    private static final int PG_TYPE_INT2 = 21;
    private static final int PG_TYPE_INT4 = 23;
    private static final int PG_TYPE_TEXT = 25;
    private static final int PG_TYPE_FLOAT4 = 700;
    private static final int PG_TYPE_FLOAT8 = 701;
    private static final int PG_TYPE_UNKNOWN = 705;
    private static final int PG_TYPE_OIDVECTOR = 30;
    private static final int PG_TYPE_OIDARRAY = 1028;
    private static final int PG_TYPE_CHARARRAY = 1002;
    private static final int PG_TYPE_TEXTARRAY = 1009;
    private static final int PG_TYPE_DATE = 1082;
    private static final int PG_TYPE_TIME = 1083;
    private static final int PG_TYPE_TIMESTAMP_NO_TMZONE = 1114;
    private static final int PG_TYPE_NUMERIC = 1700;
    private DataOutputStream dataOut;
    private ByteArrayOutputStream outBuffer;
    private char messageType;
    private Properties props;
    private Charset encoding = Charset.forName("UTF-8");
    private ReflectionHelper clientProxy = new ReflectionHelper(ODBCClientRemote.class);
    private ChannelHandlerContext ctx;
    private MessageEvent message;
    private int maxLobSize = 0x200000;
    private volatile ResultsFuture<Boolean> nextFuture;

    public PgBackendProtocol(int maxLobSize) {
        this.maxLobSize = maxLobSize;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent me = (MessageEvent)evt;
        if (!(me.getMessage() instanceof ServiceInvocationStruct)) {
            ctx.sendDownstream(evt);
            return;
        }
        this.ctx = ctx;
        this.message = me;
        ServiceInvocationStruct serviceStruct = (ServiceInvocationStruct)me.getMessage();
        try {
            Method m = this.clientProxy.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                m.invoke((Object)this, serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            this.terminate(e);
        }
    }

    @Override
    public void initialized(Properties props) {
        this.props = props;
        this.setEncoding(props.getProperty("client_encoding", "UTF-8"));
    }

    @Override
    public void useClearTextAuthentication() {
        try {
            this.sendAuthenticationCleartextPassword();
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void authenticationSucess(int processId, int screctKey) {
        try {
            this.sendAuthenticationOk();
            this.sendParameterStatus("client_encoding", PGCharsetConverter.getEncoding(this.encoding));
            this.sendParameterStatus("DateStyle", this.props.getProperty("DateStyle", "ISO"));
            this.sendParameterStatus("integer_datetimes", "off");
            this.sendParameterStatus("is_superuser", "off");
            this.sendParameterStatus("server_encoding", "SQL_ASCII");
            this.sendParameterStatus("server_version", "8.1.4");
            this.sendParameterStatus("session_authorization", this.props.getProperty("user"));
            this.sendParameterStatus("standard_conforming_strings", "off");
            this.sendParameterStatus("application_name", this.props.getProperty("application_name", "ODBCClient"));
            this.sendParameterStatus("TimeZone", "CET");
            this.sendBackendKeyData(processId, screctKey);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void prepareCompleted(String preparedName) {
        this.sendParseComplete();
    }

    @Override
    public void bindComplete() {
        this.sendBindComplete();
    }

    @Override
    public void errorOccurred(String msg) {
        try {
            this.sendErrorResponse(msg);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void errorOccurred(Throwable t) {
        try {
            this.sendErrorResponse(t);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void ready(boolean inTransaction, boolean failedTransaction) {
        try {
            this.sendReadyForQuery(inTransaction, failedTransaction);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void setEncoding(String value) {
        Charset cs = PGCharsetConverter.getCharset(value);
        if (cs != null) {
            this.encoding = cs;
        }
    }

    @Override
    public void sendParameterDescription(ParameterMetaData meta, int[] paramType) {
        try {
            try {
                int count = meta.getParameterCount();
                this.startMessage('t');
                this.writeShort(count);
                for (int i = 0; i < count; ++i) {
                    int type = paramType != null && paramType[i] != 0 ? paramType[i] : PgBackendProtocol.convertType(meta.getParameterType(i + 1));
                    this.writeInt(type);
                }
                this.sendMessage();
            }
            catch (SQLException e) {
                this.sendErrorResponse(e);
            }
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendResultSetDescription(ResultSetMetaData metaData, Statement stmt) {
        try {
            try {
                List<PgColInfo> cols = this.getPgColInfo(metaData, stmt);
                this.sendRowDescription(cols);
            }
            catch (SQLException e) {
                this.sendErrorResponse(e);
            }
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendResults(String sql, ResultSetImpl rs, ResultsFuture<Void> result, boolean describeRows) {
        try {
            if (this.nextFuture != null) {
                this.sendErrorResponse(new IllegalStateException("Pending results have not been sent"));
            }
            ResultSetMetaData meta = rs.getMetaData();
            List<PgColInfo> cols = this.getPgColInfo(meta, (Statement)rs.getStatement());
            if (describeRows) {
                this.sendRowDescription(cols);
            }
            ResultsWorkItem r = new ResultsWorkItem(cols, sql, rs, result);
            r.run();
        }
        catch (SQLException e) {
            result.getResultsReceiver().exceptionOccurred((Throwable)e);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void sendUpdateCount(String sql, int updateCount) {
        try {
            this.sendCommandComplete(sql, updateCount);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void statementClosed() {
        this.startMessage('3');
        this.sendMessage();
    }

    @Override
    public void terminated() {
        try {
            PgBackendProtocol.trace("channel being terminated");
            this.sendNoticeResponse("Connection closed");
            this.ctx.getChannel().close();
        }
        catch (IOException e) {
            PgBackendProtocol.trace(e.getMessage());
        }
    }

    @Override
    public void flush() {
        try {
            this.dataOut.flush();
            this.dataOut = null;
            Channels.write((Channel)this.ctx.getChannel(), null);
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void emptyQueryReceived() {
        this.sendEmptyQueryResponse();
    }

    private void terminate(Throwable t) {
        PgBackendProtocol.trace("channel being terminated - ", t.getMessage());
        this.ctx.getChannel().close();
    }

    private void sendEmptyQueryResponse() {
        this.startMessage('I');
        this.sendMessage();
    }

    private void sendCommandComplete(String sql, int updateCount) throws IOException {
        String tag;
        this.startMessage('C');
        sql = sql.trim().toUpperCase();
        if (sql.startsWith("INSERT")) {
            tag = "INSERT 0 " + updateCount;
        } else if (sql.startsWith("DELETE")) {
            tag = "DELETE " + updateCount;
        } else if (sql.startsWith("UPDATE")) {
            tag = "UPDATE " + updateCount;
        } else if (sql.startsWith("SELECT") || sql.startsWith("CALL")) {
            tag = "SELECT";
        } else if (sql.startsWith("BEGIN")) {
            tag = "BEGIN";
        } else if (sql.startsWith("COMMIT")) {
            tag = "COMMIT";
        } else if (sql.startsWith("ROLLBACK")) {
            tag = "ROLLBACK";
        } else if (sql.startsWith("SET ")) {
            tag = "SET";
        } else {
            PgBackendProtocol.trace("Check command tag:", sql);
            tag = "UPDATE " + updateCount;
        }
        this.writeString(tag);
        this.sendMessage();
    }

    private void sendDataRow(ResultSet rs, List<PgColInfo> cols) throws SQLException, IOException {
        this.startMessage('D');
        this.writeShort(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            byte[] bytes = this.getContent(rs, cols.get(i), i + 1);
            if (bytes == null) {
                this.writeInt(-1);
                continue;
            }
            this.writeInt(bytes.length);
            this.write(bytes);
        }
        this.sendMessage();
    }

    private byte[] getContent(ResultSet rs, PgColInfo col, int column) throws SQLException, TeiidSQLException, IOException {
        byte[] bytes = null;
        switch (col.type) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1042: 
            case 1043: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1700: {
                String value = rs.getString(column);
                if (value == null) break;
                bytes = value.getBytes(this.encoding);
                break;
            }
            case 25: {
                Clob clob = rs.getClob(column);
                if (clob == null) break;
                bytes = ObjectConverterUtil.convertToByteArray((InputStream)new ReaderInputStream(clob.getCharacterStream(), this.encoding), (int)this.maxLobSize);
                break;
            }
            case 17: {
                Blob blob = rs.getBlob(column);
                if (blob == null) break;
                try {
                    bytes = PGbytea.toPGString(ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream(), (int)this.maxLobSize)).getBytes(this.encoding);
                    break;
                }
                catch (OutOfMemoryError e) {
                    throw new StreamCorruptedException("data too big: " + e.getMessage());
                }
            }
            case 1002: 
            case 1009: 
            case 1028: {
                Object[] obj = (Object[])rs.getObject(column);
                if (obj == null) break;
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                boolean first = true;
                for (Object o : obj) {
                    if (!first) {
                        sb.append(",");
                    } else {
                        first = false;
                    }
                    if (col.type == 1009) {
                        PgBackendProtocol.escapeQuote(sb, o.toString());
                        continue;
                    }
                    sb.append(o.toString());
                }
                sb.append("}");
                bytes = sb.toString().getBytes(this.encoding);
                break;
            }
            case 30: {
                Object[] obj = (Object[])rs.getObject(column);
                if (obj == null) break;
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object o : obj) {
                    if (!first) {
                        sb.append(" ");
                    } else {
                        first = false;
                    }
                    sb.append(o);
                }
                bytes = sb.toString().getBytes(this.encoding);
                break;
            }
            default: {
                throw new TeiidSQLException("unknown datatype failed to convert");
            }
        }
        return bytes;
    }

    public static void escapeQuote(StringBuilder sb, String s) {
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\"');
    }

    @Override
    public void sslDenied() {
        ChannelBuffer buffer = ChannelBuffers.directBuffer((int)1);
        buffer.writeByte(78);
        Channels.write((ChannelHandlerContext)this.ctx, (ChannelFuture)this.message.getFuture(), (Object)buffer, (SocketAddress)this.message.getRemoteAddress());
    }

    private void sendErrorResponse(Throwable t) throws IOException {
        PgBackendProtocol.trace(t.getMessage());
        TeiidSQLException e = TeiidSQLException.create((Throwable)t);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendNoData() {
        this.startMessage('n');
        this.sendMessage();
    }

    private void sendRowDescription(List<PgColInfo> cols) throws IOException {
        this.startMessage('T');
        this.writeShort(cols.size());
        for (PgColInfo info : cols) {
            this.writeString(info.name);
            this.writeInt(info.reloid);
            this.writeShort(info.attnum);
            this.writeInt(info.type);
            this.writeShort(this.getTypeSize(info.type, info.precision));
            this.writeInt(-1);
            this.writeShort(0);
        }
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PgColInfo> getPgColInfo(ResultSetMetaData meta, Statement stmt) throws SQLException {
        int columns = meta.getColumnCount();
        ArrayList<PgColInfo> result = new ArrayList<PgColInfo>(columns);
        for (int i = 1; i < columns + 1; ++i) {
            PgColInfo info = new PgColInfo();
            info.name = meta.getColumnName(i).toLowerCase();
            info.type = meta.getColumnType(i);
            info.type = PgBackendProtocol.convertType(info.type);
            info.precision = meta.getColumnDisplaySize(i);
            String name = meta.getColumnName(i);
            String table = meta.getTableName(i);
            String schema = meta.getSchemaName(i);
            if (schema != null) {
                PreparedStatement ps = null;
                try {
                    ps = stmt.getConnection().prepareStatement("select attrelid, attnum, typoid from matpg_relatt where attname = ? and relname = ? and nspname = ?");
                    ps.setString(1, name);
                    ps.setString(2, table);
                    ps.setString(3, schema);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        info.reloid = rs.getInt(1);
                        info.attnum = rs.getShort(2);
                        int specificType = rs.getInt(3);
                        if (!rs.wasNull()) {
                            info.type = specificType;
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            result.add(info);
        }
        return result;
    }

    private int getTypeSize(int pgType, int precision) {
        switch (pgType) {
            case 1043: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private void sendErrorResponse(String message) throws IOException {
        PgBackendProtocol.trace("Exception:", message);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendNoticeResponse(String message) throws IOException {
        PgBackendProtocol.trace("notice:", message);
        this.startMessage('N');
        this.write(83);
        this.writeString("ERROR");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() {
        this.startMessage('1');
        this.sendMessage();
    }

    private void sendBindComplete() {
        this.startMessage('2');
        this.sendMessage();
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage('R');
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage('R');
        this.writeInt(0);
        this.sendMessage();
    }

    private void sendReadyForQuery(boolean inTransaction, boolean failedTransaction) throws IOException {
        this.startMessage('Z');
        int c = failedTransaction ? 69 : (inTransaction ? 84 : 73);
        this.write((byte)c);
        this.sendMessage();
    }

    private void sendBackendKeyData(int processId, int screctKey) throws IOException {
        this.startMessage('K');
        this.writeInt(processId);
        this.writeInt(screctKey);
        this.sendMessage();
    }

    private void sendParameterStatus(String param, String value) throws IOException {
        this.startMessage('S');
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    @Override
    public void functionCallResponse(byte[] data) {
        try {
            this.startMessage('V');
            if (data == null) {
                this.writeInt(-1);
            } else {
                this.writeInt(data.length);
                this.write(data);
            }
            this.sendMessage();
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    @Override
    public void functionCallResponse(int data) {
        try {
            this.startMessage('V');
            this.writeInt(4);
            this.writeInt(data);
            this.sendMessage();
        }
        catch (IOException e) {
            this.terminate(e);
        }
    }

    private void writeString(String s) throws IOException {
        this.write(s.getBytes(this.encoding));
        this.write(0);
    }

    private void writeInt(int i) throws IOException {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) throws IOException {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) throws IOException {
        this.dataOut.write(data);
    }

    private void write(int b) throws IOException {
        this.dataOut.write(b);
    }

    private void startMessage(char newMessageType) {
        this.messageType = newMessageType;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() {
        byte[] buff = this.outBuffer.toByteArray();
        int len = buff.length;
        this.outBuffer = null;
        this.dataOut = null;
        ChannelBuffer buffer = ChannelBuffers.directBuffer((int)(len + 5));
        buffer.writeByte((int)((byte)this.messageType));
        buffer.writeInt(len + 4);
        buffer.writeBytes(buff);
        Channels.write((ChannelHandlerContext)this.ctx, (ChannelFuture)this.message.getFuture(), (Object)buffer, (SocketAddress)this.message.getRemoteAddress());
    }

    private static void trace(String ... msg) {
        LogManager.logTrace((String)"org.teiid.ODBC", (Object[])msg);
    }

    private static int convertType(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 1: {
                return 1042;
            }
            case -6: 
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 2: 
            case 3: {
                return 1700;
            }
            case 6: 
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 17;
            }
            case -1: 
            case 2005: {
                return 25;
            }
            case 2009: {
                return 25;
            }
        }
        return 705;
    }

    private static class PgColInfo {
        String name;
        int reloid;
        short attnum;
        int type;
        int precision;

        private PgColInfo() {
        }
    }

    private final class ResultsWorkItem
    implements Runnable {
        private final List<PgColInfo> cols;
        private final String sql;
        private final ResultSetImpl rs;
        private final ResultsFuture<Void> result;

        private ResultsWorkItem(List<PgColInfo> cols, String sql, ResultSetImpl rs, ResultsFuture<Void> result) {
            this.cols = cols;
            this.sql = sql;
            this.rs = rs;
            this.result = result;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        PgBackendProtocol.this.nextFuture = this.rs.submitNext();
                        if (PgBackendProtocol.this.nextFuture.isDone()) continue;
                        PgBackendProtocol.this.nextFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                            public void onCompletion(ResultsFuture<Boolean> future) {
                                if (ResultsWorkItem.this.processRow((ResultsFuture<Boolean>)future)) {
                                    ResultsWorkItem.this.run();
                                }
                            }
                        });
                        return;
                    } while (this.processRow((ResultsFuture<Boolean>)PgBackendProtocol.this.nextFuture));
                }
                catch (Throwable t) {
                    this.result.getResultsReceiver().exceptionOccurred(t);
                    continue;
                }
                break;
            }
        }

        private boolean processRow(ResultsFuture<Boolean> future) {
            PgBackendProtocol.this.nextFuture = null;
            boolean processNext = true;
            try {
                if (((Boolean)future.get()).booleanValue()) {
                    PgBackendProtocol.this.sendDataRow((ResultSet)this.rs, this.cols);
                } else {
                    PgBackendProtocol.this.sendCommandComplete(this.sql, 0);
                    this.result.getResultsReceiver().receiveResults(null);
                    processNext = false;
                }
            }
            catch (Throwable t) {
                this.result.getResultsReceiver().exceptionOccurred(t);
                return false;
            }
            return processNext;
        }
    }
}

