/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.util.threadpool.ThreadPool;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.deployers.ObjectSerializer;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class VDBDeployer
extends AbstractSimpleRealDeployer<VDBMetaData> {
    private VDBRepository vdbRepository;
    private TranslatorRepository translatorRepository;
    private ObjectSerializer serializer;
    private ContainerLifeCycleListener shutdownListener;
    private ThreadPool threadPool;

    public VDBDeployer() {
        super(VDBMetaData.class);
        this.setInput(VDBMetaData.class);
        this.setOutput(VDBMetaData.class);
        this.setRelativeOrder(3001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentUnit unit, VDBMetaData deployment) throws DeploymentException {
        List errors;
        if (this.vdbRepository.removeVDB(deployment.getName(), deployment.getVersion())) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("redeploying_vdb", new Object[]{deployment}));
        }
        TranslatorRepository repo = new TranslatorRepository();
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        boolean preview = deployment.isPreview();
        if (!preview && (errors = deployment.getValidityErrors()) != null && !errors.isEmpty()) {
            throw new DeploymentException(RuntimePlugin.Util.getString("validity_errors_in_vdb", new Object[]{deployment}));
        }
        MetadataStoreGroup store = (MetadataStoreGroup)unit.getAttachment(MetadataStoreGroup.class);
        for (Translator t : deployment.getOverrideTranslators()) {
            VDBTranslatorMetaData data = (VDBTranslatorMetaData)t;
            String type = data.getType();
            Translator parent = this.translatorRepository.getTranslatorMetaData(type);
            if (parent == null) {
                throw new DeploymentException(RuntimePlugin.Util.getString("translator_type_not_found", new Object[]{unit.getName()}));
            }
            Set<String> keys = parent.getProperties().stringPropertyNames();
            for (String key : keys) {
                if (data.getPropertyValue(key) != null || parent.getPropertyValue(key) == null) continue;
                data.addProperty(key, parent.getPropertyValue(key));
            }
            repo.addTranslatorMetadata(data.getName(), data);
        }
        this.createConnectorManagers(cmr, repo, deployment);
        boolean asynchLoad = false;
        if (store == null && deployment.isDynamic()) {
            store = new MetadataStoreGroup();
            asynchLoad = this.buildDynamicMetadataStore((VFSDeploymentUnit)unit, deployment, store, cmr);
        }
        if (preview && store == null) {
            store = new MetadataStoreGroup();
        }
        if (store == null) {
            LogManager.logError((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("failed_matadata_load", new Object[]{deployment.getName(), deployment.getVersion()}));
        }
        UDFMetaData udf = (UDFMetaData)unit.getAttachment(UDFMetaData.class);
        LinkedHashMap visibilityMap = null;
        IndexMetadataFactory indexFactory = (IndexMetadataFactory)unit.getAttachment(IndexMetadataFactory.class);
        if (indexFactory != null) {
            visibilityMap = indexFactory.getEntriesPlusVisibilities();
        }
        deployment.removeAttachment(IndexMetadataFactory.class);
        deployment.removeAttachment(UDFMetaData.class);
        deployment.removeAttachment(MetadataStoreGroup.class);
        this.vdbRepository.addVDB(deployment, store, visibilityMap, udf, cmr);
        boolean valid = true;
        VDBMetaData vDBMetaData = deployment;
        synchronized (vDBMetaData) {
            if (indexFactory != null) {
                try {
                    this.saveMetadataStore((VFSDeploymentUnit)unit, deployment, store);
                }
                catch (IOException e1) {
                    LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e1, (String)RuntimePlugin.Util.getString("vdb_save_failed", new Object[]{deployment.getName() + "." + deployment.getVersion()}));
                }
            }
            if (!preview) {
                valid = this.validateSources(cmr, deployment);
                if (!valid) {
                    deployment.setStatus(VDB.Status.INACTIVE);
                } else if (!asynchLoad) {
                    this.vdbRepository.finishDeployment(deployment.getName(), deployment.getVersion());
                    deployment.setStatus(VDB.Status.ACTIVE);
                }
            } else {
                deployment.setStatus(VDB.Status.ACTIVE);
            }
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_deployed", new Object[]{deployment, valid ? "active" : "inactive"}));
    }

    private void createConnectorManagers(ConnectorManagerRepository cmr, TranslatorRepository repo, VDBMetaData deployment) throws DeploymentException {
        IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map = new IdentityHashMap<Translator, ExecutionFactory<Object, Object>>();
        for (Model model : deployment.getModels()) {
            for (String source : model.getSourceNames()) {
                if (cmr.getConnectorManager(source) != null) continue;
                String name = model.getSourceTranslatorName(source);
                ConnectorManager cm = new ConnectorManager(name, model.getSourceConnectionJndiName(source));
                ExecutionFactory<Object, Object> ef = this.getExecutionFactory(name, repo, deployment, map, new HashSet<String>());
                cm.setExecutionFactory(ef);
                cm.setModelName(model.getName());
                cmr.addConnectorManager(source, cm);
            }
        }
    }

    private ExecutionFactory<Object, Object> getExecutionFactory(String name, TranslatorRepository repo, VDBMetaData deployment, IdentityHashMap<Translator, ExecutionFactory<Object, Object>> map, HashSet<String> building) throws DeploymentException {
        if (!building.add(name)) {
            throw new DeploymentException(RuntimePlugin.Util.getString("recursive_delegation", new Object[]{deployment.getName(), deployment.getVersion(), building}));
        }
        Translator translator = repo.getTranslatorMetaData(name);
        if (translator == null) {
            translator = this.translatorRepository.getTranslatorMetaData(name);
        }
        if (translator == null) {
            throw new DeploymentException(RuntimePlugin.Util.getString("translator_not_found", new Object[]{deployment.getName(), deployment.getVersion(), name}));
        }
        ExecutionFactory ef = map.get(translator);
        if (ef == null) {
            DelegatingExecutionFactory delegator;
            String delegateName;
            ef = TranslatorUtil.buildExecutionFactory(translator);
            if (ef instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
                ExecutionFactory<Object, Object> delegate = this.getExecutionFactory(delegateName, repo, deployment, map, building);
                ((DelegatingExecutionFactory)ef).setDelegate(delegate);
            }
            map.put(translator, (ExecutionFactory<Object, Object>)ef);
        }
        return ef;
    }

    private boolean validateSources(ConnectorManagerRepository cmr, VDBMetaData deployment) {
        boolean valid = true;
        for (Model m : deployment.getModels()) {
            ModelMetaData model = (ModelMetaData)m;
            List mappings = model.getSourceMappings();
            for (SourceMappingMetadata mapping : mappings) {
                ConnectorManager cm = cmr.getConnectorManager(mapping.getName());
                String msg = cm.getStausMessage();
                if (msg == null || msg.length() <= 0) continue;
                valid = false;
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), cm.getStausMessage());
                LogManager.logInfo((String)"org.teiid.RUNTIME", (String)cm.getStausMessage());
            }
            if (model.getErrors().isEmpty()) continue;
            valid = false;
        }
        return valid;
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void undeploy(DeploymentUnit unit, VDBMetaData deployment) {
        super.undeploy(unit, (Object)deployment);
        if (this.vdbRepository != null) {
            this.vdbRepository.removeVDB(deployment.getName(), deployment.getVersion());
        }
        deployment.setRemoved(true);
        try {
            this.deleteMetadataStore((VFSDeploymentUnit)unit);
        }
        catch (IOException e) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_delete_failed", new Object[]{e.getMessage()}));
        }
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_undeployed", new Object[]{deployment}));
    }

    public void setObjectSerializer(ObjectSerializer serializer) {
        this.serializer = serializer;
    }

    private void saveMetadataStore(VFSDeploymentUnit unit, VDBMetaData vdb, MetadataStoreGroup store) throws IOException {
        File cacheFileName = VDBDeployer.buildCachedVDBFileName(this.serializer, unit, vdb);
        if (!cacheFileName.exists()) {
            this.serializer.saveAttachment(cacheFileName, store);
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + unit.getRoot().getName() + " metadata has been cached to " + cacheFileName});
        }
    }

    private void deleteMetadataStore(VFSDeploymentUnit unit) throws IOException {
        if (!unit.getRoot().exists() || !this.shutdownListener.isShutdownInProgress()) {
            this.serializer.removeAttachments(unit);
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"VDB " + unit.getRoot().getName() + " metadata removed"});
        }
    }

    private boolean buildDynamicMetadataStore(VFSDeploymentUnit unit, final VDBMetaData vdb, final MetadataStoreGroup vdbStore, final ConnectorManagerRepository cmr) throws DeploymentException {
        boolean asynch = false;
        for (final ModelMetaData model : vdb.getModelMetaDatas().values()) {
            MetadataStore store;
            if (model.getSourceNames().isEmpty()) {
                throw new DeploymentException(RuntimePlugin.Util.getString("fail_to_deploy", new Object[]{vdb.getName() + "-" + vdb.getVersion(), model.getName()}));
            }
            final boolean cache = "cached".equalsIgnoreCase(vdb.getPropertyValue("UseConnectorMetadata"));
            final File cacheFile = this.buildCachedModelFileName(unit, vdb, model.getName());
            boolean loaded = false;
            if (cache && (store = this.serializer.loadSafe(cacheFile, MetadataStore.class)) != null) {
                vdbStore.addStore(store);
                loaded = true;
            }
            if (loaded) continue;
            asynch = true;
            this.threadPool.run(new Runnable(){

                @Override
                public void run() {
                    Boolean loadStatus = VDBDeployer.this.loadMetadata(vdb, model, cache, cacheFile, vdbStore, cmr);
                    if (loadStatus == null || !loadStatus.booleanValue()) {
                        model.addAttchment(Runnable.class, (Object)this);
                    }
                }
            });
        }
        return asynch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean loadMetadata(VDBMetaData vdb, ModelMetaData model, boolean cache, File cacheFile, MetadataStoreGroup vdbStore, ConnectorManagerRepository cmr) {
        String msg = RuntimePlugin.Util.getString("model_metadata_loading", new Object[]{vdb.getName(), vdb.getVersion(), model.getName(), SimpleDateFormat.getInstance().format(new Date())});
        model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), msg);
        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)msg);
        String exceptionMessage = null;
        Boolean loaded = false;
        for (String sourceName : model.getSourceNames()) {
            ConnectorManager cm = cmr.getConnectorManager(sourceName);
            String status = cm.getStausMessage();
            if (status != null && status.length() > 0) {
                exceptionMessage = status;
                continue;
            }
            loaded = null;
            try {
                MetadataStore store = cm.getMetadata(model.getName(), this.vdbRepository.getBuiltinDatatypes(), model.getProperties());
                if (cache) {
                    this.serializer.saveAttachment(cacheFile, store);
                }
                vdbStore.addStore(store);
                loaded = true;
                break;
            }
            catch (TranslatorException e) {
                if (exceptionMessage != null) continue;
                exceptionMessage = e.getMessage();
            }
            catch (IOException e) {
                if (exceptionMessage != null) continue;
                exceptionMessage = e.getMessage();
            }
        }
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            if (loaded == null || !loaded.booleanValue()) {
                vdb.setStatus(VDB.Status.INACTIVE);
                String failed_msg = RuntimePlugin.Util.getString(loaded == null ? "failed_to_retrive_metadata" : "nosources_to_retrive_metadata", new Object[]{vdb.getName(), vdb.getVersion(), model.getName()});
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), failed_msg);
                if (exceptionMessage != null) {
                    model.addError(ModelMetaData.ValidationError.Severity.ERROR.toString(), exceptionMessage);
                }
                LogManager.logWarning((String)"org.teiid.RUNTIME", (String)failed_msg);
            } else {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("metadata_loaded", new Object[]{vdb.getName(), vdb.getVersion(), model.getName()}));
                model.clearErrors();
                if (vdb.isValid()) {
                    this.vdbRepository.finishDeployment(vdb.getName(), vdb.getVersion());
                    vdb.setStatus(VDB.Status.ACTIVE);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_activated", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
        }
        return loaded;
    }

    private File buildCachedModelFileName(VFSDeploymentUnit unit, VDBMetaData vdb, String modelName) {
        return this.serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion() + "_" + modelName);
    }

    static File buildCachedVDBFileName(ObjectSerializer serializer, VFSDeploymentUnit unit, VDBMetaData vdb) {
        return serializer.getAttachmentPath(unit, vdb.getName() + "_" + vdb.getVersion());
    }

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }

    public void setContainerLifeCycleListener(ContainerLifeCycleListener listener) {
        this.shutdownListener = listener;
    }

    public void setThreadPool(ThreadPool pool) {
        this.threadPool = pool;
    }
}

