/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.dqp.service.BufferService;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

@ManagementObject(name="BufferService", componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class BufferServiceImpl
implements BufferService,
Serializable {
    private static final long serialVersionUID = -6217808623863643531L;
    private static final long MB = 0x100000L;
    private BufferManagerImpl bufferMgr;
    private File bufferDir;
    private boolean useDisk = true;
    private int processorBatchSize = 512;
    private int connectorBatchSize = 1024;
    private int maxOpenFiles = 64;
    private long maxFileSize = 2048L;
    private int maxProcessingKb = -1;
    private int maxReserveKb = -1;
    private long maxBufferSpace = 0xC80000000L;
    private FileStorageManager fsm;

    void cleanDirectory(File file) {
        FileUtils.removeChildrenRecursively((File)file);
    }

    public void start() {
        try {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Starting BufferManager using", this.bufferDir});
            if (!this.bufferDir.exists()) {
                this.bufferDir.mkdirs();
            }
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.setConnectorBatchSize(Integer.valueOf(this.connectorBatchSize).intValue());
            this.bufferMgr.setProcessorBatchSize(Integer.valueOf(this.processorBatchSize).intValue());
            this.bufferMgr.setMaxReserveKB(this.maxReserveKb);
            this.bufferMgr.setMaxProcessingKB(this.maxProcessingKb);
            this.bufferMgr.initialize();
            if (this.useDisk) {
                this.cleanDirectory(this.bufferDir);
                this.fsm = new FileStorageManager();
                this.fsm.setStorageDirectory(this.bufferDir.getCanonicalPath());
                this.fsm.setMaxFileSize(this.maxFileSize);
                this.fsm.setMaxOpenFiles(this.maxOpenFiles);
                this.fsm.setMaxBufferSpace(this.maxBufferSpace * 0x100000L);
                this.fsm.initialize();
                this.bufferMgr.setStorageManager((StorageManager)this.fsm);
            } else {
                this.bufferMgr.setStorageManager((StorageManager)new MemoryStorageManager());
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
    }

    public void stop() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Stopping BufferManager using", this.bufferDir});
        this.bufferMgr.shutdown();
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }

    public void setUseDisk(boolean flag) {
        this.useDisk = flag;
    }

    public void setDiskDirectory(String dir) {
        this.bufferDir = new File(dir, "buffer");
    }

    public void setProcessorBatchSize(int size) {
        this.processorBatchSize = size;
    }

    public void setConnectorBatchSize(int size) {
        this.connectorBatchSize = size;
    }

    public File getBufferDirectory() {
        return this.bufferDir;
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    @ManagementProperty(description="The max row count of a batch sent internally within the query processor. Should be <= the connectorBatchSize. (default 256)")
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    @ManagementProperty(description="The max row count of a batch from a connector. Should be even multiple of processorBatchSize. (default 512)")
    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    @ManagementProperty(description="Max file size, in MB, for buffer files (default 2GB)")
    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    @ManagementProperty(description="Max open buffer files (default 64)")
    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    @ManagementProperty(description="The approximate amount of buffer memory in kilobytes allowable for a single processing operation (sort, grouping, etc.) regardless of existing memory commitments. -1 means to automatically calculate a value (default -1).")
    public int getMaxProcessingKb() {
        return this.maxProcessingKb;
    }

    @ManagementProperty(description="The approximate amount of memory in kilobytes allowed to be held by the buffer manager. -1 means to automatically calculate a value (default -1)")
    public int getMaxReservedKb() {
        return this.maxReserveKb;
    }

    public void setMaxProcessingKb(int maxProcessingKb) {
        this.maxProcessingKb = maxProcessingKb;
    }

    public void setMaxReserveKb(int maxReserveKb) {
        this.maxReserveKb = maxReserveKb;
    }

    @ManagementProperty(description="Max file storage space, in MB, to be used for buffer files (default 50G)")
    public long getMaxBufferSpace() {
        return this.maxBufferSpace;
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    @ManagementProperty(description="The currently used file buffer space in MB.", readOnly=true)
    public long getUserBufferSpace() {
        if (this.fsm != null) {
            return this.fsm.getUsedBufferSpace() / 0x100000L;
        }
        return 0L;
    }

    @ManagementProperty(description="The total number of batches added to the buffer mananger.", readOnly=true)
    public long getBatchesAdded() {
        return this.bufferMgr.getBatchesAdded();
    }

    @ManagementProperty(description="The total number of batches read from storage.", readOnly=true)
    public long getReadCount() {
        return this.bufferMgr.getReadCount();
    }

    @ManagementProperty(description="The total number of batches written to storage.", readOnly=true)
    public long getWriteCount() {
        return this.bufferMgr.getWriteCount();
    }

    @ManagementProperty(description="The total number of batch read attempts.", readOnly=true)
    public long getReadAttempts() {
        return this.bufferMgr.getReadAttempts();
    }
}

