/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.Properties;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidException;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.EmbeddedProfile;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private int maxBufferSize = Integer.parseInt(System.getProperty("org.teiid.ODBCPacketSize", "307200"));
    private ODBCServerRemote.AuthenticationType authType = ODBCServerRemote.AuthenticationType.CLEARTEXT;
    private int maxLobSize;
    private TeiidDriver driver;

    public ODBCSocketListener(SocketConfiguration config, StorageManager storageManager, int portOffset, int maxLobSize) {
        super(config, new ClientServiceRegistryImpl(ClientServiceRegistry.Type.ODBC), storageManager, portOffset);
        this.maxLobSize = maxLobSize;
        this.driver = new TeiidDriver();
        this.driver.setEmbeddedProfile((ConnectionProfile)new EmbeddedProfile(){

            protected ServerConnection createServerConnection(Properties info) throws TeiidException {
                return new LocalServerConnection(info, false);
            }
        });
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected SSLAwareChannelHandler createChannelPipelineFactory(final SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(0x100000));
                pipeline.addLast("odbcBackendProtocol", (ChannelHandler)new PgBackendProtocol(ODBCSocketListener.this.maxLobSize, ODBCSocketListener.this.maxBufferSize, config));
                pipeline.addLast("handler", (ChannelHandler)this);
                return pipeline;
            }
        };
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.authType, this.driver);
    }

    public void setAuthenticationType(String value) {
        this.authType = ODBCServerRemote.AuthenticationType.valueOf(value);
    }
}

