/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.LinkedList;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.util.threadpool.ThreadPool;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;

public class VDBStatusChecker {
    private static final String JAVA_CONTEXT = "java:";
    private VDBRepository vdbRepository;
    private ThreadPool threadPool;
    private TranslatorRepository translatorRepository;

    public void translatorAdded(String translatorName) {
        this.resourceAdded(translatorName, true);
    }

    public void translatorRemoved(String translatorName) {
        this.resourceremoved(translatorName, true);
    }

    public void dataSourceAdded(String dataSourceName) {
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        this.resourceAdded(dataSourceName, false);
    }

    public void dataSourceRemoved(String dataSourceName) {
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        this.resourceremoved(dataSourceName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSourceReplaced(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminException {
        if (dsName.startsWith(JAVA_CONTEXT)) {
            dsName = dsName.substring(5);
        }
        VDBMetaData vdb = this.vdbRepository.getVDB(vdbName, vdbVersion);
        ModelMetaData model = vdb.getModel(modelName);
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            ConnectorManager cm = cmr.getConnectorManager(sourceName);
            ExecutionFactory ef = cm.getExecutionFactory();
            boolean dsReplaced = false;
            if (!cm.getConnectionName().equals(dsName)) {
                vdb.setStatus(VDB.Status.INACTIVE);
                String msg = RuntimePlugin.Util.getString("datasource_replaced", new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName), dsName});
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), msg);
                cm = new ConnectorManager(translatorName, dsName);
                cm.setExecutionFactory(ef);
                cm.setModelName(modelName);
                cmr.addConnectorManager(sourceName, cm);
                dsReplaced = true;
            }
            if (!cm.getTranslatorName().equals(translatorName)) {
                try {
                    TranslatorRepository repo = (TranslatorRepository)vdb.getAttachment(TranslatorRepository.class);
                    Translator t = null;
                    if (repo != null) {
                        t = repo.getTranslatorMetaData(translatorName);
                    }
                    if (t == null) {
                        t = this.translatorRepository.getTranslatorMetaData(translatorName);
                    }
                    if (t == null) {
                        throw new DeploymentException(RuntimePlugin.Util.getString("translator_not_found", new Object[]{vdb.getName(), vdb.getVersion(), translatorName}));
                    }
                    ef = TranslatorUtil.buildExecutionFactory(t);
                    cm.setExecutionFactory(ef);
                }
                catch (DeploymentException e) {
                    throw new AdminProcessingException(e.getCause());
                }
            }
            if (dsReplaced) {
                this.resourceAdded(dsName, false);
            }
        }
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceAdded(String resourceName, boolean translator) {
        for (VDBMetaData vdb : this.vdbRepository.getVDBs()) {
            if (vdb.getStatus() == VDB.Status.ACTIVE || vdb.isPreview()) continue;
            LinkedList<Runnable> runnables = new LinkedList<Runnable>();
            VDBMetaData vDBMetaData = vdb;
            synchronized (vDBMetaData) {
                ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
                for (Model m : vdb.getModels()) {
                    String sourceName;
                    ModelMetaData model = (ModelMetaData)m;
                    if (model.getErrors().isEmpty() || (sourceName = this.getSourceName(resourceName, model, translator)) == null) continue;
                    ConnectorManager cm = cmr.getConnectorManager(sourceName);
                    String status = cm.getStausMessage();
                    if (status != null && status.length() > 0) {
                        model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), status);
                        LogManager.logInfo((String)"org.teiid.RUNTIME", (String)status);
                        continue;
                    }
                    Runnable r = (Runnable)model.removeAttachment(Runnable.class);
                    if (r != null) {
                        runnables.add(r);
                        continue;
                    }
                    model.clearErrors();
                }
                boolean valid = true;
                for (Model m : vdb.getModels()) {
                    ModelMetaData model = (ModelMetaData)m;
                    if (model.getErrors().isEmpty()) continue;
                    valid = false;
                    break;
                }
                if (!runnables.isEmpty()) {
                    for (Runnable runnable : runnables) {
                        this.threadPool.run(runnable);
                    }
                } else if (valid) {
                    vdb.setStatus(VDB.Status.ACTIVE);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_activated", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resourceremoved(String resourceName, boolean translator) {
        for (VDBMetaData vdb : this.vdbRepository.getVDBs()) {
            if (vdb.isPreview()) continue;
            VDBMetaData vDBMetaData = vdb;
            synchronized (vDBMetaData) {
                for (Model m : vdb.getModels()) {
                    ModelMetaData model = (ModelMetaData)m;
                    String sourceName = this.getSourceName(resourceName, model, translator);
                    if (sourceName == null) continue;
                    vdb.setStatus(VDB.Status.INACTIVE);
                    String msg = null;
                    msg = translator ? RuntimePlugin.Util.getString("translator_not_found", new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName)}) : RuntimePlugin.Util.getString("datasource_not_found", new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName)});
                    model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), msg);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)msg);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (String)RuntimePlugin.Util.getString("vdb_inactivated", new Object[]{vdb.getName(), vdb.getVersion()}));
                }
            }
        }
    }

    private String getSourceName(String translatorName, ModelMetaData model, boolean translator) {
        for (String sourceName : model.getSourceNames()) {
            if (translator) {
                if (!translatorName.equals(model.getSourceTranslatorName(sourceName))) continue;
                return sourceName;
            }
            String jndiName = model.getSourceConnectionJndiName(sourceName);
            if (jndiName.startsWith(JAVA_CONTEXT)) {
                jndiName = jndiName.substring(5);
            }
            if (!translatorName.equals(jndiName)) continue;
            return sourceName;
        }
        return null;
    }

    public void setThreadPool(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }
}

