/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.teiid.client.security.ILogon;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.PgFrontendProtocol;

public class ODBCClientInstance
implements ChannelListener {
    private ODBCClientRemote client;
    private ODBCServerRemoteImpl server;
    private ReflectionHelper serverProxy = new ReflectionHelper(ODBCServerRemote.class);
    private ConcurrentLinkedQueue<PgFrontendProtocol.PGRequest> messageQueue = new ConcurrentLinkedQueue();

    public ODBCClientInstance(final ObjectChannel channel, AuthenticationType authType, TeiidDriver driver, ILogon logonService) {
        this.client = (ODBCClientRemote)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ODBCClientRemote.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODBC", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.ODBC", (Object[])new Object[]{"invoking client method:", method.getName(), Arrays.deepToString(args)});
                }
                ServiceInvocationStruct message = new ServiceInvocationStruct(args, method.getName(), ODBCServerRemote.class);
                channel.write((Object)message);
                return null;
            }
        });
        this.server = new ODBCServerRemoteImpl(this, authType, driver, logonService){

            @Override
            protected synchronized void doneExecuting() {
                PgFrontendProtocol.PGRequest request;
                super.doneExecuting();
                while (!ODBCClientInstance.this.server.isExecuting() && (request = (PgFrontendProtocol.PGRequest)ODBCClientInstance.this.messageQueue.poll()) != null) {
                    if (ODBCClientInstance.this.server.isErrorOccurred() && !request.struct.methodName.equals("sync")) continue;
                    ODBCClientInstance.this.processMessage(request.struct);
                }
            }
        };
    }

    public ODBCClientRemote getClient() {
        return this.client;
    }

    @Override
    public void disconnected() {
        this.server.terminate();
    }

    @Override
    public void exceptionOccurred(Throwable t) {
        LogManager.log((int)(t instanceof IOException ? 5 : 2), (String)"org.teiid.ODBC", (Throwable)t, (Object)"Unhandled exception, closing client instance");
        this.server.terminate();
    }

    @Override
    public void onConnection() throws CommunicationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedMessage(Object msg) throws CommunicationException {
        if (msg instanceof PgFrontendProtocol.PGRequest) {
            PgFrontendProtocol.PGRequest request = (PgFrontendProtocol.PGRequest)msg;
            ODBCServerRemoteImpl oDBCServerRemoteImpl = this.server;
            synchronized (oDBCServerRemoteImpl) {
                if (this.server.isExecuting()) {
                    this.messageQueue.add(request);
                    return;
                }
                if (this.server.isErrorOccurred() && !request.struct.methodName.equals("sync")) {
                    return;
                }
            }
            this.processMessage(request.struct);
        }
    }

    private void processMessage(ServiceInvocationStruct serviceStruct) {
        try {
            Method m = this.serverProxy.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                m.invoke((Object)this.server, serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            this.client.errorOccurred(e);
        }
    }
}

