/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.StorageManager;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private AuthenticationType authType = AuthenticationType.CLEARTEXT;
    private int maxBufferSize = Integer.parseInt(System.getProperty("org.teiid.ODBCPacketSize", "307200"));
    private int maxLobSize;
    private TeiidDriver driver;
    private ILogon logonService;

    public ODBCSocketListener(SocketConfiguration config, StorageManager storageManager, int portOffset, int maxLobSize, ILogon logon) {
        super(config, new ClientServiceRegistryImpl(ClientServiceRegistry.Type.ODBC), storageManager, portOffset);
        this.maxLobSize = maxLobSize;
        this.driver = new TeiidDriver();
        this.logonService = logon;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected SSLAwareChannelHandler createChannelPipelineFactory(final SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(0x100000));
                pipeline.addLast("odbcBackendProtocol", (ChannelHandler)new PgBackendProtocol(ODBCSocketListener.this.maxLobSize, ODBCSocketListener.this.maxBufferSize, config));
                pipeline.addLast("handler", (ChannelHandler)this);
                return pipeline;
            }
        };
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.authType, this.driver, this.logonService);
    }

    public void setAuthenticationType(AuthenticationType value) {
        this.authType = value;
    }
}

