/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.nio.charset.Charset;
import java.util.HashMap;

public class PGCharsetConverter {
    private static HashMap<String, Charset> charSetMap = new HashMap();
    private static HashMap<Charset, String> inverseCharSetMap = new HashMap();

    private static void mapCharset(String name, Charset cs) {
        charSetMap.put(name, cs);
        inverseCharSetMap.put(cs, name);
    }

    public static Charset getCharset(String name) {
        return charSetMap.get(name);
    }

    public static String getEncoding(Charset cs) {
        return inverseCharSetMap.get(cs);
    }

    static {
        PGCharsetConverter.mapCharset("BIG5", Charset.forName("Big5"));
        PGCharsetConverter.mapCharset("EUC_CN", Charset.forName("GB2312"));
        PGCharsetConverter.mapCharset("EUC_JP", Charset.forName("EUC-JP"));
        PGCharsetConverter.mapCharset("EUC_KR", Charset.forName("EUC-KR"));
        PGCharsetConverter.mapCharset("EUC_TW", Charset.forName("EUC-TW"));
        PGCharsetConverter.mapCharset("GB18030", Charset.forName("GB18030"));
        PGCharsetConverter.mapCharset("GBK", Charset.forName("GBK"));
        PGCharsetConverter.mapCharset("JOHAB", Charset.forName("JOHAB"));
        PGCharsetConverter.mapCharset("KOI8", Charset.forName("KOI8-U"));
        PGCharsetConverter.mapCharset("ISO_8859_5", Charset.forName("ISO-8859-5"));
        PGCharsetConverter.mapCharset("ISO_8859_5", Charset.forName("ISO-8859-6"));
        PGCharsetConverter.mapCharset("ISO_8859_5", Charset.forName("ISO-8859-7"));
        PGCharsetConverter.mapCharset("ISO_8859_5", Charset.forName("ISO-8859-8"));
        PGCharsetConverter.mapCharset("LATIN1", Charset.forName("ISO-8859-1"));
        PGCharsetConverter.mapCharset("LATIN2", Charset.forName("ISO-8859-2"));
        PGCharsetConverter.mapCharset("LATIN3", Charset.forName("ISO-8859-3"));
        PGCharsetConverter.mapCharset("LATIN4", Charset.forName("ISO-8859-4"));
        PGCharsetConverter.mapCharset("LATIN5", Charset.forName("ISO-8859-9"));
        PGCharsetConverter.mapCharset("LATIN7", Charset.forName("ISO-8859-13"));
        PGCharsetConverter.mapCharset("LATIN9", Charset.forName("ISO-8859-15"));
        PGCharsetConverter.mapCharset("SJIS", Charset.forName("windows-932"));
        PGCharsetConverter.mapCharset("UHC", Charset.forName("windows-949"));
        PGCharsetConverter.mapCharset("UTF8", Charset.forName("UTF-8"));
        PGCharsetConverter.mapCharset("UNICODE", Charset.forName("UTF-8"));
        PGCharsetConverter.mapCharset("WIN866", Charset.forName("cp866"));
        PGCharsetConverter.mapCharset("WIN874", Charset.forName("cp874"));
        PGCharsetConverter.mapCharset("WIN1250", Charset.forName("windows-1250"));
        PGCharsetConverter.mapCharset("WIN1251", Charset.forName("windows-1251"));
        PGCharsetConverter.mapCharset("WIN1252", Charset.forName("windows-1252"));
        PGCharsetConverter.mapCharset("WIN1256", Charset.forName("windows-1256"));
        PGCharsetConverter.mapCharset("WIN1258", Charset.forName("windows-1258"));
    }
}

