/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final long serialVersionUID = 312177538191772674L;
    private NavigableMap<VDBKey, CompositeVDB> vdbRepo = new ConcurrentSkipListMap<VDBKey, CompositeVDB>();
    private MetadataStore systemStore;
    private MetadataStore odbcStore;
    private boolean odbcEnabled = false;
    private List<VDBLifeCycleListener> listeners = new CopyOnWriteArrayList<VDBLifeCycleListener>();
    private SystemFunctionManager systemFunctionManager;
    private Map<String, Datatype> datatypeMap = new HashMap<String, Datatype>();

    public void addVDB(VDBMetaData vdb, MetadataStore metadataStore, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, ConnectorManagerRepository cmr) throws VirtualDatabaseException {
        if (this.getVDB(vdb.getName(), vdb.getVersion()) != null) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40035, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40035, new Object[]{vdb.getName(), vdb.getVersion()}));
        }
        if (this.systemStore == null) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40036, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40036, new Object[0]));
        }
        if (this.odbcEnabled && this.odbcStore == null) {
            this.odbcStore = this.getODBCMetadataStore();
        }
        MetadataStore[] stores = null;
        stores = this.odbcStore == null ? new MetadataStore[]{this.systemStore} : new MetadataStore[]{this.systemStore, this.odbcStore};
        CompositeVDB cvdb = new CompositeVDB(vdb, metadataStore, visibilityMap, udf, this.systemFunctionManager.getSystemFunctions(), cmr, stores);
        this.vdbRepo.put(this.vdbId(vdb), cvdb);
        this.notifyAdd(vdb.getName(), vdb.getVersion(), cvdb);
    }

    public VDBMetaData getVDB(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        return vdbs;
    }

    protected VDBKey vdbId(VDBMetaData vdb) {
        return new VDBKey(vdb.getName(), vdb.getVersion());
    }

    public VDBMetaData getVDB(String vdbName) {
        int latestVersion = 0;
        VDBMetaData result = null;
        for (Map.Entry<VDBKey, CompositeVDB> entry : this.vdbRepo.tailMap(new VDBKey(vdbName, 0)).entrySet()) {
            if (!entry.getKey().getName().equalsIgnoreCase(vdbName)) break;
            VDBMetaData vdb = entry.getValue().getVDB();
            switch (vdb.getConnectionType()) {
                case ANY: {
                    if (vdb.getVersion() <= latestVersion) break;
                    latestVersion = vdb.getVersion();
                    result = vdb;
                    break;
                }
                case BY_VERSION: {
                    if (latestVersion != 0) break;
                    latestVersion = vdb.getVersion();
                    result = vdb;
                }
            }
        }
        return result;
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }

    public MetadataStore getODBCStore() {
        return this.odbcStore;
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
        Collection<Datatype> datatypes = this.systemStore.getDatatypes().values();
        block0: for (String typeName : DataTypeManager.getAllDataTypeNames()) {
            boolean found = false;
            for (Datatype datatypeRecordImpl : datatypes) {
                if (!datatypeRecordImpl.getRuntimeTypeName().equalsIgnoreCase(typeName)) continue;
                this.datatypeMap.put(typeName, datatypeRecordImpl);
                found = true;
                break;
            }
            if (found) continue;
            for (Datatype datatypeRecordImpl : datatypes) {
                if (!datatypeRecordImpl.getJavaClassName().equals(DataTypeManager.getDataTypeClass((String)typeName))) continue;
                this.datatypeMap.put(typeName, datatypeRecordImpl);
                continue block0;
            }
        }
        this.addAliasType(datatypes, "bigint");
        this.addAliasType(datatypes, "decimal");
        this.addAliasType(datatypes, "real");
        this.addAliasType(datatypes, "smallint");
        this.addAliasType(datatypes, "tinyint");
        this.addAliasType(datatypes, "varchar");
    }

    private void addAliasType(Collection<Datatype> datatypes, String alias) {
        Class typeClass = DataTypeManager.getDataTypeClass((String)alias);
        for (Datatype datatypeRecordImpl : datatypes) {
            if (!datatypeRecordImpl.getJavaClassName().equals(typeClass.getName())) continue;
            this.datatypeMap.put(alias, datatypeRecordImpl);
            break;
        }
    }

    private MetadataStore getODBCMetadataStore() {
        try {
            PgCatalogMetadataStore pg = new PgCatalogMetadataStore("pg_catalog", this.getBuiltinDatatypes());
            return pg.asMetadataStore();
        }
        catch (TranslatorException e) {
            LogManager.logError((String)"org.teiid.PROCESSOR", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40002, new Object[0]));
            return null;
        }
    }

    public void odbcEnabled() {
        this.odbcEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        CompositeVDB removed = (CompositeVDB)this.vdbRepo.remove(key);
        if (removed != null) {
            Iterator i$ = this.vdbRepo.values().iterator();
            while (i$.hasNext()) {
                CompositeVDB other;
                CompositeVDB compositeVDB = other = (CompositeVDB)i$.next();
                synchronized (compositeVDB) {
                    if (other.hasChildVdb(key)) {
                        this.notifyRemove(other.getVDB().getName(), other.getVDB().getVersion(), other);
                        other.removeChild(key);
                        this.notifyAdd(other.getVDB().getName(), other.getVDB().getVersion(), other);
                    }
                }
            }
            this.notifyRemove(key.getName(), key.getVersion(), removed);
            return true;
        }
        return false;
    }

    public Map<String, Datatype> getBuiltinDatatypes() {
        return this.datatypeMap;
    }

    public void mergeVDBs(String sourceVDBName, int sourceVDBVersion, String targetVDBName, int targetVDBVersion) throws AdminException {
        CompositeVDB source = (CompositeVDB)this.vdbRepo.get(new VDBKey(sourceVDBName, sourceVDBVersion));
        if (source == null) {
            throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40037, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40037, new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        CompositeVDB target = (CompositeVDB)this.vdbRepo.get(new VDBKey(targetVDBName, targetVDBVersion));
        if (target == null) {
            throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40038, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40038, new Object[]{sourceVDBName, sourceVDBVersion}));
        }
        this.notifyRemove(targetVDBName, targetVDBVersion, target);
        target.addChild(source);
        this.notifyAdd(targetVDBName, targetVDBVersion, target);
        this.finishDeployment(targetVDBName, targetVDBVersion);
    }

    public void start() {
        if (this.odbcEnabled) {
            this.odbcStore = this.getODBCMetadataStore();
        }
    }

    public void finishDeployment(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            boolean valid = false;
            v.metadataLoadFinished();
            VDBMetaData metdataAwareVDB = v.getVDB();
            ValidatorReport report = MetadataValidator.validate((VDBMetaData)metdataAwareVDB, (MetadataStore)((MetadataStore)metdataAwareVDB.removeAttachment(MetadataStore.class)));
            if (!report.hasItems()) {
                valid = true;
            } else {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40073, new Object[]{name, version}));
            }
            if (valid) {
                valid = this.hasValidDataSources(metdataAwareVDB);
            }
            if (valid) {
                metdataAwareVDB.setStatus(VDB.Status.ACTIVE);
            } else {
                metdataAwareVDB.setStatus(VDB.Status.INACTIVE);
            }
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)(VDB.Status.ACTIVE == metdataAwareVDB.getStatus() ? RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{name, version}) : RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40006, new Object[]{name, version})));
            this.notifyFinished(name, version, v);
        }
    }

    boolean hasValidDataSources(VDBMetaData vdb) {
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (!model.isSource()) continue;
            List mappings = model.getSourceMappings();
            for (SourceMappingMetadata mapping : mappings) {
                String msg;
                ConnectorManager cm = cmr.getConnectorManager(mapping.getName());
                if (cm == null || (msg = cm.getStausMessage()) == null || msg.length() <= 0) continue;
                model.addError(ModelMetaData.ValidationError.Severity.ERROR.name(), cm.getStausMessage());
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)cm.getStausMessage());
            }
        }
        return vdb.isValid();
    }

    private void notifyFinished(String name, int version, CompositeVDB v) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.finishedDeployment(name, version, v);
        }
    }

    public void addListener(VDBLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(VDBLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAdd(String name, int version, CompositeVDB vdb) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.added(name, version, vdb);
        }
    }

    private void notifyRemove(String name, int version, CompositeVDB vdb) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.removed(name, version, vdb);
        }
    }

    public void setSystemFunctionManager(SystemFunctionManager mgr) {
        this.systemFunctionManager = mgr;
    }
}

