/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.PgCatalogMetadataStore;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataStore;
import org.teiid.net.ConnectionException;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.MetadataValidator;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.TranslatorException;
import org.teiid.vdb.runtime.VDBKey;

public class VDBRepository
implements Serializable {
    private static final long serialVersionUID = 312177538191772674L;
    private static final int DEFAULT_TIMEOUT_MILLIS = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.clientVdbLoadTimeoutMillis", (int)300000);
    private NavigableMap<VDBKey, CompositeVDB> vdbRepo = new ConcurrentSkipListMap<VDBKey, CompositeVDB>();
    private NavigableMap<VDBKey, VDBMetaData> pendingDeployments = new ConcurrentSkipListMap<VDBKey, VDBMetaData>();
    private MetadataStore systemStore = SystemMetadata.getInstance().getSystemStore();
    private MetadataStore odbcStore;
    private boolean odbcEnabled = false;
    private List<VDBLifeCycleListener> listeners = new CopyOnWriteArrayList<VDBLifeCycleListener>();
    private SystemFunctionManager systemFunctionManager;
    private Map<String, Datatype> datatypeMap = SystemMetadata.getInstance().getBuiltinTypeMap();
    private ReentrantLock lock = new ReentrantLock();
    private Condition vdbAdded = this.lock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVDB(VDBMetaData vdb, MetadataStore metadataStore, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, ConnectorManagerRepository cmr) throws VirtualDatabaseException {
        VDBKey key = this.vdbId(vdb);
        if (this.systemStore == null) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40022, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40022, new Object[0]));
        }
        if (this.odbcEnabled && this.odbcStore == null) {
            this.odbcStore = this.getODBCMetadataStore();
        }
        MetadataStore[] stores = null;
        stores = this.odbcStore == null ? new MetadataStore[]{this.systemStore} : new MetadataStore[]{this.systemStore, this.odbcStore};
        CompositeVDB cvdb = new CompositeVDB(vdb, metadataStore, visibilityMap, udf, this.systemFunctionManager.getSystemFunctions(), cmr, this, stores);
        this.lock.lock();
        try {
            if (this.vdbRepo.containsKey(key)) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40035, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40035, new Object[]{vdb.getName(), vdb.getVersion()}));
            }
            this.vdbRepo.put(key, cvdb);
            this.pendingDeployments.remove(key);
            this.vdbAdded.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        this.notifyAdd(vdb.getName(), vdb.getVersion(), cvdb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinished(String vdbName, int vdbVersion, int timeOutMillis) throws ConnectionException {
        CompositeVDB cvdb = null;
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        long timeOutNanos = 0L;
        timeOutNanos = timeOutMillis >= 0 ? TimeUnit.MILLISECONDS.toNanos(DEFAULT_TIMEOUT_MILLIS) : TimeUnit.MINUTES.toNanos(10L);
        this.lock.lock();
        try {
            while ((cvdb = (CompositeVDB)this.vdbRepo.get(key)) == null) {
                if (timeOutNanos <= 0L) {
                    throw new ConnectionException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40096, new Object[]{timeOutMillis, vdbName, vdbVersion}));
                }
                timeOutNanos = this.vdbAdded.awaitNanos(timeOutNanos);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            this.lock.unlock();
        }
        VDBMetaData vdb = cvdb.getVDB();
        long finishNanos = System.nanoTime() + timeOutNanos;
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            while (vdb.getStatus() != VDB.Status.ACTIVE) {
                if (timeOutNanos <= 0L) {
                    throw new ConnectionException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40097, new Object[]{timeOutMillis, vdbName, vdbVersion, vdb.getValidityErrors()}));
                }
                try {
                    vdb.wait(timeOutNanos);
                }
                catch (InterruptedException e) {
                    return;
                }
                timeOutNanos = finishNanos - System.nanoTime();
            }
        }
    }

    CompositeVDB getCompositeVDB(VDBKey key) {
        return (CompositeVDB)this.vdbRepo.get(key);
    }

    public VDBMetaData getLiveVDB(String name, int version) {
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(new VDBKey(name, version));
        if (v != null) {
            return v.getVDB();
        }
        return null;
    }

    public List<VDBMetaData> getVDBs() {
        ArrayList<VDBMetaData> vdbs = new ArrayList<VDBMetaData>();
        for (CompositeVDB cVDB : this.vdbRepo.values()) {
            vdbs.add(cVDB.getVDB());
        }
        vdbs.addAll(this.pendingDeployments.values());
        return vdbs;
    }

    Collection<CompositeVDB> getCompositeVDBs() {
        return this.vdbRepo.values();
    }

    protected VDBKey vdbId(VDBMetaData vdb) {
        return new VDBKey(vdb.getName(), vdb.getVersion());
    }

    public VDBMetaData getLiveVDB(String vdbName) {
        int latestVersion = 0;
        VDBMetaData result = null;
        for (Map.Entry<VDBKey, CompositeVDB> entry : this.vdbRepo.tailMap(new VDBKey(vdbName, 0)).entrySet()) {
            if (!entry.getKey().getName().equalsIgnoreCase(vdbName)) break;
            VDBMetaData vdb = entry.getValue().getVDB();
            switch (vdb.getConnectionType()) {
                case ANY: {
                    if (vdb.getVersion() <= latestVersion) break;
                    latestVersion = vdb.getVersion();
                    result = vdb;
                    break;
                }
                case BY_VERSION: {
                    if (latestVersion != 0) break;
                    latestVersion = vdb.getVersion();
                    result = vdb;
                }
            }
        }
        return result;
    }

    public MetadataStore getSystemStore() {
        return this.systemStore;
    }

    public MetadataStore getODBCStore() {
        return this.odbcStore;
    }

    public void setSystemStore(MetadataStore store) {
        this.systemStore = store;
    }

    private MetadataStore getODBCMetadataStore() {
        try {
            PgCatalogMetadataStore pg = new PgCatalogMetadataStore("pg_catalog", this.getBuiltinDatatypes());
            return pg.asMetadataStore();
        }
        catch (TranslatorException e) {
            LogManager.logError((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40002, new Object[0]));
            return null;
        }
    }

    public void odbcEnabled() {
        this.odbcEnabled = true;
    }

    public VDBMetaData removeVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        return this.removeVDB(key);
    }

    private VDBMetaData removeVDB(VDBKey key) {
        this.pendingDeployments.remove(key);
        CompositeVDB removed = (CompositeVDB)this.vdbRepo.remove(key);
        if (removed == null) {
            return null;
        }
        removed.getVDB().setStatus(VDB.Status.REMOVED);
        this.notifyRemove(key.getName(), key.getVersion(), removed);
        return removed.getVDB();
    }

    public Map<String, Datatype> getBuiltinDatatypes() {
        return this.datatypeMap;
    }

    public void start() {
        if (this.odbcEnabled) {
            this.odbcStore = this.getODBCMetadataStore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDeployment(String name, int version) {
        VDBKey key = new VDBKey(name, version);
        CompositeVDB v = (CompositeVDB)this.vdbRepo.get(key);
        if (v == null) {
            return;
        }
        VDBMetaData metadataAwareVDB = v.getVDB();
        if (v.getOriginalVDB().getStatus() == VDB.Status.FAILED) {
            if (v.getOriginalVDB() != metadataAwareVDB && metadataAwareVDB.getStatus() == VDB.Status.LOADING) {
                metadataAwareVDB.setStatus(VDB.Status.FAILED);
            }
            return;
        }
        v.metadataLoadFinished();
        VDBMetaData vDBMetaData = metadataAwareVDB;
        synchronized (vDBMetaData) {
            ValidatorReport report = new MetadataValidator().validate(metadataAwareVDB, (MetadataStore)metadataAwareVDB.removeAttachment(MetadataStore.class));
            if (report.hasItems()) {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40073, new Object[]{name, version}));
                if (!v.getVDB().isPreview()) {
                    this.processMetadataValidatorReport(key, report);
                    v.getVDB().setStatus(VDB.Status.FAILED);
                    LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{name, version, metadataAwareVDB.getStatus()}));
                    return;
                }
            }
            this.validateDataSources(metadataAwareVDB);
            metadataAwareVDB.setStatus(VDB.Status.ACTIVE);
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{name, version, metadataAwareVDB.getStatus()}));
            this.notifyFinished(name, version, v);
        }
    }

    protected void processMetadataValidatorReport(VDBKey key, ValidatorReport report) {
    }

    void validateDataSources(VDBMetaData vdb) {
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (!model.isSource()) continue;
            List mappings = model.getSourceMappings();
            for (SourceMappingMetadata mapping : mappings) {
                String msg;
                ConnectorManager cm = cmr.getConnectorManager(mapping.getName());
                if (cm == null || (msg = cm.getStausMessage()) == null || msg.length() <= 0) continue;
                model.addRuntimeError(msg);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
    }

    private void notifyFinished(String name, int version, CompositeVDB v) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.finishedDeployment(name, version, v);
        }
    }

    public void addListener(VDBLifeCycleListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(VDBLifeCycleListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAdd(String name, int version, CompositeVDB vdb) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.added(name, version, vdb);
        }
    }

    private void notifyRemove(String name, int version, CompositeVDB vdb) {
        for (VDBLifeCycleListener l : this.listeners) {
            l.removed(name, version, vdb);
        }
    }

    public void setSystemFunctionManager(SystemFunctionManager mgr) {
        this.systemFunctionManager = mgr;
    }

    public void addPendingDeployment(VDBMetaData deployment) {
        VDBKey key = this.vdbId(deployment);
        this.pendingDeployments.put(key, deployment);
    }

    public VDBMetaData getVDB(String vdbName, int vdbVersion) {
        VDBKey key = new VDBKey(vdbName, vdbVersion);
        CompositeVDB cvdb = (CompositeVDB)this.vdbRepo.get(key);
        if (cvdb != null) {
            return cvdb.getVDB();
        }
        return (VDBMetaData)this.pendingDeployments.get(key);
    }
}

