/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import org.teiid.cache.Cache;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.ReplicatedObject;
import org.teiid.runtime.EmbeddedServer;

class ReplicatedCacheImpl<K extends Serializable, V>
implements EmbeddedServer.ReplicatedCache<K, V>,
ReplicatedObject<K> {
    private Cache<K, V> cache;

    public ReplicatedCacheImpl(Cache<K, V> cache) {
        this.cache = cache;
    }

    public void clear() {
        this.cache.clear();
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    public String getName() {
        return this.cache.getName();
    }

    public Set<K> keys() {
        return this.cache.keys();
    }

    @Override
    public V put(K key, V value, Long ttl) {
        return (V)this.cache.put(key, value, ttl);
    }

    @Override
    public V remove(K key) {
        return (V)this.cache.remove(key);
    }

    public int size() {
        return this.cache.size();
    }

    public void getState(K stateId, OutputStream ostream) {
        V value = this.get(stateId);
        if (value != null) {
            try {
                ObjectOutputStream oos = new ObjectOutputStream(ostream);
                oos.writeObject(value);
                oos.close();
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
    }

    public void setState(K stateId, InputStream istream) {
        try {
            ObjectInputStream ois = new ObjectInputStream(istream);
            Object value = ois.readObject();
            this.put(stateId, (V)value, (Long)null);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public boolean hasState(K stateId) {
        return this.cache.get(stateId) != null;
    }

    public void droppedMembers(Collection<Serializable> addresses) {
    }

    public void getState(OutputStream ostream) {
    }

    public void setAddress(Serializable address) {
    }

    public void setState(InputStream istream) {
    }
}

