/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class CombinedClassLoader
extends ClassLoader {
    private ClassLoader[] toSearch;

    public CombinedClassLoader(ClassLoader parent, ClassLoader ... toSearch) {
        super(parent);
        this.toSearch = toSearch;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.toSearch) {
            if (cl == null) continue;
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return super.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        for (ClassLoader cl : this.toSearch) {
            URL url;
            if (cl == null || (url = cl.getResource(name)) == null) continue;
            return url;
        }
        return super.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Vector<URL> result = new Vector<URL>();
        for (ClassLoader cl : this.toSearch) {
            if (cl == null) continue;
            Enumeration<URL> url = cl.getResources(name);
            result.addAll(Collections.list(url));
        }
        return result.elements();
    }
}

