/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executor;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.vdb.runtime.VDBKey;

public abstract class MaterializationManager
implements VDBLifeCycleListener {
    private Map<VDBKey, List<TimerTask>> scheduledTasks = Collections.synchronizedMap(new HashMap());
    private ContainerLifeCycleListener shutdownListener;

    public MaterializationManager(ContainerLifeCycleListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    @Override
    public void added(String name, int version, CompositeVDB cvdb, boolean reloading) {
    }

    @Override
    public void beforeRemove(String name, int version, CompositeVDB cvdb) {
        if (cvdb == null) {
            return;
        }
        final VDBMetaData vdb = cvdb.getVDB();
        List<TimerTask> tasks = this.scheduledTasks.remove(new VDBKey(vdb.getName(), vdb.getVersion()));
        if (tasks != null && !tasks.isEmpty()) {
            for (TimerTask tt : tasks) {
                tt.cancel();
            }
        }
        if (!this.shutdownListener.isShutdownInProgress()) {
            this.doMaterializationActions(vdb, new MaterializationAction(){

                @Override
                public void process(Table table) {
                    String remove = table.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_DROP_SCRIPT", false);
                    if (remove != null) {
                        for (String cmd : StringUtil.tokenize((String)remove, (char)';')) {
                            try {
                                MaterializationManager.this.executeQuery(vdb, cmd);
                            }
                            catch (SQLException e) {
                                LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void removed(String name, int version, CompositeVDB cvdb) {
    }

    @Override
    public void finishedDeployment(String name, int version, CompositeVDB cvdb, final boolean reloading) {
        final VDBMetaData vdb = cvdb.getVDB();
        this.doMaterializationActions(vdb, new MaterializationAction(){

            @Override
            public void process(Table table) {
                long ttl;
                String ttlStr;
                String start;
                if (!reloading && (start = table.getProperty("{http://www.teiid.org/ext/relational/2012}ON_VDB_START_SCRIPT", false)) != null) {
                    for (String script : StringUtil.tokenize((String)start, (char)';')) {
                        try {
                            MaterializationManager.this.executeQuery(vdb, script);
                        }
                        catch (SQLException e) {
                            LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                        }
                    }
                }
                if ((ttlStr = table.getProperty("{http://www.teiid.org/ext/relational/2012}MATVIEW_TTL", false)) != null && (ttl = Long.parseLong(ttlStr)) > 0L) {
                    MaterializationManager.this.scheduleJob(vdb, table, ttl, 0L);
                }
            }
        });
    }

    private void doMaterializationActions(VDBMetaData vdb, MaterializationAction action) {
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return;
        }
        Set imports = vdb.getImportedModels();
        CompositeMetadataStore store = metadata.getMetadataStore();
        for (Schema schema : store.getSchemaList()) {
            if (imports.contains(schema.getName())) continue;
            for (Table table : schema.getTables().values()) {
                if (!table.isVirtual() || !table.isMaterialized() || table.getMaterializedTable() == null || !Boolean.valueOf(table.getProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", false)).booleanValue()) continue;
                action.process(table);
            }
        }
    }

    public void scheduleJob(VDBMetaData vdb, Table table, long ttl, long delay) {
        JobSchedular task = new JobSchedular(vdb, table, ttl, delay);
        this.queueTask(vdb, task, delay);
    }

    private void runJob(VDBMetaData vdb, Table table, long ttl, long delay) {
        QueryJob task = new QueryJob(vdb, table, ttl, delay);
        this.queueTask(vdb, task, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueTask(VDBMetaData vdb, TimerTask task, long delay) {
        VDBKey key = new VDBKey(vdb.getName(), vdb.getVersion());
        List<TimerTask> tasks = this.scheduledTasks.get(key);
        if (tasks == null) {
            tasks = new ArrayList<TimerTask>();
            this.scheduledTasks.put(key, tasks);
        }
        List<TimerTask> list = tasks;
        synchronized (list) {
            tasks.add(task);
        }
        this.getTimer().schedule(task, delay < 0L ? 0L : delay);
    }

    public abstract Timer getTimer();

    public abstract Executor getExecutor();

    public abstract List<Map<String, String>> executeQuery(VDBMetaData var1, String var2) throws SQLException;

    class QueryJob
    extends JobSchedular {
        public QueryJob(VDBMetaData vdb, Table table, long ttl, long delay) {
            super(vdb, table, ttl, delay);
        }

        @Override
        public void run() {
            MaterializationManager.this.scheduledTasks.remove(this);
            MaterializationManager.this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    String query = "execute SYSADMIN.loadMatView('" + StringUtil.replaceAll((String)((Schema)QueryJob.this.table.getParent()).getName(), (String)"'", (String)"''") + "','" + StringUtil.replaceAll((String)QueryJob.this.table.getName(), (String)"'", (String)"''") + "')";
                    try {
                        MaterializationManager.this.executeQuery(QueryJob.this.vdb, query);
                        MaterializationManager.this.scheduleJob(QueryJob.this.vdb, QueryJob.this.table, QueryJob.this.ttl, QueryJob.this.ttl);
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                        MaterializationManager.this.scheduleJob(QueryJob.this.vdb, QueryJob.this.table, QueryJob.this.ttl, Math.min(QueryJob.this.ttl / 4L, 60000L));
                        return;
                    }
                }
            });
        }
    }

    class JobSchedular
    extends TimerTask {
        protected Table table;
        protected long ttl;
        protected long delay;
        protected VDBMetaData vdb;

        public JobSchedular(VDBMetaData vdb, Table table, long ttl, long delay) {
            this.vdb = vdb;
            this.table = table;
            this.ttl = ttl;
            this.delay = delay;
        }

        @Override
        public void run() {
            Map<String, String> row;
            MaterializationManager.this.scheduledTasks.remove(this);
            String query = "execute SYSADMIN.matViewStatus('" + ((Schema)this.table.getParent()).getName() + "', '" + this.table.getName() + "')";
            List<Map<String, String>> result = null;
            try {
                result = MaterializationManager.this.executeQuery(this.vdb, query);
            }
            catch (SQLException e) {
                LogManager.logWarning((String)"org.teiid.PROCESSOR.MATVIEWS", (Throwable)e, (Object)e.getMessage());
                MaterializationManager.this.scheduleJob(this.vdb, this.table, this.ttl, Math.min(this.ttl / 4L, 60000L));
                return;
            }
            long updated = 0L;
            this.delay = this.ttl;
            String loadstate = null;
            boolean valid = false;
            if (result != null && !result.isEmpty() && (row = result.get(0)) != null) {
                loadstate = row.get("LoadState");
                updated = Long.parseLong(row.get("Updated"));
                valid = Boolean.parseBoolean(row.get("Valid"));
            }
            long elapsed = System.currentTimeMillis() - updated;
            if (loadstate == null || loadstate.equalsIgnoreCase("needs_loading") || !valid) {
                MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, 0L);
            } else if (!loadstate.equalsIgnoreCase("loading")) {
                if (loadstate.equalsIgnoreCase("loaded")) {
                    if (elapsed >= this.ttl) {
                        MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, 0L);
                    } else {
                        MaterializationManager.this.scheduleJob(this.vdb, this.table, this.ttl, this.ttl - elapsed);
                    }
                } else if (loadstate.equalsIgnoreCase("failed_load")) {
                    if (elapsed > this.ttl / 4L || elapsed > 60000L) {
                        MaterializationManager.this.runJob(this.vdb, this.table, this.ttl, 0L);
                    } else {
                        MaterializationManager.this.scheduleJob(this.vdb, this.table, this.ttl, Math.min(this.ttl / 4L - elapsed, 60000L - elapsed));
                    }
                }
            }
        }
    }

    private static interface MaterializationAction {
        public void process(Table var1);
    }
}

