/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.teiid.replication.jgroups.ChannelFactory;
import org.teiid.runtime.EmbeddedConfiguration;

final class SimpleChannelFactory
implements ChannelFactory,
ChannelListener {
    private final EmbeddedConfiguration embeddedConfiguration;
    private final Map<Channel, String> channels = Collections.synchronizedMap(new WeakHashMap());

    SimpleChannelFactory(EmbeddedConfiguration embeddedConfiguration) {
        this.embeddedConfiguration = embeddedConfiguration;
    }

    @Override
    public Channel createChannel(String id) throws Exception {
        JChannel channel = new JChannel(this.getClass().getClassLoader().getResource(this.embeddedConfiguration.getJgroupsConfigFile()));
        this.channels.put((Channel)channel, id);
        channel.addChannelListener((ChannelListener)this);
        return channel;
    }

    public void channelClosed(Channel channel) {
        this.channels.remove(channel);
    }

    public void channelConnected(Channel channel) {
    }

    public void channelDisconnected(Channel channel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Map<Channel, String> map = this.channels;
        synchronized (map) {
            for (Channel c : new ArrayList<Channel>(this.channels.keySet())) {
                c.close();
            }
            this.channels.clear();
        }
    }
}

