/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketClientInstance;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListenerStats;

public class SocketListener
implements ChannelListener.ChannelListenerFactory {
    private SSLAwareChannelHandler channelHandler;
    private Channel serverChanel;
    private boolean isClientEncryptionEnabled;
    private ExecutorService nettyPool;
    private ClientServiceRegistryImpl csr;
    private ServerBootstrap bootstrap;

    public SocketListener(InetSocketAddress address, SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager) {
        this(address, config.getInputBufferSize(), config.getOutputBufferSize(), config.getMaxSocketThreads(), config.getSSLConfiguration(), csr, storageManager);
        LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)RuntimePlugin.Util.getString("SocketTransport.1", new Object[]{address.getHostName(), String.valueOf(config.getPortNumber())}));
    }

    public SocketListener(InetSocketAddress address, int inputBufferSize, int outputBufferSize, int maxWorkers, SSLConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager) {
        if (config != null) {
            this.isClientEncryptionEnabled = config.isClientEncryptionEnabled();
        }
        this.csr = csr;
        this.nettyPool = Executors.newCachedThreadPool((ThreadFactory)new NamedThreadFactory("NIO"));
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.TRANSPORT", (int)5)) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)("server = " + address.getAddress() + "binding to port:" + address.getPort()));
        }
        if (maxWorkers == 0) {
            maxWorkers = Math.max(4, 2 * Runtime.getRuntime().availableProcessors());
        }
        NioServerSocketChannelFactory factory = new NioServerSocketChannelFactory((Executor)this.nettyPool, (Executor)this.nettyPool, maxWorkers);
        this.bootstrap = new ServerBootstrap((ChannelFactory)factory);
        this.channelHandler = this.createChannelPipelineFactory(config, storageManager);
        this.bootstrap.setPipelineFactory((ChannelPipelineFactory)this.channelHandler);
        if (inputBufferSize != 0) {
            this.bootstrap.setOption("child.receiveBufferSize", (Object)new Integer(inputBufferSize));
        }
        if (outputBufferSize != 0) {
            this.bootstrap.setOption("child.sendBufferSize", (Object)new Integer(outputBufferSize));
        }
        this.bootstrap.setOption("child.tcpNoDelay", (Object)true);
        this.bootstrap.setOption("child.keepAlive", (Object)Boolean.TRUE);
        this.serverChanel = this.bootstrap.bind((SocketAddress)address);
    }

    public int getPort() {
        return ((InetSocketAddress)this.serverChanel.getLocalAddress()).getPort();
    }

    public void stop() {
        ChannelFuture future = this.serverChanel.close();
        this.bootstrap.shutdown();
        try {
            future.await();
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public SocketListenerStats getStats() {
        SocketListenerStats stats = new SocketListenerStats();
        stats.objectsRead = this.channelHandler.getObjectsRead();
        stats.objectsWritten = this.channelHandler.getObjectsWritten();
        stats.sockets = this.channelHandler.getConnectedChannels();
        stats.maxSockets = this.channelHandler.getMaxConnectedChannels();
        return stats;
    }

    protected SSLAwareChannelHandler createChannelPipelineFactory(SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager);
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new SocketClientInstance(channel, this.csr, this.isClientEncryptionEnabled);
    }

    SSLAwareChannelHandler getChannelHandler() {
        return this.channelHandler;
    }
}

