/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.tempdata.TempTable;
import org.teiid.runtime.RuntimePlugin;

public class CompositeGlobalTableStore
implements GlobalTableStore {
    private Map<String, GlobalTableStore> stores;
    private GlobalTableStore primary;
    private QueryMetadataInterface metadata;

    public static GlobalTableStore createInstance(String nodeName, CompositeVDB vdb, BufferManager bufferManager, ObjectReplicator replicator) {
        VDBMetaData vdbMetadata = vdb.getVDB();
        QueryMetadataInterface metadata = (QueryMetadataInterface)vdbMetadata.getAttachment(TransformationMetadata.class);
        GlobalTableStoreImpl gts = new GlobalTableStoreImpl(bufferManager, vdbMetadata, metadata);
        if (replicator != null) {
            try {
                gts = (GlobalTableStore)replicator.replicate(nodeName, vdbMetadata.getFullName(), GlobalTableStore.class, (Object)gts, 300000L);
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40088, new Object[]{gts}));
            }
        }
        if (vdb.getChildren() == null) {
            return gts;
        }
        TreeMap<String, GlobalTableStore> stores = new TreeMap<String, GlobalTableStore>(String.CASE_INSENSITIVE_ORDER);
        CompositeGlobalTableStore.buildStoreMap(vdb, stores);
        return new CompositeGlobalTableStore(stores, (GlobalTableStore)gts, metadata);
    }

    static void buildStoreMap(CompositeVDB vdb, TreeMap<String, GlobalTableStore> stores) {
        for (CompositeVDB cvdb : vdb.getChildren().values()) {
            VDBMetaData child = cvdb.getVDB();
            GlobalTableStore childGts = (GlobalTableStore)child.getAttachment(GlobalTableStore.class);
            if (cvdb.getChildren() != null) {
                CompositeGlobalTableStore.buildStoreMap(cvdb, stores);
            }
            for (String name : child.getModelMetaDatas().keySet()) {
                if (cvdb.getChildren() != null && child.getImportedModels().contains(name)) continue;
                stores.put(name, childGts);
            }
        }
    }

    public CompositeGlobalTableStore(Map<String, GlobalTableStore> stores, GlobalTableStore primary, QueryMetadataInterface metadata) {
        this.stores = stores;
        this.primary = primary;
        this.metadata = metadata;
    }

    public TempMetadataID getGlobalTempTableMetadataId(Object groupID) throws TeiidComponentException, TeiidProcessingException {
        Object mid = this.metadata.getModelID(groupID);
        String name = this.metadata.getName(mid);
        return this.getStore(name).getGlobalTempTableMetadataId(groupID);
    }

    public TempMetadataID getGlobalTempTableMetadataId(String matTableName) {
        return this.getStoreForTable(matTableName).getGlobalTempTableMetadataId(matTableName);
    }

    public TempMetadataID getCodeTableMetadataId(String codeTableName, String returnElementName, String keyElementName, String matTableName) throws TeiidComponentException, QueryMetadataException {
        return this.getStoreForTable(matTableName).getCodeTableMetadataId(codeTableName, returnElementName, keyElementName, matTableName);
    }

    public GlobalTableStoreImpl.MatTableInfo getMatTableInfo(String matTableName) {
        return this.getStoreForTable(matTableName).getMatTableInfo(matTableName);
    }

    public TempTable getTempTable(String matTableName) {
        return this.getStoreForTable(matTableName).getTempTable(matTableName);
    }

    public Serializable getAddress() {
        return this.primary.getAddress();
    }

    public List<?> updateMatViewRow(String matTableName, List<?> tuple, boolean delete) throws TeiidComponentException {
        return this.getStoreForTable(matTableName).updateMatViewRow(matTableName, tuple, delete);
    }

    public TempTable createMatTable(String matTableName, GroupSymbol group) throws TeiidComponentException, QueryMetadataException, TeiidProcessingException {
        return this.getStoreForTable(matTableName).createMatTable(matTableName, group);
    }

    public void failedLoad(String matTableName) {
        this.getStoreForTable(matTableName).failedLoad(matTableName);
    }

    public boolean needsLoading(String matTableName, Serializable loadingAddress, boolean firstPass, boolean refresh, boolean invalidate) {
        return this.getStoreForTable(matTableName).needsLoading(matTableName, loadingAddress, firstPass, refresh, invalidate);
    }

    public void loaded(String matTableName, TempTable table) {
        this.getStoreForTable(matTableName).loaded(matTableName, table);
    }

    GlobalTableStore getStoreForTable(String matTableName) {
        String name = matTableName.substring("#MAT_".length(), matTableName.length());
        name = name.substring(0, name.indexOf(46));
        return this.getStore(name);
    }

    GlobalTableStore getStore(String name) {
        GlobalTableStore store = this.stores.get(name);
        if (store == null) {
            return this.primary;
        }
        return store;
    }

    GlobalTableStore getPrimary() {
        return this.primary;
    }
}

