/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    public static final long MAX_LOB_SIZE = 0x100000000L;
    private final ClassLoader classLoader;
    private Object result;
    private int streamIndex;
    private OutputStream stream;
    private List<InputStreamFactory.StreamFactoryReference> streams;
    private StorageManager storageManager;
    private FileStore store;
    private StreamCorruptedException error;
    private int streamDataToRead = -1;
    private long maxLobSize = 0x100000000L;

    public ObjectDecoder(int maxObjectSize, long maxLobSize, ClassLoader classLoader, StorageManager storageManager) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classLoader = classLoader;
        this.storageManager = storageManager;
        this.maxLobSize = maxLobSize;
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        if (this.result == null) {
            ByteBuf frame = (ByteBuf)super.decode(ctx, buffer);
            if (frame == null) {
                return null;
            }
            CompactObjectInputStream cois = new CompactObjectInputStream((InputStream)new ByteBufInputStream(frame), this.classLoader);
            this.result = cois.readObject();
            this.streams = ExternalizeUtil.readList((ObjectInput)cois, InputStreamFactory.StreamFactoryReference.class);
            this.streamIndex = 0;
        }
        while (this.streamIndex < this.streams.size()) {
            int toRead;
            if (this.streamDataToRead == -1) {
                if (buffer.readableBytes() < 2) {
                    return null;
                }
                this.streamDataToRead = buffer.readUnsignedShort();
            }
            if (this.stream == null) {
                this.store = this.storageManager.createFileStore("temp-stream");
                InputStreamFactory.StreamFactoryReference sfr = this.streams.get(this.streamIndex);
                sfr.setStreamFactory((InputStreamFactory)new FileStoreInputStreamFactory(this.store, "UTF-8"));
                this.stream = new BufferedOutputStream(this.store.createOutputStream());
            }
            if (this.streamDataToRead == 0) {
                this.stream.close();
                this.stream = null;
                ++this.streamIndex;
                this.streamDataToRead = -1;
                continue;
            }
            if (this.store.getLength() + (long)this.streamDataToRead > this.maxLobSize && this.error == null) {
                this.error = new StreamCorruptedException("lob too big: " + (this.store.getLength() + (long)this.streamDataToRead) + " (max: " + this.maxLobSize + ')');
            }
            if ((toRead = Math.min(buffer.readableBytes(), this.streamDataToRead)) == 0) {
                return null;
            }
            if (this.error == null) {
                buffer.readBytes(this.stream, toRead);
            } else {
                buffer.skipBytes(toRead);
            }
            this.streamDataToRead -= toRead;
            if (this.streamDataToRead != 0) continue;
            this.streamDataToRead = -1;
        }
        Object toReturn = this.result;
        this.result = null;
        this.streams = null;
        this.stream = null;
        this.store = null;
        if (this.error != null) {
            StreamCorruptedException sce = this.error;
            this.error = null;
            throw sce;
        }
        return toReturn;
    }

    protected ByteBuf extractFrame(ChannelHandlerContext ctx, ByteBuf buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

