/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.sql.Blob;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.ssl.SslHandler;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ServiceInvocationStruct;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.PGUtil;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.PGCharsetConverter;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.pg.PGbytea;

public class PgBackendProtocol
implements ChannelDownstreamHandler,
ODBCClientRemote {
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String CLIENT_ENCODING = "client_encoding";
    private ChannelBuffer dataOut;
    private OutputStreamWriter writer;
    private Properties props;
    private Charset encoding = Charset.forName("UTF-8");
    private String clientEncoding = "UTF8";
    private ReflectionHelper clientProxy = new ReflectionHelper(ODBCClientRemote.class);
    private ChannelHandlerContext ctx;
    private MessageEvent message;
    private int maxLobSize = 0x200000;
    private final int maxBufferSize;
    private volatile ResultsFuture<Boolean> nextFuture;
    private SSLConfiguration config;

    public PgBackendProtocol(int maxLobSize, int maxBufferSize, SSLConfiguration config) {
        this.maxLobSize = maxLobSize;
        this.maxBufferSize = maxBufferSize;
        this.config = config;
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendDownstream(evt);
            return;
        }
        MessageEvent me = (MessageEvent)evt;
        if (!(me.getMessage() instanceof ServiceInvocationStruct)) {
            ctx.sendDownstream(evt);
            return;
        }
        this.ctx = ctx;
        this.message = me;
        ServiceInvocationStruct serviceStruct = (ServiceInvocationStruct)me.getMessage();
        try {
            Method m = this.clientProxy.findBestMethodOnTarget(serviceStruct.methodName, serviceStruct.args);
            try {
                m.invoke((Object)this, serviceStruct.args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (Throwable e) {
            this.terminate(e);
        }
    }

    @Override
    public void initialized(Properties props) {
        this.props = props;
        this.setEncoding(props.getProperty(CLIENT_ENCODING, this.clientEncoding), true);
    }

    @Override
    public void useClearTextAuthentication() {
        this.sendAuthenticationCleartextPassword();
    }

    @Override
    public void useAuthenticationGSS() {
        this.sendAuthenticationGSS();
    }

    @Override
    public void authenticationGSSContinue(byte[] serviceToken) {
        this.sendAuthenticationGSSContinue(serviceToken);
    }

    @Override
    public void authenticationSucess(int processId, int screctKey) {
        this.sendAuthenticationOk();
        this.sendParameterStatus(CLIENT_ENCODING, this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.props.getProperty("DateStyle", "ISO"));
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.1.4");
        this.sendParameterStatus("session_authorization", this.props.getProperty("user"));
        this.sendParameterStatus("standard_conforming_strings", "on");
        this.sendParameterStatus("application_name", this.props.getProperty("application_name", "ODBCClient"));
        this.sendParameterStatus("TimeZone", "CET");
        this.sendBackendKeyData(processId, screctKey);
    }

    @Override
    public void prepareCompleted(String preparedName) {
        this.sendParseComplete();
    }

    @Override
    public void bindComplete() {
        this.sendBindComplete();
    }

    @Override
    public void errorOccurred(String msg) {
        this.sendErrorResponse(msg);
    }

    @Override
    public void errorOccurred(Throwable t) {
        this.sendErrorResponse(t);
    }

    @Override
    public void ready(boolean inTransaction, boolean failedTransaction) {
        this.sendReadyForQuery(inTransaction, failedTransaction);
    }

    @Override
    public void setEncoding(String value, boolean init) {
        if (value == null || value.equals(this.clientEncoding)) {
            return;
        }
        this.clientEncoding = value;
        Charset cs = PGCharsetConverter.getCharset(value);
        if (cs != null) {
            this.encoding = cs;
            if (!init) {
                this.sendParameterStatus(CLIENT_ENCODING, value);
            }
        } else {
            LogManager.logWarning((String)"org.teiid.ODBC", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40105, new Object[]{value}));
        }
    }

    public String getClientEncoding() {
        return this.clientEncoding;
    }

    public Charset getEncoding() {
        return this.encoding;
    }

    @Override
    public void sendParameterDescription(ParameterMetaData meta, int[] paramType) {
        try {
            int count = meta.getParameterCount();
            this.startMessage('t');
            this.writeShort(count);
            for (int i = 0; i < count; ++i) {
                int type = paramType != null && paramType[i] != 0 ? paramType[i] : PgBackendProtocol.convertType(meta.getParameterType(i + 1));
                this.writeInt(type);
            }
            this.sendMessage();
        }
        catch (SQLException e) {
            this.sendErrorResponse(e);
        }
    }

    @Override
    public void sendResultSetDescription(List<PGUtil.PgColInfo> cols) {
        this.sendRowDescription(cols);
    }

    @Override
    public void sendCursorResults(ResultSetImpl rs, List<PGUtil.PgColInfo> cols, ResultsFuture<Integer> result, int rowCount) {
        this.sendRowDescription(cols);
        ResultsWorkItem r = new ResultsWorkItem(cols, rs, result, rowCount);
        r.run();
    }

    @Override
    public void sendPortalResults(String sql, ResultSetImpl rs, List<PGUtil.PgColInfo> cols, ResultsFuture<Integer> result, int rowCount, boolean portal) {
        ResultsWorkItem r = new ResultsWorkItem(cols, rs, result, rowCount);
        r.run();
    }

    @Override
    public void sendMoveCursor(ResultSetImpl rs, int rowCount, ResultsFuture<Integer> results) {
        try {
            int rowsMoved = 0;
            for (int i = 0; i < rowCount && rs.next(); ++i) {
                ++rowsMoved;
            }
            results.getResultsReceiver().receiveResults((Object)rowsMoved);
        }
        catch (SQLException e) {
            this.sendErrorResponse(e);
        }
    }

    @Override
    public void sendResults(String sql, ResultSetImpl rs, List<PGUtil.PgColInfo> cols, ResultsFuture<Integer> result, boolean describeRows) {
        if (this.nextFuture != null) {
            this.sendErrorResponse(new IllegalStateException("Pending results have not been sent"));
        }
        if (describeRows) {
            this.sendRowDescription(cols);
        }
        ResultsWorkItem r = new ResultsWorkItem(cols, rs, result, -1);
        r.sql = sql;
        r.run();
    }

    @Override
    public void sendUpdateCount(String sql, int updateCount) {
        this.sendCommandComplete(sql, updateCount);
    }

    @Override
    public void statementClosed() {
        this.startMessage('3');
        this.sendMessage();
    }

    @Override
    public void terminated() {
        PgBackendProtocol.trace("channel being terminated");
        this.ctx.getChannel().close();
    }

    @Override
    public void flush() {
        this.dataOut = null;
        this.writer = null;
        Channels.write((Channel)this.ctx.getChannel(), null);
    }

    @Override
    public void emptyQueryReceived() {
        this.sendEmptyQueryResponse();
    }

    private void terminate(Throwable t) {
        PgBackendProtocol.trace("channel being terminated - ", t.getMessage());
        this.ctx.getChannel().close();
    }

    private void sendEmptyQueryResponse() {
        this.startMessage('I');
        this.sendMessage();
    }

    @Override
    public void sendCommandComplete(String sql, Integer count) {
        String tag;
        this.startMessage('C');
        if (StringUtil.startsWithIgnoreCase((String)sql, (String)"BEGIN") || StringUtil.startsWithIgnoreCase((String)sql, (String)"START TRANSACTION")) {
            tag = "BEGIN";
        } else if (sql.indexOf(32) == -1) {
            tag = sql.toUpperCase();
            if (count != null) {
                tag = tag + " " + count;
            }
        } else if (StringUtil.startsWithIgnoreCase((String)sql, (String)"SET ")) {
            tag = "SET";
        } else {
            tag = SqlUtil.getKeyword((String)sql).toUpperCase();
            if (tag.equals("EXEC") || tag.equals("CALL")) {
                tag = "SELECT";
            }
            if (count != null) {
                tag = tag + " " + count;
            }
        }
        this.writeString(tag);
        this.sendMessage();
    }

    private void sendDataRow(ResultSet rs, List<PGUtil.PgColInfo> cols) throws SQLException, IOException {
        this.startMessage('D', -1);
        int lengthIndex = this.dataOut.writerIndex() - 4;
        this.writeShort(cols.size());
        for (int i = 0; i < cols.size(); ++i) {
            int dataBytesIndex = this.dataOut.writerIndex();
            this.writeInt(-1);
            this.getContent(rs, cols.get(i), i + 1);
            this.writer.flush();
            if (rs.wasNull()) continue;
            int bytes = this.dataOut.writerIndex() - dataBytesIndex - 4;
            this.dataOut.setInt(dataBytesIndex, bytes);
        }
        this.dataOut.setInt(lengthIndex, this.dataOut.writerIndex() - lengthIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContent(ResultSet rs, PGUtil.PgColInfo col, int column) throws SQLException, TeiidSQLException, IOException {
        switch (col.type) {
            case 16: 
            case 20: 
            case 21: 
            case 23: 
            case 700: 
            case 701: 
            case 1042: 
            case 1043: 
            case 1082: 
            case 1083: 
            case 1114: 
            case 1700: {
                String value = rs.getString(column);
                if (value == null) break;
                this.writer.write(value);
                break;
            }
            case 25: {
                Reader r = rs.getCharacterStream(column);
                if (r == null) break;
                try {
                    ObjectConverterUtil.write((Writer)this.writer, (Reader)r, (int)this.maxLobSize, (boolean)false);
                    break;
                }
                finally {
                    r.close();
                }
            }
            case 17: {
                Blob blob = rs.getBlob(column);
                if (blob == null) break;
                try {
                    String blobString = PGbytea.toPGString(ObjectConverterUtil.convertToByteArray((InputStream)blob.getBinaryStream(), (int)this.maxLobSize));
                    this.writer.write(blobString);
                    break;
                }
                catch (OutOfMemoryError e) {
                    throw new StreamCorruptedException("data too big: " + e.getMessage());
                }
            }
            case 1002: 
            case 1009: 
            case 1028: {
                ArrayImpl obj = (ArrayImpl)rs.getObject(column);
                if (obj == null) break;
                this.writer.append("{");
                boolean first = true;
                for (Object o : obj.getValues()) {
                    if (!first) {
                        this.writer.append(",");
                    } else {
                        first = false;
                    }
                    if (o == null) continue;
                    if (col.type == 1009) {
                        PgBackendProtocol.escapeQuote(this.writer, o.toString());
                        continue;
                    }
                    this.writer.append(o.toString());
                }
                this.writer.append("}");
                break;
            }
            case 22: 
            case 30: {
                ArrayImpl obj = (ArrayImpl)rs.getObject(column);
                if (obj == null) break;
                boolean first = true;
                for (Object o : obj.getValues()) {
                    if (!first) {
                        this.writer.append(" ");
                    } else {
                        first = false;
                    }
                    if (o == null) continue;
                    this.writer.append(o.toString());
                }
                break;
            }
            default: {
                throw new TeiidSQLException("unknown datatype failed to convert");
            }
        }
    }

    public static void escapeQuote(Writer sb, String s) throws IOException {
        sb.append('\"');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        sb.append('\"');
    }

    @Override
    public void sendSslResponse() {
        SSLEngine engine = null;
        try {
            engine = this.config.getServerSSLEngine();
        }
        catch (IOException e) {
            LogManager.logError((String)"org.teiid.ODBC", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40016, new Object[0]));
        }
        catch (GeneralSecurityException e) {
            LogManager.logError((String)"org.teiid.ODBC", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40016, new Object[0]));
        }
        ChannelBuffer buffer = this.ctx.getChannel().getConfig().getBufferFactory().getBuffer(1);
        if (engine == null) {
            buffer.writeByte(78);
        } else {
            this.message.getFuture().addListener((ChannelFutureListener)new SSLEnabler(engine));
            buffer.writeByte(83);
        }
        Channels.write((ChannelHandlerContext)this.ctx, (ChannelFuture)this.message.getFuture(), (Object)buffer, (SocketAddress)this.message.getRemoteAddress());
    }

    private void sendErrorResponse(Throwable t) {
        if (t instanceof SQLException) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODBC", (int)5)) {
                LogManager.logWarning((String)"org.teiid.ODBC", (Throwable)t, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40020, new Object[0]));
            }
        } else {
            LogManager.logError((String)"org.teiid.ODBC", (Throwable)t, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40015, new Object[0]));
        }
        TeiidSQLException e = TeiidSQLException.create((Throwable)t);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(e.getSQLState());
        this.write(77);
        this.writeString(e.getMessage());
        this.write(68);
        this.writeString(e.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendRowDescription(List<PGUtil.PgColInfo> cols) {
        if (cols == null) {
            this.startMessage('n');
            this.sendMessage();
            return;
        }
        this.startMessage('T');
        this.writeShort(cols.size());
        for (PGUtil.PgColInfo info : cols) {
            this.writeString(info.name);
            this.writeInt(info.reloid);
            this.writeShort(info.attnum);
            this.writeInt(info.type);
            this.writeShort(this.getTypeSize(info.type, info.precision));
            this.writeInt(info.mod);
            this.writeShort(0);
        }
        this.sendMessage();
    }

    private int getTypeSize(int pgType, int precision) {
        switch (pgType) {
            case 1043: {
                return Math.max(255, precision + 10);
            }
        }
        return precision + 4;
    }

    private void sendErrorResponse(String message) {
        LogManager.logWarning((String)"org.teiid.ODBC", (Object)message);
        this.startMessage('E');
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(message);
        this.sendMessage();
    }

    private void sendParseComplete() {
        this.startMessage('1');
        this.sendMessage();
    }

    private void sendBindComplete() {
        this.startMessage('2');
        this.sendMessage();
    }

    @Override
    public void sendPortalSuspended() {
        this.startMessage('s');
        this.sendMessage();
    }

    private void sendAuthenticationCleartextPassword() {
        this.startMessage('R');
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationGSS() {
        this.startMessage('R');
        this.writeInt(7);
        this.sendMessage();
    }

    private void sendAuthenticationGSSContinue(byte[] serviceToken) {
        this.startMessage('R');
        this.writeInt(8);
        this.write(serviceToken);
        this.sendMessage();
    }

    private void sendAuthenticationOk() {
        this.startMessage('R');
        this.writeInt(0);
        this.sendMessage();
    }

    private void sendReadyForQuery(boolean inTransaction, boolean failedTransaction) {
        this.startMessage('Z');
        int c = failedTransaction ? 69 : (inTransaction ? 84 : 73);
        this.write((byte)c);
        this.sendMessage();
    }

    private void sendBackendKeyData(int processId, int screctKey) {
        this.startMessage('K');
        this.writeInt(processId);
        this.writeInt(screctKey);
        this.sendMessage();
    }

    private void sendParameterStatus(String param, String value) {
        this.startMessage('S');
        this.writeString(param);
        this.writeString(value);
        this.sendMessage();
    }

    @Override
    public void functionCallResponse(byte[] data) {
        this.startMessage('V');
        if (data == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(data.length);
            this.write(data);
        }
        this.sendMessage();
    }

    @Override
    public void functionCallResponse(int data) {
        this.startMessage('V');
        this.writeInt(4);
        this.writeInt(data);
        this.sendMessage();
    }

    private void writeString(String s) {
        this.write(s.getBytes(this.encoding));
        this.write(0);
    }

    private void writeInt(int i) {
        this.dataOut.writeInt(i);
    }

    private void writeShort(int i) {
        this.dataOut.writeShort(i);
    }

    private void write(byte[] data) {
        this.dataOut.writeBytes(data);
    }

    private void write(int b) {
        this.dataOut.writeByte(b);
    }

    private void startMessage(char newMessageType) {
        this.startMessage(newMessageType, 32);
    }

    private void startMessage(char newMessageType, int estimatedLength) {
        if (estimatedLength > -1) {
            this.initBuffer(estimatedLength);
        }
        this.dataOut.writeByte((int)((byte)newMessageType));
        int nextByte = this.dataOut.writerIndex() + 4;
        this.dataOut.ensureWritableBytes(nextByte);
        this.dataOut.writerIndex(nextByte);
    }

    private void initBuffer(int estimatedLength) {
        this.dataOut = ChannelBuffers.dynamicBuffer((int)estimatedLength);
        ChannelBufferOutputStream cbos = new ChannelBufferOutputStream(this.dataOut);
        this.writer = new OutputStreamWriter((OutputStream)cbos, this.encoding);
    }

    private void sendMessage() {
        int pos = this.dataOut.writerIndex();
        this.dataOut.setInt(1, pos - 1);
        this.sendContents();
    }

    private void sendContents() {
        ChannelBuffer cb = this.dataOut;
        this.dataOut = null;
        this.writer = null;
        Channels.write((ChannelHandlerContext)this.ctx, (ChannelFuture)this.message.getFuture(), (Object)cb, (SocketAddress)this.message.getRemoteAddress());
    }

    private static void trace(String ... msg) {
        LogManager.logTrace((String)"org.teiid.ODBC", (Object[])msg);
    }

    private static int convertType(int type) {
        switch (type) {
            case -7: 
            case 16: {
                return 16;
            }
            case 12: {
                return 1043;
            }
            case 1: {
                return 1042;
            }
            case -6: 
            case 5: {
                return 21;
            }
            case 4: {
                return 23;
            }
            case -5: {
                return 20;
            }
            case 2: 
            case 3: {
                return 1700;
            }
            case 6: 
            case 7: {
                return 700;
            }
            case 8: {
                return 701;
            }
            case 92: {
                return 1083;
            }
            case 91: {
                return 1082;
            }
            case 93: {
                return 1114;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 17;
            }
            case -1: 
            case 2005: {
                return 25;
            }
            case 2009: {
                return 25;
            }
        }
        return 705;
    }

    private final class ResultsWorkItem
    implements Runnable {
        private final List<PGUtil.PgColInfo> cols;
        private final ResultSetImpl rs;
        private final ResultsFuture<Integer> result;
        private int rows2Send;
        private int rowsSent = 0;
        private int rowsInBuffer = 0;
        String sql;

        private ResultsWorkItem(List<PGUtil.PgColInfo> cols, ResultSetImpl rs, ResultsFuture<Integer> result, int rows2Send) {
            this.cols = cols;
            this.rs = rs;
            this.result = result;
            this.rows2Send = rows2Send;
            PgBackendProtocol.this.initBuffer(PgBackendProtocol.this.maxBufferSize / 8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    do {
                        PgBackendProtocol.this.nextFuture = this.rs.submitNext();
                        ResultsFuture resultsFuture = PgBackendProtocol.this.nextFuture;
                        synchronized (resultsFuture) {
                            if (!PgBackendProtocol.this.nextFuture.isDone()) {
                                PgBackendProtocol.this.nextFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                                    public void onCompletion(ResultsFuture<Boolean> future) {
                                        if (ResultsWorkItem.this.processRow((ResultsFuture<Boolean>)future) && ResultsWorkItem.this.rowsSent != ResultsWorkItem.this.rows2Send) {
                                            ResultsWorkItem.this.run();
                                        }
                                    }
                                });
                                return;
                            }
                        }
                    } while (this.processRow((ResultsFuture<Boolean>)PgBackendProtocol.this.nextFuture));
                }
                catch (Throwable t) {
                    this.result.getResultsReceiver().exceptionOccurred(t);
                    continue;
                }
                break;
            }
        }

        private boolean processRow(ResultsFuture<Boolean> future) {
            PgBackendProtocol.this.nextFuture = null;
            boolean processNext = true;
            try {
                if (((Boolean)future.get()).booleanValue()) {
                    PgBackendProtocol.this.sendDataRow((ResultSet)this.rs, this.cols);
                    ++this.rowsSent;
                    ++this.rowsInBuffer;
                    boolean done = this.rowsSent == this.rows2Send;
                    this.flushResults(done);
                    boolean bl = processNext = !done;
                    if (done) {
                        this.result.getResultsReceiver().receiveResults((Object)this.rowsSent);
                    }
                } else {
                    PgBackendProtocol.this.sendContents();
                    if (this.sql != null) {
                        PgBackendProtocol.this.sendCommandComplete(this.sql, this.rowsSent);
                    }
                    this.result.getResultsReceiver().receiveResults((Object)this.rowsSent);
                    processNext = false;
                }
            }
            catch (Throwable t) {
                this.result.getResultsReceiver().exceptionOccurred(t);
                return false;
            }
            return processNext;
        }

        private void flushResults(boolean force) {
            int avgRowsize = PgBackendProtocol.this.dataOut.writerIndex() / this.rowsInBuffer;
            if (force || PgBackendProtocol.this.maxBufferSize - PgBackendProtocol.this.dataOut.writerIndex() < avgRowsize * 2) {
                PgBackendProtocol.this.sendContents();
                PgBackendProtocol.this.initBuffer(PgBackendProtocol.this.maxBufferSize / 8);
                this.rowsInBuffer = 0;
            }
        }
    }

    private final class SSLEnabler
    implements ChannelFutureListener {
        private SSLEngine engine;

        public SSLEnabler(SSLEngine engine) {
            this.engine = engine;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                SslHandler handler = new SslHandler(this.engine);
                future.getChannel().getPipeline().addFirst("sslHandler", (ChannelHandler)handler);
                handler.handshake();
            }
        }
    }
}

