/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamException;
import org.jboss.vfs.VirtualFile;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.deployers.CompositeGlobalTableStore;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidPreparedStatement;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.PureZipFileSystem;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.AbstractVDBDeployer;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedConnection;
import org.teiid.runtime.EmbeddedRequestOptions;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.services.AbstractEventDistributorFactoryService;
import org.teiid.services.BufferServiceImpl;
import org.teiid.services.SessionServiceImpl;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;
import org.teiid.vdb.runtime.VDBKey;
import org.xml.sax.SAXException;

public class EmbeddedServer
extends AbstractVDBDeployer
implements EventDistributorFactory,
ConnectorManagerRepository.ExecutionFactoryProvider {
    protected DQPCore dqp = new DQPCore();
    protected VDBRepository repo = new VDBRepository(){

        @Override
        protected boolean processMetadataValidatorReport(VDBKey key, ValidatorReport report) {
            if (EmbeddedServer.this.throwMetadataErrors) {
                super.processMetadataValidatorReport(key, report);
                ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
                throw new VDBValidationError(RuntimePlugin.Event.TEIID40095, firstFailure.getMessage());
            }
            return true;
        }
    };
    protected boolean throwMetadataErrors = true;
    private ConcurrentHashMap<String, ExecutionFactory<?, ?>> translators = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConnectionFactoryProvider<?>> connectionFactoryProviders = new ConcurrentHashMap();
    protected SessionServiceImpl sessionService = new SessionServiceImpl();
    protected ObjectReplicator replicator;
    protected BufferServiceImpl bufferService = new BufferServiceImpl();
    protected TransactionServerImpl transactionService = new TransactionServerImpl();
    protected boolean waitForLoad;
    protected ClientServiceRegistryImpl services = new ClientServiceRegistryImpl(){

        @Override
        public void waitForFinished(String vdbName, int vdbVersion, int timeOutMillis) throws ConnectionException {
            if (EmbeddedServer.this.waitForLoad) {
                EmbeddedServer.this.repo.waitForFinished(vdbName, vdbVersion, timeOutMillis);
            }
        }

        @Override
        public ClassLoader getCallerClassloader() {
            return this.getClass().getClassLoader();
        }
    };
    protected LogonImpl logon;
    private TeiidDriver driver = new TeiidDriver();
    protected ConnectorManagerRepository cmr = new ProviderAwareConnectorManagerRepository();
    protected AbstractEventDistributorFactoryService eventDistributorFactoryService = new AbstractEventDistributorFactoryService(){

        @Override
        protected VDBRepository getVdbRepository() {
            return EmbeddedServer.this.repo;
        }

        @Override
        protected ObjectReplicator getObjectReplicator() {
            return EmbeddedServer.this.replicator;
        }
    };
    protected boolean useCallingThread = true;
    private Boolean running;
    private EmbeddedConfiguration config;
    private SessionAwareCache<CachedResults> rs;
    private SessionAwareCache<PreparedPlan> ppc;

    public void addConnectionFactoryProvider(String name, ConnectionFactoryProvider<?> connectionFactoryProvider) {
        this.connectionFactoryProviders.put(name, connectionFactoryProvider);
    }

    public void addConnectionFactory(String name, Object connectionFactory) {
        this.connectionFactoryProviders.put(name, new SimpleConnectionFactoryProvider<Object>(connectionFactory));
    }

    public synchronized void start(EmbeddedConfiguration config) {
        if (this.running != null) {
            throw new IllegalStateException();
        }
        this.config = config;
        this.eventDistributorFactoryService.start();
        this.dqp.setEventDistributor(this.eventDistributorFactoryService.getReplicatedEventDistributor());
        this.replicator = config.getObjectReplicator();
        if (config.getTransactionManager() == null) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
            this.transactionService.setTransactionManager((TransactionManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{TransactionManager.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new UnsupportedOperationException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
                }
            }));
        } else {
            this.transactionService.setDetectTransactions(true);
            this.transactionService.setTransactionManager(config.getTransactionManager());
        }
        if (config.getSecurityHelper() != null) {
            this.sessionService.setSecurityHelper(config.getSecurityHelper());
        } else {
            this.sessionService.setSecurityHelper(new DoNothingSecurityHelper());
        }
        if (config.getSecurityDomains() != null) {
            this.sessionService.setSecurityDomains(config.getSecurityDomains());
        } else {
            this.sessionService.setSecurityDomains(Arrays.asList("teiid-security"));
        }
        this.sessionService.setVDBRepository(this.repo);
        this.bufferService.setUseDisk(config.isUseDisk());
        if (config.isUseDisk()) {
            if (config.getBufferDirectory() == null) {
                config.setBufferDirectory(System.getProperty("java.io.tmpdir"));
            }
            this.bufferService.setDiskDirectory(config.getBufferDirectory());
        }
        BufferService bs = this.getBufferService();
        this.dqp.setBufferManager(bs.getBufferManager());
        this.startVDBRepository();
        this.rs = new SessionAwareCache("resultset", config.getCacheFactory(), SessionAwareCache.Type.RESULTSET, config.getMaxResultSetCacheStaleness());
        this.ppc = new SessionAwareCache("preparedplan", config.getCacheFactory(), SessionAwareCache.Type.PREPAREDPLAN, 0);
        this.rs.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setResultsetCache(this.rs);
        this.ppc.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setPreparedPlanCache(this.ppc);
        this.dqp.setTransactionService((TransactionService)this.transactionService);
        this.dqp.start((DQPConfiguration)config);
        this.sessionService.setDqp(this.dqp);
        this.services.setSecurityHelper(this.sessionService.getSecurityHelper());
        this.logon = new LogonImpl(this.sessionService, null);
        this.services.registerClientService(ILogon.class, this.logon, "org.teiid.SECURITY");
        this.services.registerClientService(DQP.class, this.dqp, "org.teiid.PROCESSOR");
        this.initDriver();
        this.running = true;
    }

    private void initDriver() {
        this.driver.setEmbeddedProfile(new ConnectionProfile(){

            public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
                LocalServerConnection conn;
                try {
                    conn = new LocalServerConnection(info, EmbeddedServer.this.useCallingThread){

                        @Override
                        protected ClientServiceRegistry getClientServiceRegistry(String name) {
                            return EmbeddedServer.this.services;
                        }
                    };
                }
                catch (CommunicationException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
                catch (ConnectionException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
                return new EmbeddedConnectionImpl(conn, info, url);
            }
        });
    }

    private void startVDBRepository() {
        this.repo.addListener(new VDBLifeCycleListener(){

            @Override
            public void added(String name, int version, CompositeVDB vdb) {
            }

            @Override
            public void removed(String name, int version, CompositeVDB vdb) {
                if (EmbeddedServer.this.replicator != null) {
                    EmbeddedServer.this.replicator.stop(vdb.getVDB().getAttachment(GlobalTableStore.class));
                }
                EmbeddedServer.this.rs.clearForVDB(name, 1);
                EmbeddedServer.this.ppc.clearForVDB(name, 1);
            }

            @Override
            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
                if (!vdb.getVDB().getStatus().equals((Object)VDB.Status.ACTIVE)) {
                    return;
                }
                GlobalTableStore gts = CompositeGlobalTableStore.createInstance(vdb, EmbeddedServer.this.dqp.getBufferManager(), EmbeddedServer.this.replicator);
                vdb.getVDB().addAttchment(GlobalTableStore.class, (Object)gts);
            }
        });
        this.repo.setSystemFunctionManager(new SystemFunctionManager());
        this.repo.start();
    }

    protected BufferService getBufferService() {
        this.bufferService.start();
        if (this.replicator != null) {
            try {
                final TupleBufferCache tbc = (TupleBufferCache)this.replicator.replicate("$BM$", TupleBufferCache.class, (Object)this.bufferService.getBufferManager(), 0L);
                return new BufferService(){

                    public BufferManager getBufferManager() {
                        return EmbeddedServer.this.bufferService.getBufferManager();
                    }

                    public TupleBufferCache getTupleBufferCache() {
                        return tbc;
                    }
                };
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return this.bufferService;
    }

    public void addTranslator(Class<? extends ExecutionFactory> clazz) throws TranslatorException {
        Translator t = clazz.getAnnotation(Translator.class);
        String name = clazz.getName();
        if (t != null) {
            name = t.name();
        }
        try {
            ExecutionFactory instance = clazz.newInstance();
            instance.start();
            this.addTranslator(name, instance);
        }
        catch (InstantiationException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    public void addTranslator(ExecutionFactory<?, ?> ef) {
        Translator t = ef.getClass().getAnnotation(Translator.class);
        String name = ef.getClass().getName();
        if (t != null) {
            name = t.name();
        }
        this.addTranslator(name, ef);
    }

    public void addTranslator(String name, ExecutionFactory<?, ?> ef) {
        this.translators.put(name, ef);
    }

    public void deployVDB(String name, ModelMetaData ... models) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setXmlDeployment(true);
        vdb.setName(name);
        vdb.setModels(Arrays.asList(models));
        this.deployVDB(vdb, null);
    }

    public void deployVDB(InputStream is) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException {
        VDBMetaData metadata;
        byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
        try {
            VDBMetadataParser.validate((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (SAXException e) {
            throw new VirtualDatabaseException(e);
        }
        try {
            metadata = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (XMLStreamException e) {
            throw new VirtualDatabaseException(e);
        }
        this.deployVDB(metadata, null);
    }

    public void deployVDBZip(URL url) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException {
        VDBMetaData metadata;
        VirtualFile root = PureZipFileSystem.mount((URL)url);
        VirtualFile vdbMetadata = root.getChild("/META-INF/vdb.xml");
        try {
            VDBMetadataParser.validate((InputStream)vdbMetadata.openStream());
        }
        catch (SAXException e) {
            throw new VirtualDatabaseException(e);
        }
        InputStream is = vdbMetadata.openStream();
        try {
            metadata = VDBMetadataParser.unmarshell((InputStream)is);
        }
        catch (XMLStreamException e) {
            throw new VirtualDatabaseException(e);
        }
        VDBResources resources = new VDBResources(root, metadata);
        this.deployVDB(metadata, resources);
    }

    protected void deployVDB(VDBMetaData vdb, VDBResources resources) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        this.checkStarted();
        if (!vdb.getOverrideTranslators().isEmpty()) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40106, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40106, new Object[]{vdb.getName()}));
        }
        this.cmr.createConnectorManagers(vdb, (ConnectorManagerRepository.ExecutionFactoryProvider)this);
        MetadataStore metadataStore = new MetadataStore();
        UDFMetaData udfMetaData = new UDFMetaData();
        udfMetaData.setFunctionClassLoader(Thread.currentThread().getContextClassLoader());
        this.assignMetadataRepositories(vdb, null);
        this.repo.addVDB(vdb, metadataStore, new LinkedHashMap<String, VDBResources.Resource>(), udfMetaData, this.cmr);
        try {
            this.loadMetadata(vdb, this.cmr, metadataStore, resources);
        }
        catch (VDBValidationError e) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.valueOf(e.getCode()), e.getMessage());
        }
    }

    @Override
    protected void loadMetadata(VDBMetaData vdb, ModelMetaData model, ConnectorManagerRepository cmr, MetadataRepository metadataRepository, MetadataStore store, AtomicInteger loadCount, VDBResources vdbResources) throws TranslatorException {
        MetadataFactory factory = this.createMetadataFactory(vdb, model, vdbResources == null ? Collections.EMPTY_MAP : vdbResources.getEntriesPlusVisibilities());
        ExecutionFactory ef = null;
        Object cf = null;
        TranslatorException te = null;
        for (ConnectorManager cm : this.getConnectorManagers(model, cmr)) {
            if (te != null) {
                LogManager.logDetail((String)"org.teiid.RUNTIME", te, (Object[])new Object[]{"Failed to get metadata, trying next source."});
                te = null;
            }
            try {
                if (cm != null) {
                    ef = cm.getExecutionFactory();
                    cf = cm.getConnectionFactory();
                }
            }
            catch (TranslatorException e) {
                LogManager.logDetail((String)"org.teiid.RUNTIME", (Throwable)e, (Object[])new Object[]{"Failed to get a connection factory for metadata load."});
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"CREATE SCHEMA", factory.getSchema().getName(), ";\n", DDLStringVisitor.getDDLString((Schema)factory.getSchema(), null, null)});
            }
            try {
                metadataRepository.loadMetadata(factory, ef, cf);
                break;
            }
            catch (TranslatorException e) {
                te = e;
            }
        }
        if (te != null) {
            throw te;
        }
        this.metadataLoaded(vdb, model, store, loadCount, factory, true);
    }

    public void undeployVDB(String vdbName) {
        this.checkStarted();
        this.repo.removeVDB(vdbName, 1);
    }

    public synchronized void stop() {
        if (this.config != null) {
            this.config.stop();
        }
        if (this.running == null || !this.running.booleanValue()) {
            return;
        }
        this.dqp.stop();
        this.eventDistributorFactoryService.stop();
        this.config.getCacheFactory().destroy();
        this.config.setCacheFactory(null);
        this.bufferService = null;
        this.dqp = null;
        this.running = false;
    }

    private synchronized void checkStarted() {
        if (this.running == null || !this.running.booleanValue()) {
            throw new IllegalStateException();
        }
    }

    public TeiidDriver getDriver() {
        this.checkStarted();
        return this.driver;
    }

    public EventDistributor getEventDistributor() {
        return this.eventDistributorFactoryService.getEventDistributor();
    }

    public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
        ExecutionFactory<?, ?> ef = this.translators.get(name);
        if (ef == null) {
            throw new ConnectorManagerRepository.ConnectorManagerException(name);
        }
        return ef;
    }

    @Override
    protected VDBRepository getVDBRepository() {
        return this.repo;
    }

    public String getSchemaDdl(String vdbName, String schemaName) {
        VDBMetaData vdb = this.repo.getVDB(vdbName, 1);
        if (vdb == null) {
            return null;
        }
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return null;
        }
        Schema schema = metadata.getMetadataStore().getSchema(schemaName);
        if (schema == null) {
            return null;
        }
        return DDLStringVisitor.getDDLString((Schema)schema, null, null);
    }

    private static class VDBValidationError
    extends TeiidRuntimeException {
        private VDBValidationError(BundleUtil.Event event, String message) {
            super(event, message);
        }
    }

    public static class SimpleConnectionFactoryProvider<T>
    implements ConnectionFactoryProvider<T> {
        private T connectionFactory;

        public SimpleConnectionFactoryProvider(T connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public T getConnectionFactory() throws TranslatorException {
            return this.connectionFactory;
        }
    }

    public static interface ConnectionFactoryProvider<T> {
        public T getConnectionFactory() throws TranslatorException;
    }

    protected class ProviderAwareConnectorManagerRepository
    extends ConnectorManagerRepository {
        public ProviderAwareConnectorManagerRepository() {
            super(true);
        }

        protected ConnectorManager createConnectorManager(String translatorName, String connectionName) {
            return new ConnectorManager(translatorName, connectionName){

                public Object getConnectionFactory() throws TranslatorException {
                    if (this.getConnectionName() == null) {
                        return null;
                    }
                    ConnectionFactoryProvider connectionFactoryProvider = (ConnectionFactoryProvider)EmbeddedServer.this.connectionFactoryProviders.get(this.getConnectionName());
                    if (connectionFactoryProvider != null) {
                        return connectionFactoryProvider.getConnectionFactory();
                    }
                    return super.getConnectionFactory();
                }
            };
        }
    }

    private final class EmbeddedConnectionImpl
    extends ConnectionImpl
    implements EmbeddedConnection {
        public EmbeddedConnectionImpl(ServerConnection serverConn, Properties info, String url) {
            super(serverConn, info, url);
        }

        @Override
        public CallableStatement prepareCall(Command command, EmbeddedRequestOptions options) throws SQLException {
            CallableStatementImpl csi = this.prepareCall(command.toString(), options.getResultSetType(), 1007);
            csi.setCommand((Object)command);
            return csi;
        }

        @Override
        public TeiidPreparedStatement prepareStatement(Command command, EmbeddedRequestOptions options) throws SQLException {
            PreparedStatementImpl psi = this.prepareStatement(command.toString(), options.getResultSetType(), 1007);
            psi.setCommand((Object)command);
            return psi;
        }
    }
}

