/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private int maxBufferSize = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.ODBCPacketSize", (int)307200);
    private boolean requireSecure = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.ODBCRequireSecure", (boolean)true);
    private int maxLobSize;
    private TeiidDriver driver;
    private LogonImpl logonService;

    public ODBCSocketListener(InetSocketAddress address, SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager, int maxLobSize, LogonImpl logon, TeiidDriver driver) {
        super(address, config, csr, storageManager);
        this.maxLobSize = maxLobSize;
        this.driver = driver;
        this.logonService = logon;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected SSLAwareChannelHandler createChannelPipelineFactory(final SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                PgBackendProtocol pgBackendProtocol = new PgBackendProtocol(ODBCSocketListener.this.maxLobSize, ODBCSocketListener.this.maxBufferSize, config, ODBCSocketListener.this.requireSecure);
                pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(pgBackendProtocol, 0x100000));
                pipeline.addLast("odbcBackendProtocol", (ChannelHandler)pgBackendProtocol);
                pipeline.addLast("handler", (ChannelHandler)this);
                return pipeline;
            }
        };
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.driver, this.logonService);
    }

    public void setRequireSecure(boolean requireSecure) {
        this.requireSecure = requireSecure;
    }
}

