/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.SessionToken;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.AuditMessage;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.vdb.runtime.VDBKey;

public class SessionServiceImpl
implements SessionService {
    public static final String GSS_PATTERN_PROPERTY = "gss-pattern";
    public static final String PASSWORD_PATTERN_PROPERTY = "password-pattern";
    public static final String SECURITY_DOMAIN_PROPERTY = "security-domain";
    public static final String AUTHENTICATION_TYPE_PROPERTY = "authentication-type";
    public static final String AT = "@";
    private long sessionMaxLimit = 10000L;
    private long sessionExpirationTimeLimit = 0L;
    private AuthenticationType defaultAuthenticationType = AuthenticationType.USERPASSWORD;
    private static boolean CHECK_PING = PropertiesUtils.getBooleanProperty((Properties)System.getProperties(), (String)"org.teiid.checkPing", (boolean)true);
    private VDBRepository vdbRepository;
    protected SecurityHelper securityHelper;
    private DQPCore dqp;
    private Map<String, SessionMetadata> sessionCache = new ConcurrentHashMap<String, SessionMetadata>();
    private Timer sessionMonitor = null;
    private List<String> securityDomainNames;
    private boolean trustAllLocal = true;

    public void setSecurityDomain(String domainName) {
        this.securityDomainNames = domainName == null ? null : Arrays.asList(domainName.split(","));
    }

    private void monitorSessions() {
        long currentTime = System.currentTimeMillis();
        for (SessionMetadata info : this.sessionCache.values()) {
            try {
                if (CHECK_PING && !info.isEmbedded() && currentTime - info.getLastPingTime() > 600000L) {
                    LogManager.logInfo((String)"org.teiid.SECURITY", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40007, new Object[]{info.getSessionId()}));
                    this.closeSession(info.getSessionId());
                    continue;
                }
                if (this.sessionExpirationTimeLimit <= 0L || currentTime - info.getCreatedTime() <= this.sessionExpirationTimeLimit) continue;
                LogManager.logInfo((String)"org.teiid.SECURITY", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40008, new Object[]{info.getSessionId()}));
                this.closeSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Object)e, (Object)"error running session monitor, unable to monitor:", (Object)info.getSessionId());
            }
        }
    }

    public void closeSession(String sessionID) throws InvalidSessionException {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.SECURITY", (int)5)) {
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"closeSession", sessionID});
        }
        SessionMetadata info = this.getSessionInfo(sessionID, true);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)new AuditMessage("session", "logoff", (Session)info));
        }
        if (info.getVDBName() != null) {
            try {
                this.dqp.terminateSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40018, new Object[0]));
            }
        }
        info.setSecurityContext(null);
        info.setClosed();
        info.getSessionVariables().clear();
    }

    public SessionMetadata createSession(String vdbName, String vdbVersion, AuthenticationType authType, String userName, Credentials credentials, String applicationName, Properties properties) throws LoginException, SessionServiceException {
        ArgCheck.isNotNull((Object)applicationName);
        ArgCheck.isNotNull((Object)properties);
        Object securityContext = null;
        Subject subject = null;
        String hostName = properties.getProperty("clientHostName");
        String ipAddress = properties.getProperty("clientIpAddress");
        String clientMac = properties.getProperty("clientMAC");
        boolean onlyAllowPassthrough = Boolean.valueOf(properties.getProperty("PassthroughAuthentication", "false"));
        AuditMessage.LogonInfo info = new AuditMessage.LogonInfo(vdbName, vdbVersion, authType.toString(), userName, applicationName, hostName, ipAddress, clientMac, onlyAllowPassthrough);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)new AuditMessage("session", "logon-request", info, null));
        }
        try {
            VDBMetaData vdb = null;
            if (vdbName != null) {
                vdb = this.getActiveVDB(vdbName, vdbVersion);
            }
            if (this.sessionMaxLimit > 0L && (long)this.getActiveSessionsCount() >= this.sessionMaxLimit) {
                throw new SessionServiceException((BundleUtil.Event)RuntimePlugin.Event.TEIID40043, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40043, new Object[]{new Long(this.sessionMaxLimit)}));
            }
            String securityDomain = this.getSecurityDomain(userName, vdbName, vdbVersion, (VDB)vdb);
            if (securityDomain != null) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"authenticateUser", userName, applicationName});
                String baseUserName = SessionServiceImpl.getBaseUsername(userName);
                if (onlyAllowPassthrough || authType.equals((Object)AuthenticationType.GSS)) {
                    subject = this.securityHelper.getSubjectInContext(securityDomain);
                    if (subject == null) {
                        if (!(onlyAllowPassthrough && this.trustAllLocal && DQPWorkContext.getWorkContext().isLocal())) {
                            throw new LoginException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40087, new Object[0]));
                        }
                    } else {
                        userName = SessionServiceImpl.escapeName(this.getUserName(subject, baseUserName)) + AT + securityDomain;
                    }
                    securityContext = this.securityHelper.getSecurityContext();
                } else {
                    userName = SessionServiceImpl.escapeName(baseUserName) + AT + securityDomain;
                    securityContext = this.securityHelper.authenticate(securityDomain, baseUserName, credentials, applicationName);
                    subject = this.securityHelper.getSubjectInContext(securityContext);
                }
            } else {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40117, new Object[0]));
            }
            long creationTime = System.currentTimeMillis();
            SessionMetadata newSession = new SessionMetadata();
            newSession.setSessionToken(new SessionToken(userName));
            newSession.setSessionId(newSession.getSessionToken().getSessionID());
            newSession.setUserName(userName);
            newSession.setCreatedTime(creationTime);
            newSession.setApplicationName(applicationName);
            newSession.setClientHostName(hostName);
            newSession.setIPAddress(ipAddress);
            newSession.setClientHardwareAddress(clientMac);
            newSession.setSecurityDomain(securityDomain);
            if (vdb != null) {
                newSession.setVDBName(vdb.getName());
                newSession.setVDBVersion((Object)vdb.getVersion());
            }
            newSession.setSubject(subject);
            newSession.setSecurityContext(securityContext);
            newSession.setVdb(vdb);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.SECURITY", (int)5)) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful, created", newSession});
            }
            this.sessionCache.put(newSession.getSessionId(), newSession);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)new AuditMessage("session", "logon-success", (Session)newSession));
            }
            return newSession;
        }
        catch (LoginException e) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)new AuditMessage("session", "logon-fail", info, (Exception)e));
            }
            throw e;
        }
        catch (SessionServiceException e) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object)new AuditMessage("session", "logon-fail", info, (Exception)((Object)e)));
            }
            throw e;
        }
    }

    protected VDBMetaData getActiveVDB(String vdbName, String vdbVersion) throws SessionServiceException {
        VDBMetaData vdb = null;
        try {
            if (vdbVersion == null) {
                vdbVersion = "latest";
                vdb = this.vdbRepository.getLiveVDB(vdbName);
            } else {
                vdb = this.vdbRepository.getLiveVDB(vdbName, vdbVersion);
            }
        }
        catch (NumberFormatException e) {
            throw new SessionServiceException((BundleUtil.Event)RuntimePlugin.Event.TEIID40045, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40045, new Object[]{vdbVersion}));
        }
        if (vdb == null) {
            throw new SessionServiceException((BundleUtil.Event)RuntimePlugin.Event.TEIID40046, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40046, new Object[]{vdbName, vdbVersion}));
        }
        if (vdb.getConnectionType() == VDB.ConnectionType.NONE) {
            throw new SessionServiceException((BundleUtil.Event)RuntimePlugin.Event.TEIID40048, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40048, new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    public Collection<SessionMetadata> getActiveSessions() {
        return new ArrayList<SessionMetadata>(this.sessionCache.values());
    }

    public SessionMetadata getActiveSession(String sessionID) {
        return this.sessionCache.get(sessionID);
    }

    public int getActiveSessionsCount() throws SessionServiceException {
        return this.sessionCache.size();
    }

    public Collection<SessionMetadata> getSessionsLoggedInToVDB(VDBKey key) {
        ArrayList<SessionMetadata> results = new ArrayList<SessionMetadata>();
        for (SessionMetadata info : this.sessionCache.values()) {
            if (info.getVdb() == null || !key.equals(info.getVdb().getAttachment(VDBKey.class))) continue;
            results.add(info);
        }
        return results;
    }

    public void pingServer(String sessionID) throws InvalidSessionException {
        SessionMetadata info = this.getSessionInfo(sessionID, false);
        info.setLastPingTime(System.currentTimeMillis());
        this.sessionCache.put(sessionID, info);
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object)"Keep-alive ping received for session:", (Object)sessionID);
    }

    public boolean terminateSession(String terminatedSessionID, String adminSessionID) {
        Object[] params = new Object[]{adminSessionID, terminatedSessionID};
        LogManager.logInfo((String)"org.teiid.SECURITY", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40009, params));
        try {
            this.closeSession(terminatedSessionID);
            return true;
        }
        catch (InvalidSessionException e) {
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object)((Object)e), (Object)e.getMessage());
            return false;
        }
    }

    public SessionMetadata validateSession(String sessionID) throws InvalidSessionException, SessionServiceException {
        SessionMetadata info = this.getSessionInfo(sessionID, false);
        return info;
    }

    private SessionMetadata getSessionInfo(String sessionID, boolean remove) throws InvalidSessionException {
        SessionMetadata info;
        if (sessionID == null) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40041, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40041, new Object[0]));
        }
        SessionMetadata sessionMetadata = info = remove ? this.sessionCache.remove(sessionID) : this.sessionCache.get(sessionID);
        if (info == null) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40042, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40042, new Object[]{sessionID}));
        }
        return info;
    }

    public long getSessionMaxLimit() {
        return this.sessionMaxLimit;
    }

    public void setSessionMaxLimit(long limit) {
        this.sessionMaxLimit = limit;
    }

    public long getSessionExpirationTimeLimit() {
        return this.sessionExpirationTimeLimit;
    }

    public void setSessionExpirationTimeLimit(long limit) {
        this.sessionExpirationTimeLimit = limit;
    }

    public void setAuthenticationType(AuthenticationType flag) {
        this.defaultAuthenticationType = flag;
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Default security domain configured=", this.securityDomainNames});
        this.sessionMonitor = new Timer("SessionMonitor", true);
        this.sessionMonitor.schedule(new TimerTask(){

            @Override
            public void run() {
                SessionServiceImpl.this.monitorSessions();
            }
        }, 360000L, 240000L);
    }

    public void stop() {
        if (this.sessionMonitor != null) {
            this.sessionMonitor.cancel();
        }
        this.sessionCache.clear();
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public void setDqp(DQPCore dqp) {
        this.dqp = dqp;
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    static String getBaseUsername(String username) {
        if (username == null) {
            return username;
        }
        int index = SessionServiceImpl.getQualifierIndex(username);
        String result = username;
        if (index != -1) {
            result = username.substring(0, index);
        }
        return result.replaceAll("\\\\@", AT);
    }

    static String escapeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll(AT, "\\\\@");
    }

    static String getDomainName(String username) {
        if (username == null) {
            return username;
        }
        int index = SessionServiceImpl.getQualifierIndex(username);
        if (index != -1) {
            return username.substring(index + 1);
        }
        return null;
    }

    static int getQualifierIndex(String username) {
        block1: {
            int index = username.length();
            do {
                --index;
                if ((index = username.lastIndexOf(AT, index)) == -1) break block1;
            } while (index <= 0 || username.charAt(index - 1) == '\\');
            return index;
        }
        return -1;
    }

    public AuthenticationType getAuthenticationType(String vdbName, String version, String userName) throws LogonException {
        if (userName == null) {
            userName = "anonymous";
        }
        if (vdbName != null) {
            VDBMetaData vdb;
            try {
                vdb = this.getActiveVDB(vdbName, version);
            }
            catch (SessionServiceException e) {
                throw new LogonException((Throwable)e);
            }
            String gssPattern = vdb.getPropertyValue(GSS_PATTERN_PROPERTY);
            if (gssPattern != null && Pattern.matches(gssPattern, userName)) {
                return AuthenticationType.GSS;
            }
            String passwordPattern = vdb.getPropertyValue(PASSWORD_PATTERN_PROPERTY);
            if (passwordPattern != null && Pattern.matches(passwordPattern, userName)) {
                return AuthenticationType.USERPASSWORD;
            }
            String typeProperty = vdb.getPropertyValue(AUTHENTICATION_TYPE_PROPERTY);
            if (typeProperty != null) {
                return AuthenticationType.valueOf((String)typeProperty);
            }
        }
        return this.defaultAuthenticationType;
    }

    public String getSecurityDomain(String userName, String vdbName, String version, VDB vdb) throws LoginException {
        String securityDomain = SessionServiceImpl.getDomainName(userName);
        if (vdbName != null) {
            try {
                String typeProperty;
                if (vdb == null) {
                    vdb = this.getActiveVDB(vdbName, version);
                }
                if ((typeProperty = vdb.getPropertyValue(SECURITY_DOMAIN_PROPERTY)) != null) {
                    if (securityDomain != null && !typeProperty.equals(securityDomain)) {
                        throw new LoginException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40116, new Object[0]));
                    }
                    return typeProperty;
                }
            }
            catch (SessionServiceException sessionServiceException) {
                // empty catch block
            }
        }
        if (securityDomain != null) {
            if (this.securityDomainNames != null && this.securityDomainNames.contains(securityDomain)) {
                return securityDomain;
            }
            throw new LoginException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40116, new Object[0]));
        }
        if (this.securityDomainNames != null && !this.securityDomainNames.isEmpty()) {
            return this.securityDomainNames.get(0);
        }
        return null;
    }

    public GSSResult neogitiateGssLogin(String user, String vdbName, String vdbVersion, byte[] serviceTicket) throws LoginException, LogonException {
        String securityDomain = this.getSecurityDomain(user, vdbName, vdbVersion, null);
        if (securityDomain == null) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40059, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40059, new Object[0]));
        }
        return this.securityHelper.negotiateGssLogin(securityDomain, serviceTicket);
    }

    public AuthenticationType getDefaultAuthenticationType() {
        return this.defaultAuthenticationType;
    }

    private String getUserName(Subject subject, String userName) {
        Set<Principal> principals = subject.getPrincipals();
        for (Principal p : principals) {
            if (p instanceof Group) continue;
            return p.getName();
        }
        return userName;
    }

    public boolean isTrustAllLocal() {
        return this.trustAllLocal;
    }

    public void setTrustAllLocal(boolean trustAllLocal) {
        this.trustAllLocal = trustAllLocal;
    }
}

