/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.teiid.Replicated;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.EventDistributorImpl;
import org.teiid.deployers.VDBRepository;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.query.ObjectReplicator;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.services.InternalEventDistributorFactory;

public abstract class AbstractEventDistributorFactoryService
implements InternalEventDistributorFactory {
    private EventDistributor replicatableEventDistributor;
    private EventDistributor eventDistributorProxy;

    public InternalEventDistributorFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    protected abstract VDBRepository getVdbRepository();

    protected abstract ObjectReplicator getObjectReplicator();

    public void start() {
        final EventDistributorImpl ed = new EventDistributorImpl(){

            @Override
            public VDBRepository getVdbRepository() {
                return AbstractEventDistributorFactoryService.this.getVdbRepository();
            }
        };
        ObjectReplicator objectReplicator = this.getObjectReplicator();
        if (objectReplicator != null) {
            try {
                this.replicatableEventDistributor = (EventDistributor)objectReplicator.replicate("$TEIID_ED$", EventDistributor.class, (Object)ed, 0L);
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40088, new Object[]{this}));
            }
        }
        this.eventDistributorProxy = (EventDistributor)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{EventDistributor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Replicated annotation = method.getAnnotation(Replicated.class);
                if (AbstractEventDistributorFactoryService.this.replicatableEventDistributor == null || annotation != null && annotation.remoteOnly()) {
                    method.invoke((Object)ed, args);
                }
                if (AbstractEventDistributorFactoryService.this.replicatableEventDistributor != null) {
                    method.invoke((Object)AbstractEventDistributorFactoryService.this.replicatableEventDistributor, args);
                }
                return null;
            }
        });
    }

    public void stop() {
        ObjectReplicator objectReplicator = this.getObjectReplicator();
        if (objectReplicator != null && this.replicatableEventDistributor != null) {
            objectReplicator.stop((Object)this.replicatableEventDistributor);
            this.replicatableEventDistributor = null;
        }
    }

    @Override
    public EventDistributor getReplicatedEventDistributor() {
        return this.replicatableEventDistributor;
    }

    public EventDistributor getEventDistributor() {
        return this.eventDistributorProxy;
    }
}

