/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.JBossLogger;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConvertVDB {
    public static void main(String[] args) throws Exception {
        File f;
        if (args.length < 1) {
            System.out.println("usage: CovertVDB /path/to/file.vdb");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("vdb file does not exist");
        }
        if (f.getName().toLowerCase().endsWith(".vdb") || f.getName().toLowerCase().endsWith(".xml")) {
            System.out.println(ConvertVDB.convert(f));
        } else {
            System.out.println("Unknown file type supplied, only .VDB, .XML based VDBs are supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(File f) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException, MalformedURLException, AdminException, Exception, FileNotFoundException {
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setCacheFactory(new CacheFactory(){

            public <K, V> Cache<K, V> get(String name) {
                return new MockCache(name, 10);
            }

            public void destroy() {
            }
        });
        MyServer es = new MyServer();
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        es.start(ec);
        try {
            if (f.getName().toLowerCase().endsWith(".vdb")) {
                es.deployVDBZip(f.toURI().toURL());
                Admin admin = es.getAdmin();
                VDB vdb = (VDB)admin.getVDBs().iterator().next();
                String format = System.getProperty("format", "DDL");
                String string = admin.getSchema(vdb.getName(), vdb.getVersion(), null, null, null, Admin.ExportFormat.valueOf((String)format));
                return string;
            }
            if (f.getName().toLowerCase().endsWith(".xml")) {
                String string = es.convertVDB(new FileInputStream(f));
                return string;
            }
        }
        finally {
            es.stop();
        }
        return null;
    }

    private static class MockCache<K, V>
    extends LRUCache<K, V>
    implements Cache<K, V> {
        private String name;

        public MockCache(String cacheName, int maxSize) {
            super(maxSize < 0 ? Integer.MAX_VALUE : maxSize);
            this.name = cacheName;
        }

        public V put(K key, V value, Long ttl) {
            return (V)this.put(key, value);
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }
    }

    private static class MyServer
    extends EmbeddedServer {
        private MyServer() {
        }

        @Override
        public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
            return new ExecutionFactory<Object, Object>(){

                public boolean isSourceRequired() {
                    return false;
                }

                public boolean isSourceRequiredForMetadata() {
                    return false;
                }
            };
        }

        String convertVDB(InputStream is) throws Exception {
            byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
            VDBMetaData metadata = null;
            try {
                metadata = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException(e);
            }
            metadata.setXmlDeployment(true);
            MetadataStore metadataStore = new MetadataStore();
            for (ModelMetaData m : metadata.getModelMetaDatas().values()) {
                Schema schema = new Schema();
                schema.setName(m.getName());
                Table table = new Table();
                table.setTableType(Table.Type.Table);
                table.setName("__temp__");
                Column column = new Column();
                column.setName("x");
                Datatype datatype = (Datatype)SystemMetadata.getInstance().getDataTypes().get(0);
                column.setDatatype(datatype);
                table.addColumn(column);
                column.setParent((ColumnSet)table);
                schema.addTable(table);
                metadataStore.addSchema(schema);
            }
            Database db = DatabaseUtil.convert((VDBMetaData)metadata, (MetadataStore)metadataStore);
            String contents = DDLStringVisitor.getDDLString((Database)db);
            String replace = "";
            String find = "CREATE FOREIGN TABLE \"__temp__\" (\n\tx xml OPTIONS (CASE_SENSITIVE FALSE)\n);\n";
            contents = contents.replace(find, replace);
            for (ModelMetaData m : metadata.getModelMetaDatas().values()) {
                find = "SET SCHEMA " + m.getName() + ";\n";
                if (m.isSource()) {
                    String sourceName = (String)m.getSourceNames().get(0);
                    String schemaName = (String)m.getPropertiesMap().get("importer.schemaPattern");
                    if (schemaName == null) {
                        schemaName = "public";
                    }
                    if (m.getSourceMetadataType().isEmpty()) {
                        replace = this.replaceNative(m, sourceName, schemaName);
                    } else {
                        for (int i = 0; i < m.getSourceMetadataType().size(); ++i) {
                            String type = (String)m.getSourceMetadataType().get(i);
                            if (type.equalsIgnoreCase("NATIVE")) {
                                replace = replace + this.replaceNative(m, sourceName, schemaName);
                                continue;
                            }
                            if (!type.equalsIgnoreCase("DDL")) continue;
                            replace = (String)m.getSourceMetadataText().get(0);
                        }
                    }
                } else {
                    replace = (String)m.getSourceMetadataText().get(0);
                }
                contents = contents.replace(find, find + replace);
            }
            return contents;
        }

        private String replaceNative(ModelMetaData m, String sourceName, String schemaName) {
            String replace = "IMPORT FOREIGN SCHEMA " + schemaName + " FROM SERVER " + sourceName + " INTO " + m.getName() + " OPTIONS (\n";
            Iterator it = m.getPropertiesMap().keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                replace = replace + "\t" + key + " '" + (String)m.getPropertiesMap().get(key) + "'";
                if (!it.hasNext()) continue;
                replace = replace + ",\n";
            }
            replace = replace + ");\n";
            return replace;
        }
    }
}

