/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadatastore;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.DataWrapper;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Grant;
import org.teiid.metadata.MetadataException;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Server;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.metadata.NativeMetadataRepository;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.RuntimePlugin;

public class SchemaLoadAwareDatabaseStore
extends DatabaseStore {
    private VDBRepository vdbRepo;
    private ConnectorManagerRepository.ExecutionFactoryProvider efp;
    private ConnectorManagerRepository cmr;
    private Admin admin;

    public SchemaLoadAwareDatabaseStore(Admin admin) {
        this.admin = admin;
    }

    public Map<String, Datatype> getRuntimeTypes() {
        return this.vdbRepo.getRuntimeTypeMap();
    }

    public Map<String, Datatype> getBuiltinDataTypes() {
        return this.vdbRepo.getSystemStore().getDatatypes();
    }

    public SystemFunctionManager getSystemFunctionManager() {
        return this.vdbRepo.getSystemFunctionManager();
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepo = repo;
    }

    public void setExecutionFactoryProvider(ConnectorManagerRepository.ExecutionFactoryProvider efp) {
        this.efp = efp;
    }

    public void setConnectorManagerRepository(ConnectorManagerRepository cmr) {
        this.cmr = cmr;
    }

    public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
        this.verifySchemaExists(schemaName);
        this.verifyServerExists(serverName);
        this.schemaSwitched(schemaName);
        Schema schema = this.getSchema(schemaName);
        Server server = this.getServer(serverName);
        MetadataFactory mf = DatabaseStore.createMF((DatabaseStore)this);
        NativeMetadataRepository nmr = new NativeMetadataRepository();
        mf.getModelProperties().put("importer.schemaPattern", foreignSchemaName);
        if (excludeTables != null && !excludeTables.isEmpty()) {
            mf.getModelProperties().put("importer.excludeTables", this.getCSV(excludeTables));
        }
        if (includeTables != null && !includeTables.isEmpty()) {
            mf.getModelProperties().put("importer.includeTables", this.getCSV(includeTables));
        }
        if (schema.getProperties() != null) {
            mf.getModelProperties().putAll((Map<?, ?>)schema.getProperties());
        }
        if (properties != null) {
            mf.getModelProperties().putAll(properties);
        }
        ConnectorManager cm = this.cmr.getConnectorManager(serverName);
        try {
            nmr.loadMetadata(mf, this.efp.getExecutionFactory(server.getDataWrapper()), cm.getConnectionFactory());
        }
        catch (Exception e) {
            throw new MetadataException((Throwable)e);
        }
        this.importSchema(mf.getSchema());
    }

    private void importSchema(Schema schema) {
        for (Table t : schema.getTables().values()) {
            this.tableCreated(t);
        }
        for (Procedure p : schema.getProcedures().values()) {
            this.procedureCreated(p);
        }
        for (FunctionMethod fm : schema.getFunctions().values()) {
            this.functionCreated(fm);
        }
    }

    private String getCSV(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        if (strings != null && !strings.isEmpty()) {
            for (String str : strings) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(str);
            }
        }
        return sb.toString();
    }

    public void importDatabase(String dbName, String version, boolean importPolicies) {
        this.verifyCurrentDatabaseIsNotSame(dbName, version);
        Database from = this.getDatabase(dbName, version);
        if (from == null) {
            VDBMetaData fromVDB = this.vdbRepo.getVDB(dbName, version);
            CompositeMetadataStore fromMetadataStore = null;
            if (fromVDB != null) {
                fromMetadataStore = ((TransformationMetadata)fromVDB.getAttachment(TransformationMetadata.class)).getMetadataStore();
            }
            if (fromVDB == null || fromMetadataStore == null) {
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31231, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31231, new Object[]{dbName, version}));
            }
            from = DatabaseUtil.convert((VDBMetaData)fromVDB, (MetadataStore)fromMetadataStore);
        }
        Database to = this.getCurrentDatabase();
        this.assertOverlap(from, to, importPolicies);
        this.merge(from, to, importPolicies);
    }

    private void assertOverlap(Database from, Database to, boolean importRoles) {
        for (Server fromServer : from.getServers()) {
            Server toServer = to.getServer(fromServer.getName());
            if (toServer == null || toServer.equals((Object)fromServer)) continue;
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31229, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31229, new Object[]{fromServer.getName(), to.getName(), to.getVersion()}));
        }
        for (Schema fromSchema : from.getSchemas()) {
            Schema toSchema = to.getSchema(fromSchema.getName());
            if (toSchema == null) continue;
            throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31228, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31228, new Object[]{fromSchema.getName(), to.getName(), to.getVersion()}));
        }
        if (importRoles) {
            for (Role fromRole : from.getRoles()) {
                Role toRole = to.getRole(fromRole.getName());
                if (toRole == null) continue;
                throw new MetadataException((BundleUtil.Event)QueryPlugin.Event.TEIID31230, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31230, new Object[]{fromRole.getName(), to.getName(), to.getVersion()}));
            }
        }
    }

    private void merge(Database from, Database to, boolean importRoles) {
        for (DataWrapper fromWrapper : from.getDataWrappers()) {
            if (to.getDataWrapper(fromWrapper.getName()) != null) continue;
            this.dataWrapperCreated(fromWrapper);
        }
        for (Server fromServer : from.getServers()) {
            if (to.getServer(fromServer.getName()) != null) continue;
            this.serverCreated(fromServer);
        }
        for (Schema fromSchema : from.getSchemas()) {
            if (to.getSchema(fromSchema.getName()) != null) continue;
            ArrayList<String> servers = new ArrayList<String>();
            for (Server server : fromSchema.getServers()) {
                servers.add(server.getName());
            }
            Schema s = new Schema();
            s.setName(fromSchema.getName());
            s.setPhysical(fromSchema.isPhysical());
            s.setProperties(fromSchema.getProperties());
            this.schemaCreated(s, servers);
            this.importSchema(fromSchema);
        }
        if (importRoles) {
            for (Role fromRole : from.getRoles()) {
                if (to.getRole(fromRole.getName()) != null) continue;
                this.roleCreated(fromRole);
            }
            for (Grant g : from.getGrants()) {
                this.grantCreated(g);
            }
        }
    }

    private void checkIfServerTypeExists(String type) {
        try {
            boolean found = false;
            Set serverTypes = this.admin.getDataSourceTemplateNames();
            if (serverTypes != null && !serverTypes.isEmpty() && serverTypes.contains(type)) {
                found = true;
            }
            if (!found) {
                throw new MetadataException((BundleUtil.Event)RuntimePlugin.Event.TEIID40151, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40151, new Object[]{type, serverTypes}));
            }
        }
        catch (AdminException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    private boolean doesDataSourceExists(String datasourceName) {
        try {
            boolean found = false;
            Collection datasources = this.admin.getDataSourceNames();
            if (datasources != null && !datasources.isEmpty() && datasources.contains(datasourceName)) {
                found = true;
            }
            return found;
        }
        catch (AdminException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    public void serverCreated(Server server) {
        super.serverCreated(server);
        if (server.isVirtual()) {
            return;
        }
        try {
            Properties p = new Properties();
            p.putAll((Map<?, ?>)server.getProperties());
            try {
                this.checkIfServerTypeExists(server.getType());
            }
            catch (MetadataException e) {
                String library = server.getProperty("library", false);
                if (library != null) {
                    List deployments = this.admin.getDeployments();
                    if (!deployments.contains(server.getType())) {
                        this.deployLibrary(server.getType(), library);
                    }
                    this.checkIfServerTypeExists(server.getType());
                }
                throw e;
            }
            String jndiName = server.getJndiName();
            if (jndiName == null && !this.doesDataSourceExists(server.getName())) {
                Collection defns = this.admin.getTemplatePropertyDefinitions(server.getType());
                for (PropertyDefinition def : defns) {
                    String key = def.getName();
                    if (key.equalsIgnoreCase("managedconnectionfactory-class") && server.getProperty("class-name", false) == null) {
                        key = "class-name";
                        p.put(key, def.getDefaultValue());
                    }
                    if (!def.isRequired() || server.getProperty(def.getName(), false) != null || def.getDefaultValue() != null) continue;
                    throw new MetadataException((BundleUtil.Event)RuntimePlugin.Event.TEIID40152, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40152, new Object[]{def.getName(), server.getName()}));
                }
                this.admin.createDataSource(server.getName(), server.getType(), p);
            }
        }
        catch (AdminException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    private void deployLibrary(String name, String pathOrUri) {
        try {
            if (!pathOrUri.endsWith(".jar") && !pathOrUri.endsWith("rar")) {
                LogManager.logWarning((String)"org.teiid.METASTORE", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40159, new Object[]{name, pathOrUri}));
                return;
            }
            InputStream in = null;
            if (pathOrUri.contains("://")) {
                URI url = URI.create(pathOrUri);
                in = url.toURL().openStream();
            } else {
                File f = new File(pathOrUri);
                if (f.exists() && f.isFile()) {
                    in = new FileInputStream(f);
                }
            }
            this.admin.deploy(name, in);
        }
        catch (IOException | AdminException e) {
            LogManager.logWarning((String)"org.teiid.METASTORE", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40158, new Object[]{name, pathOrUri}));
        }
    }

    public void serverDropped(String serverName) {
        super.serverDropped(serverName);
        Server server = this.getServer(serverName);
        if (server.isVirtual()) {
            return;
        }
        try {
            if (!this.doesDataSourceExists(server.getName())) {
                throw new MetadataException((BundleUtil.Event)RuntimePlugin.Event.TEIID40153, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40153, new Object[]{server.getName()}));
            }
            this.admin.deleteDataSource(server.getName());
        }
        catch (AdminException e) {
            throw new MetadataException((Throwable)e);
        }
    }
}

