/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadatastore;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.parser.QueryParser;

public class DeploymentBasedDatabaseStore
extends DatabaseStore {
    private VDBRepository vdbRepo;
    private ArrayList<VDBImportMetadata> importedVDBs = new ArrayList();
    private Map<String, List<ImportedSchema>> importedSchemas = new HashMap<String, List<ImportedSchema>>();

    public DeploymentBasedDatabaseStore(VDBRepository vdbRepo) {
        this.vdbRepo = vdbRepo;
    }

    public Map<String, Datatype> getRuntimeTypes() {
        return this.vdbRepo.getRuntimeTypeMap();
    }

    protected boolean shouldValidateDatabaseBeforeDeploy() {
        return false;
    }

    public SystemFunctionManager getSystemFunctionManager() {
        return this.vdbRepo.getSystemFunctionManager();
    }

    public VDBMetaData getVDBMetadata(String contents) {
        StringReader reader = new StringReader(contents);
        try {
            this.startEditing(false);
            this.setMode(DatabaseStore.Mode.DATABASE_STRUCTURE);
            QueryParser.getQueryParser().parseDDL((DatabaseStore)this, (Reader)new BufferedReader(reader));
        }
        finally {
            reader.close();
            this.stopEditing();
        }
        Database database = (Database)this.getDatabases().get(0);
        VDBMetaData vdb = DatabaseUtil.convert((Database)database);
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (this.importedSchemas.get(model.getName()) != null) {
                for (ImportedSchema is : this.importedSchemas.get(model.getName())) {
                    model.addProperty("importer.schemaPattern", is.foreignSchemaName);
                    if (is.excludeTables != null && !is.excludeTables.isEmpty()) {
                        model.addProperty("importer.excludeTables", this.getCSV(is.excludeTables));
                    }
                    if (is.includeTables != null && !is.includeTables.isEmpty()) {
                        model.addProperty("importer.includeTables", this.getCSV(is.includeTables));
                    }
                    if (is.properties != null) {
                        for (String key : is.properties.keySet()) {
                            model.addProperty(key, is.properties.get(key));
                        }
                    }
                    model.addSourceMetadata(is.serverType, null);
                }
                continue;
            }
            model.addSourceMetadata("DDL", null);
        }
        for (VDBImportMetadata vid : this.importedVDBs) {
            vdb.getVDBImports().add(vid);
        }
        vdb.addProperty("schema-ddl", contents);
        return vdb;
    }

    private String getCSV(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        if (strings != null && !strings.isEmpty()) {
            for (String str : strings) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(str);
            }
        }
        return sb.toString();
    }

    public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
        if (!this.assertInEditMode(DatabaseStore.Mode.DATABASE_STRUCTURE)) {
            return;
        }
        ImportedSchema schema = new ImportedSchema();
        schema.foreignSchemaName = foreignSchemaName;
        schema.includeTables = includeTables;
        schema.excludeTables = excludeTables;
        schema.properties = properties;
        schema.serverType = serverType;
        List<ImportedSchema> imports = this.importedSchemas.get(schemaName);
        if (imports == null) {
            imports = new ArrayList<ImportedSchema>();
        }
        imports.add(schema);
        this.importedSchemas.put(schemaName, imports);
    }

    public void importDatabase(String dbName, String version, boolean importPolicies) {
        if (!this.assertInEditMode(DatabaseStore.Mode.DATABASE_STRUCTURE)) {
            return;
        }
        VDBImportMetadata db = new VDBImportMetadata();
        db.setName(dbName);
        db.setVersion(version);
        db.setImportDataPolicies(importPolicies);
        this.importedVDBs.add(db);
    }

    private class ImportedSchema {
        String foreignSchemaName;
        List<String> includeTables;
        List<String> excludeTables;
        Map<String, String> properties;
        String serverType;

        private ImportedSchema() {
        }
    }
}

