/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.teiid.CommandContext;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeometryType;
import org.teiid.jdbc.TeiidConnection;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.odbc.ODBCServerRemoteImpl;
import org.teiid.query.function.GeometryFunctionMethods;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.symbol.GroupSymbol;

public class PgCatalogMetadataStore
extends MetadataFactory {
    private static final long serialVersionUID = 2158418324376966987L;
    public static final String TYPMOD = "(CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END)";

    public PgCatalogMetadataStore(String modelName, Map<String, Datatype> dataTypes) {
        super(modelName, (Object)1, modelName, dataTypes, new Properties(), null);
        this.add_pg_namespace();
        this.add_pg_class();
        this.add_pg_attribute();
        this.add_pg_type();
        this.add_pg_index();
        this.add_pg_am();
        this.add_pg_proc();
        this.add_pg_trigger();
        this.add_pg_attrdef();
        this.add_pg_database();
        this.add_pg_user();
        this.add_matpg_datatype();
        this.add_pg_description();
        this.add_pg_prepared_xacts();
        this.add_pg_inherits();
        this.add_pg_stats();
        this.add_geography_columns();
        this.addFunction("regClass", "regclass").setNullOnNull(true);
        this.addFunction("encode", "encode").setPushdown(FunctionMethod.PushDown.CAN_PUSHDOWN);
        this.addFunction("objDescription", "obj_description");
        this.addFunction("hasSchemaPrivilege", "has_schema_privilege").setNullOnNull(true);
        this.addFunction("hasTablePrivilege", "has_table_privilege").setNullOnNull(true);
        this.addFunction("formatType", "format_type").setNullOnNull(true);
        this.addFunction("currentSchema", "current_schema");
        this.addFunction("getUserById", "pg_get_userbyid");
        this.addFunction("colDescription", "col_description");
        this.addFunction("pgHasRole", "pg_has_role");
        this.addFunction("asBinary2", "ST_asBinary");
        this.addFunction("postgisLibVersion", "PostGIS_Lib_Version");
        this.addFunction("postgisGeosVersion", "postgis_geos_version");
        this.addFunction("postgisProjVersion", "postgis_proj_version");
        this.addFunction("postgisVersion", "postgis_version");
        this.addFunction("hasPerm", "has_function_privilege");
        this.addFunction("getExpr2", "pg_get_expr");
        this.addFunction("getExpr3", "pg_get_expr");
        FunctionMethod func = this.addFunction("asPGVector", "asPGVector");
        func.setProperty("teiid:pass-through-type", Boolean.TRUE.toString());
        this.addFunction("getOid", "getOid");
        func = this.addFunction("pg_client_encoding", "pg_client_encoding");
        func.setDeterminism(FunctionMethod.Determinism.COMMAND_DETERMINISTIC);
    }

    private void add_pg_prepared_xacts() {
        Table t = this.createView("pg_prepared_xacts");
        this.addColumn("transaction", "string", (ColumnSet)t);
        this.addColumn("gid", "string", (ColumnSet)t);
        this.addColumn("owner", "string", (ColumnSet)t);
        this.addColumn("database", "string", (ColumnSet)t);
        String transformation = "SELECT null, null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private void add_pg_inherits() {
        Table t = this.createView("pg_inherits");
        this.addColumn("inhrelid", "integer", (ColumnSet)t);
        this.addColumn("inhparent", "integer", (ColumnSet)t);
        this.addColumn("inhseqno", "integer", (ColumnSet)t);
        String transformation = "SELECT null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private void add_pg_stats() {
        Table t = this.createView("pg_stats");
        this.addColumn("schemaname", "string", (ColumnSet)t);
        this.addColumn("tablename", "string", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        String transformation = "SELECT null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private void add_geography_columns() {
        Table t = this.createView("geography_columns");
        this.addColumn("f_table_catalog", "string", (ColumnSet)t);
        this.addColumn("f_table_schema", "string", (ColumnSet)t);
        this.addColumn("f_table_name", "string", (ColumnSet)t);
        this.addColumn("f_geography_column", "string", (ColumnSet)t);
        this.addColumn("coord_dimension", "integer", (ColumnSet)t);
        this.addColumn("srid", "integer", (ColumnSet)t);
        this.addColumn("type", "string", (ColumnSet)t);
        String transformation = "SELECT null, null, null, null, null, null, null from SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
    }

    private Table createView(String name) {
        Table t = this.addTable(name);
        t.setSystem(true);
        t.setSupportsUpdate(false);
        t.setVirtual(true);
        t.setTableType(Table.Type.Table);
        return t;
    }

    private Table add_pg_description() {
        Table t = this.createView("pg_description");
        this.addColumn("objoid", "integer", (ColumnSet)t);
        this.addColumn("classoid", "integer", (ColumnSet)t);
        this.addColumn("objsubid", "integer", (ColumnSet)t);
        this.addColumn("description", "string", (ColumnSet)t);
        String transformation = "SELECT 0, null, null, null";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_am() {
        Table t = this.createView("pg_am");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("amname", "string", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'btree' as amname";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attrdef() {
        Table t = this.createView("pg_attrdef");
        this.addColumn("adrelid", "integer", (ColumnSet)t);
        this.addColumn("adnum", "short", (ColumnSet)t);
        this.addColumn("adbin", "string", (ColumnSet)t);
        this.addColumn("adsrc", "string", (ColumnSet)t);
        String transformation = "SELECT pg_catalog.getOid(t1.tableuid) as adrelid, convert(t1.Position, short) as adnum, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adbin, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adsrc FROM SYS.Columns as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attribute() {
        Table t = this.createView("pg_attribute");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("attrelid", "integer", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        this.addColumn("atttypid", "integer", (ColumnSet)t);
        this.addColumn("attlen", "short", (ColumnSet)t);
        this.addColumn("attnum", "short", (ColumnSet)t);
        this.addColumn("atttypmod", "integer", (ColumnSet)t);
        this.addColumn("attnotnull", "boolean", (ColumnSet)t);
        this.addColumn("attisdropped", "boolean", (ColumnSet)t);
        this.addColumn("atthasdef", "boolean", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_attr", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, pg_catalog.getOid(t1.TableUID) as attrelid, t1.Name as attname, pt.oid as atttypid,pt.typlen as attlen, convert(t1.Position, short) as attnum, (CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, false as attisdropped, false as atthasdef FROM SYS.Columns as t1 LEFT OUTER JOIN pg_catalog.matpg_datatype pt ON t1.DataType = pt.Name UNION ALL SELECT pg_catalog.getOid(kc.uid) + kc.position as oid, pg_catalog.getOid(kc.uid) as attrelid, t1.Name as attname, pt.oid as atttypid,pt.typlen as attlen, convert(kc.Position, short) as attnum, (CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger') THEN 4+(65536*(case when (t1.Precision>32767) then 32767 else t1.Precision end)+(case when (t1.Scale>32767) then 32767 else t1.Scale end)) WHEN (t1.DataType = 'string' OR t1.DataType = 'char') THEN (CASE WHEN (t1.Length <= 2147483643) THEN 4+ t1.Length ELSE 2147483647 END) ELSE -1 END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, false as attisdropped, false as atthasdef FROM (SYS.KeyColumns as kc INNER JOIN SYS.Columns as t1 ON kc.SchemaName = t1.SchemaName AND kc.TableName = t1.TableName AND kc.Name = t1.Name) LEFT OUTER JOIN pg_catalog.matpg_datatype pt ON t1.DataType = pt.Name WHERE kc.keytype in ('Primary', 'Unique', 'Index')";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_class() {
        Table t = this.createView("pg_class");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("relname", "string", (ColumnSet)t);
        this.addColumn("relnamespace", "integer", (ColumnSet)t);
        this.addColumn("relkind", "char", (ColumnSet)t);
        this.addColumn("relowner", "integer", (ColumnSet)t);
        this.addColumn("relam", "integer", (ColumnSet)t);
        this.addColumn("reltuples", "float", (ColumnSet)t);
        this.addColumn("relpages", "integer", (ColumnSet)t);
        this.addColumn("relhasrules", "boolean", (ColumnSet)t);
        this.addColumn("relhasoids", "boolean", (ColumnSet)t);
        this.addColumn("relnspname", "string", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_class", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, t1.name as relname, pg_catalog.getOid(t1.SchemaUID) as relnamespace, convert((CASE t1.isPhysical WHEN true THEN 'r' ELSE 'v' END), char) as relkind,0 as relowner, 0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids, t1.SchemaName as relnspname FROM SYS.Tables t1 UNION ALL SELECT pg_catalog.getOid(t1.uid) as oid, t1.name as relname, pg_catalog.getOid(uid) as relnamespace, convert('i', char) as relkind,0 as relowner, 0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids, t1.SchemaName as relnspname FROM SYS.Keys t1 WHERE t1.type in ('Primary', 'Unique', 'Index')";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_index() {
        Table t = this.createView("pg_index");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("indexrelid", "integer", (ColumnSet)t);
        this.addColumn("indrelid", "integer", (ColumnSet)t);
        this.addColumn("indnatts", "short", (ColumnSet)t);
        this.addColumn("indisclustered", "boolean", (ColumnSet)t);
        this.addColumn("indisunique", "boolean", (ColumnSet)t);
        this.addColumn("indisprimary", "boolean", (ColumnSet)t);
        Column c = this.addColumn("indkey", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.SHORT)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(22));
        this.addColumn("indexprs", "string", (ColumnSet)t);
        this.addColumn("indpred", "string", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_index", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, pg_catalog.getOid(t1.uid) as indexrelid, pg_catalog.getOid(t1.TableUID) as indrelid, cast(count(t1.uid) as short) as indnatts, false indisclustered, (CASE WHEN t1.KeyType in ('Unique', 'Primary') THEN true ELSE false END) as indisunique, (CASE t1.KeyType WHEN 'Primary' THEN true ELSE false END) as indisprimary, asPGVector(" + this.arrayAgg("(select at.attnum FROM pg_catalog.pg_attribute as at WHERE at.attname = t1.Name AND at.attrelid = pg_catalog.getOid(t1.TableUID))", "t1.position") + ") as indkey, " + "null as indexprs, null as indpred " + "FROM Sys.KeyColumns as t1 GROUP BY t1.TableUID, t1.uid, t1.KeyType, t1.KeyName";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_namespace() {
        Table t = this.createView("pg_namespace");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("nspname", "string", (ColumnSet)t);
        this.addColumn("nspowner", "integer", (ColumnSet)t);
        String transformation = "SELECT pg_catalog.getOid(uid) as oid, t1.Name as nspname, 0 as nspowner FROM SYS.Schemas as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_proc() {
        Table t = this.createView("pg_proc");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("proname", "string", (ColumnSet)t);
        this.addColumn("proretset", "boolean", (ColumnSet)t);
        this.addColumn("prorettype", "integer", (ColumnSet)t);
        this.addColumn("pronargs", "short", (ColumnSet)t);
        Column c = this.addColumn("proargtypes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.INTEGER)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(30));
        c = this.addColumn("proargnames", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.STRING)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1009));
        c = this.addColumn("proargmodes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.CHAR)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1002));
        c = this.addColumn("proallargtypes", DataTypeManager.getDataTypeName((Class)DataTypeManager.getArrayType((Class)DataTypeManager.DefaultDataClasses.INTEGER)), (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1028));
        this.addColumn("pronamespace", "integer", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_proc", Arrays.asList("oid"), t);
        String transformation = "SELECT pg_catalog.getOid(t1.uid) as oid, t1.Name as proname, (SELECT (CASE WHEN count(pp.Type)>0 THEN true else false END) as x FROM SYS.ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName and pp.Type='ResultSet') as proretset, CASE WHEN (SELECT count(dt.oid) FROM SYS.ProcedureParams pp, pg_catalog.matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type IN ('ReturnValue', 'ResultSet') AND dt.Name = pp.DataType) = 0 THEN (select oid from pg_catalog.pg_type WHERE typname = 'void') WHEN (SELECT count(dt.oid) FROM SYS.ProcedureParams pp, pg_catalog.matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type = 'ResultSet' AND dt.Name = pp.DataType) > 0 THEN (select oid from pg_catalog.pg_type WHERE typname = 'record') ELSE (SELECT dt.oid FROM SYS.ProcedureParams pp, pg_catalog.matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type = 'ReturnValue' AND dt.Name = pp.DataType) END as prorettype,  convert((SELECT count(*) FROM SYS.ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type IN ('In', 'InOut')), short) as pronargs, asPGVector((select " + this.arrayAgg("y.oid", "y.type, y.position") + " FROM (" + this.paramTable("'ResultSet','ReturnValue', 'Out'") + ") as y)) as proargtypes, " + "(select " + this.arrayAgg("y.name", "y.type, y.position") + " FROM (SELECT pp.Name as name, pp.position as position, pp.Type as type FROM SYS.ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN ('ReturnValue' )) as y) as proargnames, " + "(select case WHEN count(distinct(y.type)) = 1 THEN null ELSE " + this.arrayAgg("CASE WHEN (y.type ='In') THEN cast('i' as char) WHEN (y.type = 'Out') THEN cast('o' as char) WHEN (y.type = 'InOut') THEN cast('b' as char) WHEN (y.type = 'ResultSet') THEN cast('t' as char) END", "y.type,y.position") + " END FROM (SELECT pp.Type as type, pp.Position as position FROM SYS.ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN ('ReturnValue')) as y) as proargmodes, " + "(select case WHEN count(distinct(y.oid)) = 1 THEN null ELSE " + this.arrayAgg("y.oid", "y.type, y.position") + " END FROM (" + this.paramTable("'ReturnValue'") + ") as y) as proallargtypes, " + "pg_catalog.getOid(t1.SchemaUID) as pronamespace " + "FROM SYS.Procedures as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private String paramTable(String notIn) {
        return "SELECT case when pp.Type <> 'ResultSet' AND pp.DataType = 'object' then 2283 else dt.oid end as oid, pp.Position as position, pp.Type as type FROM SYS.ProcedureParams pp LEFT JOIN pg_catalog.matpg_datatype dt ON pp.DataType=dt.Name WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN (" + notIn + ")";
    }

    private String arrayAgg(String select, String orderby) {
        return "array_agg(" + select + " ORDER BY " + orderby + ")";
    }

    private Table add_pg_trigger() {
        Table t = this.createView("pg_trigger");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("tgconstrrelid", "integer", (ColumnSet)t);
        this.addColumn("tgfoid", "integer", (ColumnSet)t);
        this.addColumn("tgargs", "integer", (ColumnSet)t);
        this.addColumn("tgnargs", "integer", (ColumnSet)t);
        this.addColumn("tgdeferrable", "boolean", (ColumnSet)t);
        this.addColumn("tginitdeferred", "boolean", (ColumnSet)t);
        this.addColumn("tgconstrname", "string", (ColumnSet)t);
        this.addColumn("tgrelid", "integer", (ColumnSet)t);
        String transformation = "SELECT 1 as oid, 1 as tgconstrrelid, 1 as tgfoid, 1 as tgargs, 1 as tgnargs, false as tgdeferrable, false as tginitdeferred, 'dummy' as tgconstrname, 1 as tgrelid FROM SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_type() {
        Table t = this.createView("pg_type");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("typnamespace", "integer", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typnotnull", "boolean", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addColumn("typdelim", "char", (ColumnSet)t);
        this.addColumn("typrelid", "integer", (ColumnSet)t);
        this.addColumn("typelem", "integer", (ColumnSet)t);
        this.addColumn("typinput", "integer", (ColumnSet)t);
        this.addColumn("teiid_name", "string", (ColumnSet)t);
        String transformation = "select oid, typname, (SELECT pg_catalog.getOid(uid) FROM SYS.Schemas where Name = 'SYS') as typnamespace, typlen, typtype, false as typnotnull, typbasetype, typtypmod, cast(',' as char) as typdelim, typrelid, typelem, null as typeinput, teiid_name from texttable('16,bool,1,b,0,-1,0,0,boolean\n17,bytea,-1,b,0,-1,0,0,blob\n1043,varchar,-1,b,0,-1,0,0,string\n25,text,-1,b,0,-1,0,0,clob\n1042,char,1,b,0,-1,0,0,\n21,int2,2,b,0,-1,0,0,short\n20,int8,8,b,0,-1,0,0,long\n23,int4,4,b,0,-1,0,0,integer\n26,oid,4,b,0,-1,0,0,\n700,float4,4,b,0,-1,0,0,float\n701,float8,8,b,0,-1,0,0,double\n705,unknown,-2,b,0,-1,0,0,object\n1082,date,4,b,0,-1,0,0,date\n1083,time,8,b,0,-1,0,0,time\n1114,timestamp,8,b,0,-1,0,0,timestamp\n1700,numeric,-1,b,0,-1,0,0,bigdecimal\n142,xml,-1,b,0,-1,0,0,xml\n14939,lo,-1,b,0,-1,0,0,\n32816,geometry,-1,b,0,-1,0,0,geometry\n2278,void,4,p,0,-1,0,0,\n2249,record,-1,p,0,-1,0,0,\n30,oidvector,-1,b,0,-1,0,26,\n1000,_bool,-1,b,0,-1,0,16,boolean[]\n1001,_bytea,-1,b,0,-1,0,17,blob[]\n1002,_char,-1,b,0,-1,0,18,\n1005,_int2,-1,b,0,-1,0,21,short[]\n1007,_int4,-1,b,0,-1,0,23,integer[]\n1009,_text,-1,b,0,-1,0,25,clob[]\n1028,_oid,-1,b,0,-1,0,26,\n1014,_bpchar,-1,b,0,-1,0,1042,\n1015,_varchar,-1,b,0,-1,0,1043,string[]\n1016,_int8,-1,b,0,-1,0,20,long[]\n1021,_float4,-1,b,0,-1,0,700,float[]\n1022,_float8,-1,b,0,-1,0,701,double[]\n1031,_numeric,-1,b,0,-1,0,1700,double[]\n1115,_timestamp,-1,b,0,-1,0,1114,timestamp[]\n1182,_date,-1,b,0,-1,0,1082,date[]\n1183,_time,-1,b,0,-1,0,1083,time[]\n32824,_geometry,-1,b,0,-1,0,32816,geometry[]\n143,_xml,-1,b,0,-1,0,142,xml[]\n2287,_record,-1,b,0,-1,0,2249,\n2283,anyelement,4,p,0,-1,0,0,\n22,int2vector,-1,b,0,-1,0,0,' columns oid integer, typname string, typlen short, typtype char, typbasetype integer, typtypmod integer, typrelid integer, typelem integer, teiid_name string) AS t";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        t.setProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", "true");
        return t;
    }

    private Table add_pg_database() {
        Table t = this.createView("pg_database");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("datname", "string", (ColumnSet)t);
        this.addColumn("encoding", "integer", (ColumnSet)t);
        this.addColumn("datlastsysoid", "integer", (ColumnSet)t);
        this.addColumn("datallowconn", "char", (ColumnSet)t);
        this.addColumn("datconfig", "object", (ColumnSet)t);
        this.addColumn("datacl", "object", (ColumnSet)t);
        this.addColumn("datdba", "integer", (ColumnSet)t);
        this.addColumn("dattablespace", "integer", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'teiid' as datname, 6 as encoding, 100000 as datlastsysoid, convert('t', char) as datallowconn, null, null, 0 as datdba, 0 as dattablespace";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_user() {
        Table t = this.createView("pg_user");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("usename", "string", (ColumnSet)t);
        this.addColumn("usecreatedb", "boolean", (ColumnSet)t);
        this.addColumn("usesuper", "boolean", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, null as usename, false as usecreatedb, false as usesuper ";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_matpg_datatype() {
        Table t = this.createView("matpg_datatype");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("name", "string", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addPrimaryKey("matpg_datatype_names", Arrays.asList("oid", "name"), t);
        this.addIndex("matpg_datatype_ids", true, Arrays.asList("typname", "oid"), t);
        String transformation = "select pt.oid as oid, pt.typname as typname, pt.teiid_name as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt UNION ALL select pt.oid as oid, pt.typname as typname, 'char' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='varchar' UNION ALL select pt.oid as oid, pt.typname as typname, 'byte' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='int2' UNION ALL select pt.oid as oid, pt.typname as typname, 'biginteger' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='numeric' UNION ALL select pt.oid as oid, pt.typname as typname, 'varbinary' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='bytea' UNION ALL select pt.oid as oid, pt.typname as typname, 'byte[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_int2' UNION ALL select pt.oid as oid, pt.typname as typname, 'biginteger[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_numeric' UNION ALL select pt.oid as oid, pt.typname as typname, 'varbinary[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_bytea' UNION ALL select pt.oid as oid, pt.typname as typname, 'char[]' as name, pt.typlen, pt.typtype, pt.typbasetype, pt.typtypmod from pg_catalog.pg_type pt where typname='_varchar'";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        t.setProperty("{http://www.teiid.org/ext/relational/2012}ALLOW_MATVIEW_MANAGEMENT", "true");
        return t;
    }

    private FunctionMethod addFunction(String javaFunction, String name) {
        Method[] methods;
        for (Method method : methods = FunctionMethods.class.getMethods()) {
            if (!method.getName().equals(javaFunction)) continue;
            FunctionMethod func = this.addFunction(name, method);
            func.setCategory("pg");
            func.setDescription(name);
            return func;
        }
        throw new AssertionError((Object)"Could not find function");
    }

    public static class FunctionMethods {
        public static ClobType encode(BlobType value, String encoding) throws SQLException, IOException {
            return org.teiid.query.function.FunctionMethods.toChars((BlobType)value, (String)encoding);
        }

        public static String postgisLibVersion() {
            return "2.0.0 USE_GEOS=0 USE_PROJ=1 USE_STATS=0";
        }

        public static String postgisVersion() {
            return "2.0.0";
        }

        public static String postgisGeosVersion() {
            return null;
        }

        public static String postgisProjVersion() {
            return "Rel. 4.8.0";
        }

        public static Boolean hasPerm(Integer oid, String permission) {
            return true;
        }

        public static String getExpr2(String text, Integer oid) {
            return text;
        }

        public static String getExpr3(String text, Integer oid, Boolean prettyPrint) {
            return text;
        }

        public static Object asPGVector(Object obj) {
            if (obj instanceof ArrayImpl) {
                ((ArrayImpl)obj).setZeroBased(true);
            }
            return obj;
        }

        public static Integer getOid(CommandContext cc, String uid) {
            VDBMetaData metadata = (VDBMetaData)cc.getVdb();
            TransformationMetadata tm = (TransformationMetadata)metadata.getAttachment(TransformationMetadata.class);
            return tm.getMetadataStore().getOid(uid);
        }

        public static String pg_client_encoding(CommandContext cc) {
            SessionMetadata session = (SessionMetadata)cc.getSession();
            ODBCServerRemoteImpl server = (ODBCServerRemoteImpl)session.getAttachment(ODBCServerRemoteImpl.class);
            String encoding = null;
            if (server != null) {
                encoding = server.getEncoding();
            }
            if (encoding == null) {
                return "UTF8";
            }
            return encoding;
        }

        public static Integer regClass(CommandContext cc, String name) throws TeiidComponentException, QueryResolverException {
            VDBMetaData metadata = (VDBMetaData)cc.getVdb();
            TransformationMetadata tm = (TransformationMetadata)metadata.getAttachment(TransformationMetadata.class);
            GroupSymbol symbol = new GroupSymbol(SQLParserUtil.normalizeId((String)name));
            ResolverUtil.resolveGroup((GroupSymbol)symbol, (QueryMetadataInterface)tm);
            return tm.getMetadataStore().getOid(((Table)symbol.getMetadataID()).getUUID());
        }

        public static String objDescription(CommandContext cc, int oid) {
            return null;
        }

        public static String getUserById(int user) {
            return "pgadmin";
        }

        public static boolean hasSchemaPrivilege(CommandContext cc, String name, String privilege) {
            return "usage".equalsIgnoreCase(privilege);
        }

        public static boolean hasTablePrivilege(CommandContext cc, String name, String privilege) {
            return true;
        }

        public static String currentSchema(CommandContext cc) {
            return "SYS";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static String formatType(CommandContext cc, int oid, int typmod) throws SQLException {
            try (TeiidConnection c = cc.getConnection();){
                PreparedStatement ps = c.prepareStatement("select typname from pg_catalog.pg_type where oid = ?");
                ps.setInt(1, oid);
                ps.execute();
                ResultSet rs = ps.getResultSet();
                if (rs.next()) {
                    String name = rs.getString(1);
                    if (typmod > 4) {
                        if (name.equals("numeric")) {
                            name = name + "(" + (typmod - 4 >> 16) + "," + (typmod - 4 & 0xFFFF) + ")";
                        } else if (name.equals("bpchar") || name.equals("varchar")) {
                            name = name + "(" + (typmod - 4) + ")";
                        }
                    }
                    String string = name;
                    return string;
                }
                String string = "???";
                return string;
            }
        }

        public static String colDescription(CommandContext cc, int oid, int column_number) {
            return null;
        }

        public static boolean pgHasRole(CommandContext cc, int userOid, String privilege) {
            return true;
        }

        public static BlobType asBinary2(GeometryType geom, String encoding) throws FunctionExecutionException {
            return GeometryFunctionMethods.asBlob((GeometryType)geom, (String)encoding);
        }
    }
}

