/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheFactory;
import org.teiid.core.util.LRUCache;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.Database;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.sql.visitor.SQLStringVisitor;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.JBossLogger;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConvertVDB {
    public static void main(String[] args) throws Exception {
        File f;
        if (args.length < 1) {
            System.out.println("usage: CovertVDB /path/to/file-vdb.xml");
            System.exit(0);
        }
        if (!(f = new File(args[0])).exists()) {
            System.out.println("vdb file does not exist");
        }
        if (f.getName().toLowerCase().endsWith(".xml")) {
            System.out.println(ConvertVDB.convert(f));
        } else {
            System.out.println("Unknown file type supplied, only .XML based VDBs are supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convert(File f) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException, MalformedURLException, AdminException, Exception, FileNotFoundException {
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setCacheFactory(new CacheFactory(){

            public <K, V> Cache<K, V> get(String name) {
                return new MockCache(name, 10);
            }

            public void destroy() {
            }
        });
        MyServer es = new MyServer();
        LogManager.setLogListener((Logger)new JBossLogger(){

            @Override
            public boolean isEnabled(String context, int level) {
                return false;
            }
        });
        es.start(ec);
        try {
            String string = es.convertVDB(new FileInputStream(f));
            return string;
        }
        finally {
            es.stop();
        }
    }

    private static class MockCache<K, V>
    extends LRUCache<K, V>
    implements Cache<K, V> {
        private String name;

        public MockCache(String cacheName, int maxSize) {
            super(maxSize < 0 ? Integer.MAX_VALUE : maxSize);
            this.name = cacheName;
        }

        public V put(K key, V value, Long ttl) {
            return (V)this.put(key, value);
        }

        public String getName() {
            return this.name;
        }

        public boolean isTransactional() {
            return false;
        }
    }

    private static class MyServer
    extends EmbeddedServer {
        private MyServer() {
        }

        @Override
        public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
            return new ExecutionFactory<Object, Object>(){

                public boolean isSourceRequired() {
                    return false;
                }

                public boolean isSourceRequiredForMetadata() {
                    return false;
                }
            };
        }

        String convertVDB(InputStream is) throws Exception {
            byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
            VDBMetaData metadata = null;
            try {
                metadata = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException(e);
            }
            metadata.setXmlDeployment(true);
            MetadataStore metadataStore = new MetadataStore();
            final LinkedHashMap modelMetaDatas = metadata.getModelMetaDatas();
            for (ModelMetaData m : modelMetaDatas.values()) {
                Schema schema = new Schema();
                schema.setName(m.getName());
                schema.setAnnotation(m.getDescription());
                schema.setVisible(m.isVisible());
                schema.setPhysical(m.isSource());
                schema.setProperties(m.getPropertiesMap());
                metadataStore.addSchema(schema);
            }
            Database db = DatabaseUtil.convert((VDBMetaData)metadata, (MetadataStore)metadataStore);
            DDLStringVisitor visitor = new DDLStringVisitor(null, null){

                protected void createdSchmea(Schema schema) {
                    ModelMetaData m = (ModelMetaData)modelMetaDatas.get(schema.getName());
                    String replace = "";
                    String sourceName = m.getSourceNames().isEmpty() ? "" : (String)m.getSourceNames().get(0);
                    String schemaName = (String)m.getPropertiesMap().get("importer.schemaPattern");
                    if (schemaName == null) {
                        schemaName = "%";
                    }
                    if (m.getSourceMetadataType().isEmpty()) {
                        if (m.isSource()) {
                            replace = MyServer.this.replaceMetadataTag(m, sourceName, schemaName, true);
                        }
                    } else {
                        for (int i = 0; i < m.getSourceMetadataType().size(); ++i) {
                            String type = (String)m.getSourceMetadataType().get(i);
                            if (type.equalsIgnoreCase("NATIVE")) {
                                replace = replace + MyServer.this.replaceMetadataTag(m, sourceName, schemaName, true);
                                continue;
                            }
                            if (type.equalsIgnoreCase("DDL")) continue;
                            replace = replace + MyServer.this.replaceMetadataTag(m, type, schemaName, false);
                        }
                    }
                    this.buffer.append(replace);
                }

                protected void visit(Schema schema) {
                    super.visit(schema);
                    ModelMetaData m = (ModelMetaData)modelMetaDatas.get(schema.getName());
                    for (int i = 0; i < m.getSourceMetadataType().size(); ++i) {
                        String type = (String)m.getSourceMetadataType().get(i);
                        if (!type.equalsIgnoreCase("DDL")) continue;
                        this.buffer.append((String)m.getSourceMetadataText().get(i)).append("\n");
                    }
                }
            };
            visitor.visit(db);
            return visitor.toString();
        }

        private String replaceMetadataTag(ModelMetaData m, String sourceName, String schemaName, boolean server) {
            String replace = "IMPORT FOREIGN SCHEMA " + SQLStringVisitor.escapeSinglePart((String)schemaName) + " FROM " + (server ? "SERVER " : "REPOSITORY ") + SQLStringVisitor.escapeSinglePart((String)sourceName) + " INTO " + SQLStringVisitor.escapeSinglePart((String)m.getName());
            if (!m.getPropertiesMap().isEmpty()) {
                replace = replace + " OPTIONS (\n";
                Iterator it = m.getPropertiesMap().keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    replace = replace + "\t" + SQLStringVisitor.escapeSinglePart((String)key) + " '" + StringUtil.replaceAll((String)((String)m.getPropertiesMap().get(key)), (String)"'", (String)"''") + "'";
                    if (!it.hasNext()) continue;
                    replace = replace + ",\n";
                }
                replace = replace + ")";
            }
            replace = replace + ";\n\n";
            return replace;
        }

        @Override
        protected boolean allowOverrideTranslators() {
            return true;
        }
    }
}

