/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadatastore;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.metadata.Database;
import org.teiid.metadata.Datatype;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.DatabaseStore;
import org.teiid.query.metadata.DatabaseUtil;
import org.teiid.query.parser.QueryParser;

public class DeploymentBasedDatabaseStore
extends DatabaseStore {
    private VDBRepository vdbRepo;
    private ArrayList<VDBImportMetadata> importedVDBs = new ArrayList();

    public DeploymentBasedDatabaseStore(VDBRepository vdbRepo) {
        this.vdbRepo = vdbRepo;
    }

    public Map<String, Datatype> getRuntimeTypes() {
        return this.vdbRepo.getSystemStore().getDatatypes();
    }

    protected boolean shouldValidateDatabaseBeforeDeploy() {
        return false;
    }

    public SystemFunctionManager getSystemFunctionManager() {
        return this.vdbRepo.getSystemFunctionManager();
    }

    public VDBMetaData getVDBMetadata(String contents) {
        StringReader reader = new StringReader(contents);
        try {
            this.startEditing(false);
            this.setMode(DatabaseStore.Mode.DATABASE_STRUCTURE);
            QueryParser.getQueryParser().parseDDL((DatabaseStore)this, (Reader)new BufferedReader(reader));
        }
        finally {
            reader.close();
            this.stopEditing();
        }
        Database database = (Database)this.getDatabases().get(0);
        VDBMetaData vdb = DatabaseUtil.convert((Database)database);
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            model.addSourceMetadata("DDL", null);
        }
        for (VDBImportMetadata vid : this.importedVDBs) {
            vdb.getVDBImports().add(vid);
        }
        vdb.addProperty("full-ddl", contents);
        return vdb;
    }

    public void importSchema(String schemaName, String serverType, String serverName, String foreignSchemaName, List<String> includeTables, List<String> excludeTables, Map<String, String> properties) {
        if (this.getSchema(schemaName) == null) {
            throw new AssertionError();
        }
        if (!this.assertInEditMode(DatabaseStore.Mode.SCHEMA)) {
            return;
        }
    }

    public void importDatabase(String dbName, String version, boolean importPolicies) {
        if (!this.assertInEditMode(DatabaseStore.Mode.DATABASE_STRUCTURE)) {
            return;
        }
        VDBImportMetadata db = new VDBImportMetadata();
        db.setName(dbName);
        db.setVersion(version);
        db.setImportDataPolicies(importPolicies);
        this.importedVDBs.add(db);
    }
}

