/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.StringUtil;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.ExtendedPropertyMetadataList;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.query.QueryPlugin;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.DelegatingExecutionFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorProperty;

public class TranslatorUtil {
    public static final String DEPLOYMENT_NAME = "deployment-name";

    static Map<Method, TranslatorProperty> getTranslatorProperties(Class<?> attachmentClass) {
        TreeMap<Method, TranslatorProperty> props = new TreeMap<Method, TranslatorProperty>(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TranslatorUtil.buildTranslatorProperties(attachmentClass, props);
        return props;
    }

    static Map<Field, ExtensionMetadataProperty> getExtensionMetadataProperties(Class<?> attachmentClass) {
        TreeMap<Field, ExtensionMetadataProperty> props = new TreeMap<Field, ExtensionMetadataProperty>(new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        TranslatorUtil.buildExtensionMetadataProperties(attachmentClass, props);
        return props;
    }

    private static void buildTranslatorProperties(Class<?> attachmentClass, Map<Method, TranslatorProperty> props) {
        Method[] methods;
        Class<?>[] baseInterfaces;
        for (Class<?> clazz : baseInterfaces = attachmentClass.getInterfaces()) {
            TranslatorUtil.buildTranslatorProperties(clazz, props);
        }
        Class<?> superClass = attachmentClass.getSuperclass();
        if (superClass != null) {
            TranslatorUtil.buildTranslatorProperties(superClass, props);
        }
        for (Method m : methods = attachmentClass.getMethods()) {
            TranslatorProperty tp = m.getAnnotation(TranslatorProperty.class);
            if (tp == null) continue;
            props.put(m, tp);
        }
    }

    private static void buildExtensionMetadataProperties(Class<?> attachmentClass, Map<Field, ExtensionMetadataProperty> props) {
        Field[] fields;
        Class<?>[] baseInterfaces;
        for (Class<?> clazz : baseInterfaces = attachmentClass.getInterfaces()) {
            TranslatorUtil.buildExtensionMetadataProperties(clazz, props);
        }
        Class<?> superClass = attachmentClass.getSuperclass();
        if (superClass != null) {
            TranslatorUtil.buildExtensionMetadataProperties(superClass, props);
        }
        for (Field f : fields = attachmentClass.getDeclaredFields()) {
            ExtensionMetadataProperty tp = f.getAnnotation(ExtensionMetadataProperty.class);
            if (tp == null) continue;
            f.setAccessible(true);
            props.put(f, tp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionFactory buildExecutionFactory(VDBTranslatorMetaData data) throws TeiidException {
        try {
            ExecutionFactory executionFactory;
            Class executionClass = data.getExecutionFactoryClass();
            Object o = executionClass.newInstance();
            if (!(o instanceof ExecutionFactory)) {
                throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40024, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40024, new Object[]{executionClass}));
            }
            ExecutionFactory executionFactory2 = executionFactory = (ExecutionFactory)o;
            synchronized (executionFactory2) {
                TranslatorUtil.injectProperties(executionFactory, data);
                ClassLoader orginalCL = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(executionFactory.getClass().getClassLoader());
                    executionFactory.start();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(orginalCL);
                }
            }
            return executionFactory;
        }
        catch (InvocationTargetException e) {
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40025, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40026, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TeiidException((BundleUtil.Event)CorePlugin.Event.TEIID10036, (Throwable)e);
        }
    }

    public static ExecutionFactory<Object, Object> buildDelegateAwareExecutionFactory(VDBTranslatorMetaData translator, ConnectorManagerRepository.ExecutionFactoryProvider provider) throws ConnectorManagerRepository.ConnectorManagerException {
        DelegatingExecutionFactory delegator;
        String delegateName;
        ExecutionFactory ef = null;
        try {
            ef = TranslatorUtil.buildExecutionFactory(translator);
        }
        catch (TeiidException e) {
            throw new ConnectorManagerRepository.ConnectorManagerException((Throwable)e);
        }
        if (ef instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
            ExecutionFactory delegate = provider.getExecutionFactory(delegateName);
            if (delegate == null) {
                throw new ConnectorManagerRepository.ConnectorManagerException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40155, new Object[]{delegateName}));
            }
            ((DelegatingExecutionFactory)ef).setDelegate(delegate);
        }
        return ef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void injectProperties(ExecutionFactory ef, VDBTranslatorMetaData data) throws InvocationTargetException, IllegalAccessException, TeiidException {
        Map<Method, TranslatorProperty> props = TranslatorUtil.getTranslatorProperties(ef.getClass());
        Map p = data.getPropertiesMap();
        TreeMap caseInsensitiveProps = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        Map map = p;
        synchronized (map) {
            caseInsensitiveProps.putAll(p);
        }
        caseInsensitiveProps.remove(DEPLOYMENT_NAME);
        for (Method method : props.keySet()) {
            TranslatorProperty tp = props.get(method);
            String propertyName = TranslatorUtil.getPropertyName(method);
            String value = (String)caseInsensitiveProps.remove(propertyName);
            if (value != null) {
                Method setterMethod = TranslatorUtil.getSetter(ef.getClass(), method);
                setterMethod.invoke((Object)ef, TranslatorUtil.convert(value, method.getReturnType()));
                continue;
            }
            if (!tp.required()) continue;
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40027, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40027, new Object[]{tp.display()}));
        }
        caseInsensitiveProps.remove("execution-factory-class");
        if (!caseInsensitiveProps.isEmpty()) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40001, new Object[]{caseInsensitiveProps.keySet(), data.getName()}));
        }
    }

    public static String getPropertyName(Method method) {
        String result = method.getName();
        if (result.startsWith("get")) {
            return result.substring(3);
        }
        if (result.startsWith("is")) {
            return result.substring(2);
        }
        return result;
    }

    public static Method getSetter(Class<?> clazz, Method method) throws SecurityException, TeiidException {
        String setter = method.getName();
        setter = method.getName().startsWith("get") ? "set" + setter.substring(3) : (method.getName().startsWith("is") ? "set" + setter.substring(2) : "set" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1));
        try {
            return clazz.getMethod(setter, method.getReturnType());
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(method.getName(), method.getReturnType());
            }
            catch (NoSuchMethodException e1) {
                throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40028, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40028, new Object[]{setter, method.getName()}));
            }
        }
    }

    private static Object convert(Object value, Class<?> type) {
        if (value.getClass() == type) {
            return value;
        }
        if (value instanceof String) {
            String str = (String)value;
            return StringUtil.valueOf((String)str, type);
        }
        return value;
    }

    public static String getTranslatorName(ExecutionFactory factory) {
        Translator translator = factory.getClass().getAnnotation(Translator.class);
        if (translator == null) {
            return null;
        }
        return translator.name();
    }

    public static VDBTranslatorMetaData buildTranslatorMetadata(ExecutionFactory factory, String moduleName) {
        Translator translator = factory.getClass().getAnnotation(Translator.class);
        if (translator == null) {
            return null;
        }
        VDBTranslatorMetaData metadata = new VDBTranslatorMetaData();
        String see = translator.deprecated();
        if (see != null && see.length() > 0) {
            metadata.addProperty("deprecated", see);
        }
        metadata.setName(translator.name());
        metadata.setDescription(translator.description());
        metadata.setExecutionFactoryClass(factory.getClass());
        metadata.setModuleName(moduleName);
        ExtendedPropertyMetadataList propertyDefns = new ExtendedPropertyMetadataList();
        try {
            Object instance = factory.getClass().newInstance();
            TranslatorUtil.buildTranslatorProperties(factory, metadata, propertyDefns, instance);
            TranslatorUtil.buildExtensionMetadataProperties(factory, metadata, propertyDefns, instance);
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        metadata.addAttchment(ExtendedPropertyMetadataList.class, (Object)propertyDefns);
        return metadata;
    }

    private static void buildExtensionMetadataProperties(ExecutionFactory factory, VDBTranslatorMetaData metadata, ExtendedPropertyMetadataList propertyDefns, Object instance) {
        Class<?> clazz = factory.getClass();
        TranslatorUtil.readExtensionPropertyMetadataAsExtendedMetadataProperties(propertyDefns, clazz);
        MetadataProcessor metadataProcessor = factory.getMetadataProcessor();
        if (metadataProcessor != null) {
            clazz = metadataProcessor.getClass();
            TranslatorUtil.readExtensionPropertyMetadataAsExtendedMetadataProperties(propertyDefns, clazz);
        }
    }

    private static void buildTranslatorProperties(ExecutionFactory factory, VDBTranslatorMetaData metadata, ExtendedPropertyMetadataList propertyDefns, Object instance) {
        Class<?> clazz = factory.getClass();
        TranslatorUtil.readTranslatorPropertyAsExtendedMetadataProperties(metadata, propertyDefns, instance, clazz);
        MetadataProcessor metadataProcessor = factory.getMetadataProcessor();
        if (metadataProcessor != null) {
            clazz = metadataProcessor.getClass();
            TranslatorUtil.readTranslatorPropertyAsExtendedMetadataProperties(metadata, propertyDefns, metadataProcessor, clazz);
        }
    }

    private static void readExtensionPropertyMetadataAsExtendedMetadataProperties(ExtendedPropertyMetadataList propertyDefns, Class clazz) {
        Map<Field, ExtensionMetadataProperty> tps = TranslatorUtil.getExtensionMetadataProperties(clazz);
        for (Field f : tps.keySet()) {
            ExtensionMetadataProperty tp = tps.get(f);
            ExtendedPropertyMetadata epm = new ExtendedPropertyMetadata();
            epm.category = TranslatorProperty.PropertyType.EXTENSION_METADATA.name();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < tp.applicable().length; ++i) {
                sb.append(tp.applicable()[i].getName());
                if (tp.applicable().length - 1 <= i) continue;
                sb.append(",");
            }
            epm.owner = sb.toString();
            try {
                epm.name = (String)f.get(null);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            epm.description = tp.description();
            epm.displayName = tp.display();
            epm.required = tp.required();
            epm.dataType = tp.datatype().getName();
            if (tp.allowed() != null && !tp.allowed().isEmpty()) {
                epm.allowed = new ArrayList();
                StringTokenizer st = new StringTokenizer(tp.allowed(), ",");
                while (st.hasMoreTokens()) {
                    epm.allowed.add(st.nextToken());
                }
            }
            propertyDefns.add(epm);
        }
    }

    private static void readTranslatorPropertyAsExtendedMetadataProperties(VDBTranslatorMetaData metadata, ExtendedPropertyMetadataList propertyDefns, Object instance, Class clazz) {
        Map<Method, TranslatorProperty> tps = TranslatorUtil.getTranslatorProperties(clazz);
        for (Method m : tps.keySet()) {
            boolean importProperty;
            Object defaultValue = TranslatorUtil.getDefaultValue(instance, m, tps.get(m));
            TranslatorProperty tp = tps.get(m);
            boolean bl = importProperty = tp.category() == TranslatorProperty.PropertyType.IMPORT;
            if (defaultValue != null && !importProperty) {
                metadata.addProperty(TranslatorUtil.getPropertyName(m), defaultValue.toString());
            }
            ExtendedPropertyMetadata epm = new ExtendedPropertyMetadata();
            epm.category = tp.category().name();
            epm.name = importProperty ? "importer." + TranslatorUtil.getPropertyName(m) : TranslatorUtil.getPropertyName(m);
            epm.description = tp.description();
            epm.advanced = tp.advanced();
            if (defaultValue != null) {
                epm.defaultValue = defaultValue.toString();
            }
            epm.displayName = tp.display();
            epm.masked = tp.masked();
            epm.required = tp.required();
            epm.dataType = m.getReturnType().getCanonicalName();
            if (m.getReturnType().isEnum()) {
                epm.allowed = new ArrayList();
                ?[] constants = m.getReturnType().getEnumConstants();
                for (int i = 0; i < constants.length; ++i) {
                    epm.allowed.add(((Enum)constants[i]).name());
                }
                epm.dataType = "java.lang.String";
            }
            propertyDefns.add(epm);
        }
    }

    private static Object convert(Object instance, Method method, TranslatorProperty prop) {
        Method getter;
        String[] allowedValues;
        Class<Object> type;
        block20: {
            type = method.getReturnType();
            allowedValues = null;
            getter = null;
            boolean readOnly = prop.readOnly();
            if (type == Void.TYPE) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != 1) {
                    throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, new Object[]{method}));
                }
                type = types[0];
                try {
                    getter = instance.getClass().getMethod("get" + method.getName(), null);
                }
                catch (Exception e) {
                    try {
                        getter = instance.getClass().getMethod("get" + method.getName().substring(3), null);
                    }
                    catch (Exception exception) {}
                }
            } else {
                if (method.getParameterTypes().length != 0) {
                    throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, new Object[]{method}));
                }
                getter = method;
                try {
                    TranslatorUtil.getSetter(instance.getClass(), method);
                }
                catch (Exception e) {
                    if (readOnly) break block20;
                    throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40146, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40146, new Object[]{method}));
                }
            }
        }
        Object defaultValue = null;
        if (prop.required()) {
            if (prop.advanced()) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40031, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40031, new Object[]{method}));
            }
        } else if (getter != null) {
            try {
                defaultValue = getter.invoke(instance, (Object[])null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.isEnum()) {
            ?[] constants = type.getEnumConstants();
            allowedValues = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                allowedValues[i] = ((Enum)constants[i]).name();
            }
            type = String.class;
            if (defaultValue != null) {
                defaultValue = ((Enum)defaultValue).name();
            }
        }
        if (!(defaultValue instanceof Serializable)) {
            defaultValue = null;
        }
        return defaultValue;
    }

    public static Object getDefaultValue(Object instance, Method method, TranslatorProperty prop) {
        return TranslatorUtil.convert(instance, method, prop);
    }

    public static ExecutionFactory<Object, Object> getExecutionFactory(String name, TranslatorRepository vdbRepo, TranslatorRepository repo, VDBMetaData deployment, IdentityHashMap<org.teiid.adminapi.Translator, ExecutionFactory<Object, Object>> map, HashSet<String> building) throws ConnectorManagerRepository.ConnectorManagerException {
        if (!building.add(name)) {
            throw new ConnectorManagerRepository.ConnectorManagerException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40138, new Object[]{building}));
        }
        VDBTranslatorMetaData translator = vdbRepo.getTranslatorMetaData(name);
        if (translator == null) {
            translator = repo.getTranslatorMetaData(name);
        }
        if (translator == null) {
            return null;
        }
        ExecutionFactory ef = map.get(translator);
        if (ef == null) {
            DelegatingExecutionFactory delegator;
            String delegateName;
            try {
                ef = TranslatorUtil.buildExecutionFactory(translator);
            }
            catch (TeiidException e) {
                throw new ConnectorManagerRepository.ConnectorManagerException((Throwable)e);
            }
            if (ef instanceof DelegatingExecutionFactory && (delegateName = (delegator = (DelegatingExecutionFactory)ef).getDelegateName()) != null) {
                ExecutionFactory<Object, Object> delegate = TranslatorUtil.getExecutionFactory(delegateName, vdbRepo, repo, deployment, map, building);
                if (delegate == null) {
                    if (deployment != null) {
                        throw new ConnectorManagerRepository.ConnectorManagerException(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31146, new Object[]{deployment.getName(), deployment.getVersion(), delegateName}));
                    }
                    throw new ConnectorManagerRepository.ConnectorManagerException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40136, new Object[]{delegateName}));
                }
                ((DelegatingExecutionFactory)ef).setDelegate(delegate);
            }
            map.put((org.teiid.adminapi.Translator)translator, (ExecutionFactory<Object, Object>)ef);
        }
        return ef;
    }
}

