/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.TransactionManager;
import javax.xml.stream.XMLStreamException;
import org.jboss.vfs.VirtualFile;
import org.teiid.PreParser;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.deployers.CompositeGlobalTableStore;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.ContainerLifeCycleListener;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.dqp.internal.process.CachedResults;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jdbc.CallableStatementImpl;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.LocalProfile;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidPreparedStatement;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.index.IndexMetadataRepository;
import org.teiid.metadatastore.DeploymentBasedDatabaseStore;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.metadata.DDLStringVisitor;
import org.teiid.query.metadata.PureZipFileSystem;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.metadata.VDBResources;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.replication.jgroups.JGroupsObjectReplicator;
import org.teiid.runtime.AbstractVDBDeployer;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.runtime.EmbeddedAdminFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedConnection;
import org.teiid.runtime.EmbeddedRequestOptions;
import org.teiid.runtime.JBossLogger;
import org.teiid.runtime.MaterializationManager;
import org.teiid.runtime.NodeTracker;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.runtime.SimpleChannelFactory;
import org.teiid.services.AbstractEventDistributorFactoryService;
import org.teiid.services.BufferServiceImpl;
import org.teiid.services.SessionServiceImpl;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCSocketListener;
import org.teiid.transport.SocketClientInstance;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.WireProtocol;
import org.teiid.vdb.runtime.VDBKey;
import org.xml.sax.SAXException;

public class EmbeddedServer
extends AbstractVDBDeployer
implements EventDistributorFactory,
ConnectorManagerRepository.ExecutionFactoryProvider {
    private LocalProfile embeddedProfile = new LocalProfile(){

        public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
            ServerConnection conn;
            try {
                conn = this.createServerConnection(info);
            }
            catch (TeiidException e) {
                throw TeiidSQLException.create((Throwable)e);
            }
            return new EmbeddedConnectionImpl(conn, info, url);
        }

        public ServerConnection createServerConnection(Properties info) throws TeiidException {
            LocalServerConnection conn = new LocalServerConnection(info, EmbeddedServer.this.useCallingThread){

                @Override
                protected ClientServiceRegistry getClientServiceRegistry(String name) {
                    return EmbeddedServer.this.services;
                }

                @Override
                public void addListener(VDBLifeCycleListener listener) {
                    EmbeddedServer.this.repo.addListener(listener);
                }

                @Override
                public void removeListener(VDBLifeCycleListener listener) {
                    EmbeddedServer.this.repo.removeListener(listener);
                }
            };
            conn.getWorkContext().setConnectionProfile((LocalProfile)this);
            return conn;
        }
    };
    protected DQPCore dqp = new DQPCore();
    protected VDBRepository repo = new VDBRepository(){

        @Override
        protected boolean processMetadataValidatorReport(VDBKey key, ValidatorReport report) {
            if (EmbeddedServer.this.throwMetadataErrors) {
                super.processMetadataValidatorReport(key, report);
                ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
                throw new VDBValidationError(RuntimePlugin.Event.TEIID40095, firstFailure.getMessage());
            }
            return true;
        }
    };
    protected boolean throwMetadataErrors = true;
    private ConcurrentHashMap<String, ExecutionFactory<?, ?>> translators = new ConcurrentHashMap();
    private TranslatorRepository translatorRepository = new TranslatorRepository();
    private ConcurrentHashMap<String, ConnectionFactoryProvider<?>> connectionFactoryProviders = new ConcurrentHashMap();
    protected SessionServiceImpl sessionService = new SessionServiceImpl();
    protected ObjectReplicator replicator;
    protected BufferServiceImpl bufferService = new BufferServiceImpl();
    protected TransactionServerImpl transactionService = new TransactionServerImpl();
    protected boolean waitForLoad;
    protected ClientServiceRegistryImpl services = new ClientServiceRegistryImpl(){

        @Override
        public void waitForFinished(VDBKey vdbKey, int timeOutMillis) throws ConnectionException {
            if (EmbeddedServer.this.waitForLoad) {
                EmbeddedServer.this.repo.waitForFinished(vdbKey, timeOutMillis);
            }
        }

        @Override
        public ClassLoader getCallerClassloader() {
            return this.getClass().getClassLoader();
        }
    };
    protected LogonImpl logon;
    private TeiidDriver driver = new TeiidDriver();
    protected ConnectorManagerRepository cmr = new ProviderAwareConnectorManagerRepository();
    protected AbstractEventDistributorFactoryService eventDistributorFactoryService;
    protected boolean useCallingThread = true;
    private Boolean running;
    private EmbeddedConfiguration config;
    private SessionAwareCache<CachedResults> rs;
    private SessionAwareCache<PreparedPlan> ppc;
    protected ArrayList<SocketListener> transports = new ArrayList();
    private ScheduledExecutorService scheduler;
    private MaterializationManager materializationMgr = null;
    private ShutDownListener shutdownListener = new ShutDownListener();
    private SimpleChannelFactory channelFactory;
    private NodeTracker nodeTracker = null;

    public void addConnectionFactoryProvider(String name, ConnectionFactoryProvider<?> connectionFactoryProvider) {
        this.connectionFactoryProviders.put(name, connectionFactoryProvider);
    }

    public void addConnectionFactory(String name, Object connectionFactory) {
        this.connectionFactoryProviders.put(name, new SimpleConnectionFactoryProvider<Object>(connectionFactory));
    }

    public synchronized void start(EmbeddedConfiguration config) {
        if (this.running != null) {
            throw new IllegalStateException();
        }
        this.dqp.setLocalProfile(this.embeddedProfile);
        this.shutdownListener.setBootInProgress(true);
        this.config = config;
        System.setProperty("jboss.node.name", config.getNodeName() == null ? "localhost" : config.getNodeName());
        this.cmr.setProvider((ConnectorManagerRepository.ExecutionFactoryProvider)this);
        this.eventDistributorFactoryService = new EmbeddedEventDistributorFactoryService();
        this.eventDistributorFactoryService.start();
        this.dqp.setEventDistributor(this.eventDistributorFactoryService.getReplicatedEventDistributor());
        this.scheduler = Executors.newScheduledThreadPool(config.getMaxAsyncThreads(), (ThreadFactory)new NamedThreadFactory("Asynch Worker"));
        this.replicator = config.getObjectReplicator();
        if (this.replicator == null && config.getJgroupsConfigFile() != null) {
            this.channelFactory = new SimpleChannelFactory(config);
            this.replicator = new JGroupsObjectReplicator(this.channelFactory, this.scheduler);
            try {
                this.nodeTracker = new NodeTracker(this.channelFactory.createChannel("teiid-node-tracker"), config.getNodeName()){

                    @Override
                    public ScheduledExecutorService getScheduledExecutorService() {
                        return EmbeddedServer.this.scheduler;
                    }
                };
            }
            catch (Exception e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
            }
        }
        this.eventDistributorFactoryService = new EmbeddedEventDistributorFactoryService();
        this.eventDistributorFactoryService.start();
        this.dqp.setEventDistributor(this.eventDistributorFactoryService.getReplicatedEventDistributor());
        if (config.getTransactionManager() == null) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
            this.transactionService.setTransactionManager((TransactionManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{TransactionManager.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new UnsupportedOperationException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
                }
            }));
        } else {
            this.transactionService.setDetectTransactions(true);
            this.transactionService.setTransactionManager(config.getTransactionManager());
        }
        if (config.getSecurityHelper() != null) {
            this.sessionService.setSecurityHelper(config.getSecurityHelper());
        } else {
            this.sessionService.setSecurityHelper(new DoNothingSecurityHelper());
        }
        if (config.getSecurityDomain() != null) {
            this.sessionService.setSecurityDomain(config.getSecurityDomain());
        } else {
            this.sessionService.setSecurityDomain("teiid-security");
        }
        this.sessionService.setVDBRepository(this.repo);
        this.setBufferManagerProperties(config);
        BufferService bs = this.getBufferService();
        this.dqp.setBufferManager(bs.getBufferManager());
        this.startVDBRepository();
        this.rs = new SessionAwareCache("resultset", config.getCacheFactory(), SessionAwareCache.Type.RESULTSET, config.getMaxResultSetCacheStaleness());
        this.ppc = new SessionAwareCache("preparedplan", config.getCacheFactory(), SessionAwareCache.Type.PREPAREDPLAN, 0);
        this.rs.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setResultsetCache(this.rs);
        this.ppc.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setPreparedPlanCache(this.ppc);
        this.dqp.setTransactionService((TransactionService)LogManager.createLoggingProxy((String)"org.teiid.TXN_LOG", (Object)this.transactionService, (Class[])new Class[]{TransactionService.class}, (int)5, (ClassLoader)Thread.currentThread().getContextClassLoader()));
        this.dqp.start((DQPConfiguration)config);
        this.sessionService.setDqp(this.dqp);
        this.services.setSecurityHelper(this.sessionService.getSecurityHelper());
        if (this.config.getAuthenticationType() != null) {
            this.services.setAuthenticationType(this.config.getAuthenticationType());
            this.sessionService.setAuthenticationType(this.config.getAuthenticationType());
        }
        this.services.setVDBRepository(this.repo);
        this.materializationMgr = this.getMaterializationManager();
        this.repo.addListener(this.materializationMgr);
        if (this.nodeTracker != null) {
            this.nodeTracker.addNodeListener(this.materializationMgr);
        }
        this.logon = new LogonImpl(this.sessionService, null);
        this.services.registerClientService(ILogon.class, this.logon, "org.teiid.SECURITY");
        this.services.registerClientService(DQP.class, this.dqp, "org.teiid.PROCESSOR");
        this.initDriver();
        List<SocketConfiguration> transports = config.getTransports();
        if (transports != null && !transports.isEmpty()) {
            for (SocketConfiguration socketConfig : transports) {
                SocketListener socketConnection = this.startTransport(socketConfig, bs.getBufferManager(), config.getMaxODBCLobSizeAllowed());
                if (socketConfig.getSSLConfiguration() != null) {
                    try {
                        socketConfig.getSSLConfiguration().getServerSSLEngine();
                    }
                    catch (Exception e) {
                        throw new TeiidRuntimeException((Throwable)e);
                    }
                }
                this.transports.add(socketConnection);
            }
        }
        this.shutdownListener.setBootInProgress(false);
        this.shutdownListener.started();
        this.running = true;
    }

    private void setBufferManagerProperties(EmbeddedConfiguration config) {
        this.bufferService.setUseDisk(config.isUseDisk());
        if (config.isUseDisk()) {
            if (config.getBufferDirectory() == null) {
                config.setBufferDirectory(System.getProperty("java.io.tmpdir"));
            }
            this.bufferService.setDiskDirectory(config.getBufferDirectory());
        }
        if (config.getProcessorBatchSize() != -1) {
            this.bufferService.setProcessorBatchSize(config.getProcessorBatchSize());
        }
        if (config.getMaxReserveKb() != -1) {
            this.bufferService.setMaxReserveKb(config.getMaxReserveKb());
        }
        if (config.getMaxProcessingKb() != -1) {
            this.bufferService.setMaxProcessingKb(config.getMaxProcessingKb());
        }
        this.bufferService.setInlineLobs(config.isInlineLobs());
        if (config.getMaxOpenFiles() != -1) {
            this.bufferService.setMaxOpenFiles(config.getMaxOpenFiles());
        }
        if (config.getMaxBufferSpace() != -1L) {
            this.bufferService.setMaxBufferSpace(config.getMaxBufferSpace());
        }
        if (config.getMaxFileSize() != -1L) {
            this.bufferService.setMaxFileSize(config.getMaxFileSize());
        }
        this.bufferService.setEncryptFiles(config.isEncryptFiles());
        if (config.getMaxStorageObjectSize() != -1) {
            this.bufferService.setMaxStorageObjectSize(config.getMaxStorageObjectSize());
        }
        this.bufferService.setMemoryBufferOffHeap(config.isMemoryBufferOffHeap());
        if (config.getMemoryBufferSpace() != -1) {
            this.bufferService.setMemoryBufferSpace(config.getMemoryBufferSpace());
        }
    }

    private void initDriver() {
        this.driver.setLocalProfile((ConnectionProfile)this.embeddedProfile);
    }

    private SocketListener startTransport(SocketConfiguration socketConfig, BufferManager bm, int maxODBCLobSize) {
        InetSocketAddress address = null;
        try {
            address = new InetSocketAddress(socketConfig.getResolvedHostAddress(), socketConfig.getPortNumber());
        }
        catch (UnknownHostException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, new Object[0]));
        }
        if (socketConfig.getProtocol() == WireProtocol.teiid) {
            return new SocketListener(address, socketConfig, this.services, (StorageManager)bm){

                @Override
                public ChannelListener createChannelListener(ObjectChannel channel) {
                    SocketClientInstance instance = (SocketClientInstance)super.createChannelListener(channel);
                    instance.getWorkContext().setConnectionProfile(EmbeddedServer.this.embeddedProfile);
                    return instance;
                }
            };
        }
        if (socketConfig.getProtocol() == WireProtocol.pg) {
            ODBCSocketListener odbc = new ODBCSocketListener(address, socketConfig, this.services, (StorageManager)bm, maxODBCLobSize, this.logon, this.driver);
            return odbc;
        }
        throw new AssertionError((Object)("Unknown protocol " + (Object)((Object)socketConfig.getProtocol())));
    }

    private void startVDBRepository() {
        this.repo.addListener(new VDBLifeCycleListener(){

            @Override
            public void added(String name, CompositeVDB vdb) {
            }

            @Override
            public void removed(String name, CompositeVDB vdb) {
                if (EmbeddedServer.this.replicator != null) {
                    EmbeddedServer.this.replicator.stop(vdb.getVDB().getAttachment(GlobalTableStore.class));
                }
                EmbeddedServer.this.rs.clearForVDB(vdb.getVDBKey());
                EmbeddedServer.this.ppc.clearForVDB(vdb.getVDBKey());
                for (SessionMetadata session : EmbeddedServer.this.sessionService.getSessionsLoggedInToVDB(vdb.getVDBKey())) {
                    try {
                        EmbeddedServer.this.sessionService.closeSession(session.getSessionId());
                    }
                    catch (InvalidSessionException invalidSessionException) {}
                }
            }

            @Override
            public void finishedDeployment(String name, CompositeVDB vdb) {
                if (!vdb.getVDB().getStatus().equals((Object)VDB.Status.ACTIVE)) {
                    return;
                }
                GlobalTableStore gts = CompositeGlobalTableStore.createInstance(vdb, EmbeddedServer.this.dqp.getBufferManager(), EmbeddedServer.this.replicator);
                vdb.getVDB().addAttchment(GlobalTableStore.class, (Object)gts);
            }

            @Override
            public void beforeRemove(String name, CompositeVDB vdb) {
            }
        });
        this.repo.setSystemFunctionManager(SystemMetadata.getInstance().getSystemFunctionManager());
        this.repo.start();
    }

    protected BufferService getBufferService() {
        this.bufferService.start();
        if (this.replicator != null) {
            try {
                final TupleBufferCache tbc = (TupleBufferCache)this.replicator.replicate("$BM$", TupleBufferCache.class, (Object)this.bufferService.getBufferManager(), 0L);
                return new BufferService(){

                    public BufferManager getBufferManager() {
                        return EmbeddedServer.this.bufferService.getBufferManager();
                    }

                    public TupleBufferCache getTupleBufferCache() {
                        return tbc;
                    }
                };
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return this.bufferService;
    }

    protected MaterializationManager getMaterializationManager() {
        return new MaterializationManager(this.shutdownListener){

            @Override
            public ScheduledExecutorService getScheduledExecutorService() {
                return EmbeddedServer.this.scheduler;
            }

            @Override
            public ScheduledExecutorService getExecutor() {
                return EmbeddedServer.this.scheduler;
            }

            @Override
            public DQPCore getDQP() {
                return EmbeddedServer.this.dqp;
            }

            @Override
            public VDBRepository getVDBRepository() {
                return EmbeddedServer.this.repo;
            }
        };
    }

    public void addTranslator(Class<? extends ExecutionFactory> clazz) throws TranslatorException {
        try {
            VDBTranslatorMetaData vdbTranslatorMetaData = TranslatorUtil.buildTranslatorMetadata(clazz.newInstance(), null);
            if (vdbTranslatorMetaData != null) {
                this.translatorRepository.addTranslatorMetadata(vdbTranslatorMetaData.getName(), vdbTranslatorMetaData);
            } else {
                ExecutionFactory instance = clazz.newInstance();
                instance.start();
                this.addTranslator(clazz.getName(), instance);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void addTranslator(String name, String type, Map<String, String> properties) throws TranslatorException {
        VDBTranslatorMetaData vdbTranslatorMetaData = new VDBTranslatorMetaData();
        vdbTranslatorMetaData.setName(name);
        VDBTranslatorMetaData parent = this.translatorRepository.getTranslatorMetaData(type);
        if (parent == null) {
            throw new TranslatorException((BundleUtil.Event)RuntimePlugin.Event.TEIID40136, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40136, new Object[]{type}));
        }
        vdbTranslatorMetaData.setParent(parent);
        if (properties != null) {
            Properties p = new Properties();
            p.putAll(properties);
            vdbTranslatorMetaData.setProperties(p);
        }
        this.translatorRepository.addTranslatorMetadata(name, vdbTranslatorMetaData);
    }

    public void addTranslator(String name, ExecutionFactory<?, ?> ef) {
        this.translators.put(name, ef);
        VDBTranslatorMetaData vdbTranslatorMetaData = TranslatorUtil.buildTranslatorMetadata(ef, null);
        if (vdbTranslatorMetaData != null) {
            this.translatorRepository.addTranslatorMetadata(name, vdbTranslatorMetaData);
        }
    }

    public void deployVDB(String name, ModelMetaData ... models) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        VDBMetaData vdb = new VDBMetaData();
        vdb.setXmlDeployment(true);
        VDBKey key = new VDBKey(name, null);
        vdb.setName(key.getName());
        if (key.isAtMost()) {
            if (!name.endsWith(".")) {
                vdb.setVersion("1");
            }
        } else {
            vdb.setVersion(key.getVersion());
        }
        vdb.setModels(Arrays.asList(models));
        this.deployVDB(vdb, null);
    }

    public void deployVDB(InputStream is) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException {
        this.deployVDB(is, false);
    }

    public void deployVDB(InputStream is, boolean ddl) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException {
        if (is == null) {
            return;
        }
        byte[] bytes = ObjectConverterUtil.convertToByteArray((InputStream)is);
        VDBMetaData metadata = null;
        if (ddl) {
            DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(this.getVDBRepository());
            metadata = store.getVDBMetadata(new String(bytes));
        } else {
            try {
                VDBMetadataParser.validate((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (SAXException e) {
                throw new VirtualDatabaseException(e);
            }
            try {
                metadata = VDBMetadataParser.unmarshell((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException(e);
            }
        }
        metadata.setXmlDeployment(true);
        this.deployVDB(metadata, null);
    }

    public void deployVDBZip(URL url) throws VirtualDatabaseException, ConnectorManagerRepository.ConnectorManagerException, TranslatorException, IOException, URISyntaxException {
        VDBMetaData metadata;
        VirtualFile root = PureZipFileSystem.mount((URL)url);
        VirtualFile vdbMetadata = root.getChild("/META-INF/vdb.xml");
        if (vdbMetadata.exists()) {
            try {
                VDBMetadataParser.validate((InputStream)vdbMetadata.openStream());
            }
            catch (SAXException e) {
                throw new VirtualDatabaseException(e);
            }
            InputStream is = vdbMetadata.openStream();
            try {
                metadata = VDBMetadataParser.unmarshell((InputStream)is);
            }
            catch (XMLStreamException e) {
                throw new VirtualDatabaseException(e);
            }
        }
        vdbMetadata = root.getChild("/META-INF/vdb.ddl");
        DeploymentBasedDatabaseStore store = new DeploymentBasedDatabaseStore(this.getVDBRepository());
        metadata = store.getVDBMetadata(ObjectConverterUtil.convertToString((InputStream)vdbMetadata.openStream()));
        VDBResources resources = new VDBResources(root, metadata);
        this.deployVDB(metadata, resources);
    }

    protected boolean allowOverrideTranslators() {
        return false;
    }

    protected void deployVDB(VDBMetaData vdb, VDBResources resources) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        this.checkStarted();
        if (!vdb.getOverrideTranslators().isEmpty() && !this.allowOverrideTranslators()) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40106, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40106, new Object[]{vdb.getName()}));
        }
        vdb.addAttchment(ClassLoader.class, (Object)Thread.currentThread().getContextClassLoader());
        try {
            EmbeddedServer.createPreParser(vdb);
        }
        catch (TeiidException e1) {
            throw new VirtualDatabaseException((Exception)((Object)e1));
        }
        this.cmr.createConnectorManagers(vdb, (ConnectorManagerRepository.ExecutionFactoryProvider)this);
        MetadataStore metadataStore = new MetadataStore();
        UDFMetaData udfMetaData = new UDFMetaData();
        udfMetaData.setFunctionClassLoader(Thread.currentThread().getContextClassLoader());
        IndexMetadataRepository defaultRepo = null;
        LinkedHashMap visibilityMap = null;
        if (resources != null) {
            for (String s : resources.getEntriesPlusVisibilities().keySet()) {
                if (!s.endsWith(".INDEX")) continue;
                defaultRepo = new IndexMetadataRepository();
                break;
            }
            visibilityMap = resources.getEntriesPlusVisibilities();
        } else {
            visibilityMap = new LinkedHashMap();
        }
        this.assignMetadataRepositories(vdb, (MetadataRepository<?, ?>)defaultRepo);
        this.repo.addVDB(vdb, metadataStore, visibilityMap, udfMetaData, this.cmr);
        try {
            this.loadMetadata(vdb, this.cmr, metadataStore, resources);
        }
        catch (VDBValidationError e) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.valueOf(e.getCode()), e.getMessage());
        }
    }

    @Override
    protected MetadataRepository<?, ?> getMetadataRepository(String repoType) throws VirtualDatabaseException {
        if ("index".equals(repoType)) {
            return new IndexMetadataRepository();
        }
        return super.getMetadataRepository(repoType);
    }

    @Override
    protected void loadMetadata(VDBMetaData vdb, ModelMetaData model, ConnectorManagerRepository cmr, MetadataRepository metadataRepository, MetadataStore store, AtomicInteger loadCount, VDBResources vdbResources) throws TranslatorException {
        MetadataFactory factory = this.createMetadataFactory(vdb, store, model, vdbResources == null ? Collections.EMPTY_MAP : vdbResources.getEntriesPlusVisibilities());
        ExecutionFactory ef = null;
        Object cf = null;
        Exception te = null;
        for (ConnectorManager cm : this.getConnectorManagers(model, cmr)) {
            if (te != null) {
                LogManager.logDetail((String)"org.teiid.RUNTIME", te, (Object)"Failed to get metadata, trying next source.");
                te = null;
            }
            try {
                if (cm != null) {
                    ef = cm.getExecutionFactory();
                    cf = cm.getConnectionFactory();
                }
            }
            catch (TranslatorException e) {
                LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)((Object)e), (Object)"Failed to get a connection factory for metadata load.");
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"CREATE SCHEMA", factory.getSchema().getName(), ";\n", DDLStringVisitor.getDDLString((Schema)factory.getSchema(), null, null)});
            }
            try {
                metadataRepository.loadMetadata(factory, ef, cf);
                break;
            }
            catch (Exception e) {
                te = e;
                factory = this.createMetadataFactory(vdb, store, model, vdbResources == null ? Collections.EMPTY_MAP : vdbResources.getEntriesPlusVisibilities());
            }
        }
        if (te != null) {
            if (te instanceof TranslatorException) {
                throw (TranslatorException)((Object)te);
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            throw new TranslatorException(te);
        }
        this.metadataLoaded(vdb, model, store, loadCount, factory, true, cmr, vdbResources);
    }

    public void undeployVDB(String vdbName) {
        this.checkStarted();
        this.repo.removeVDB(vdbName, "1");
    }

    EmbeddedConfiguration getConfiguration() {
        return this.config;
    }

    public synchronized void stop() {
        if (this.running == null || !this.running.booleanValue()) {
            return;
        }
        if (this.channelFactory != null) {
            this.channelFactory.stop();
        }
        this.shutdownListener.setShutdownInProgress(true);
        this.repo.removeListener(this.materializationMgr);
        this.scheduler.shutdownNow();
        for (SocketListener socket : this.transports) {
            socket.stop();
        }
        this.sessionService.stop();
        this.transports.clear();
        this.dqp.stop();
        if (this.config != null) {
            this.config.stop();
        }
        this.eventDistributorFactoryService.stop();
        this.config.getCacheFactory().destroy();
        this.config.setCacheFactory(null);
        if (this.bufferService != null) {
            this.bufferService.stop();
        }
        this.bufferService = null;
        this.dqp = null;
        this.running = false;
        this.shutdownListener.setShutdownInProgress(false);
    }

    private synchronized void checkStarted() {
        if (this.running == null || !this.running.booleanValue()) {
            throw new IllegalStateException();
        }
    }

    public TeiidDriver getDriver() {
        this.checkStarted();
        return this.driver;
    }

    public EventDistributor getEventDistributor() {
        return this.eventDistributorFactoryService.getEventDistributor();
    }

    public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
        ExecutionFactory<?, ?> ef = this.translators.get(name);
        if (ef == null) {
            return TranslatorUtil.getExecutionFactory(name, this.translatorRepository, this.translatorRepository, null, new IdentityHashMap<Translator, ExecutionFactory<Object, Object>>(), new HashSet<String>());
        }
        return ef;
    }

    @Override
    protected VDBRepository getVDBRepository() {
        return this.repo;
    }

    public String getSchemaDdl(String vdbName, String schemaName) {
        VDBMetaData vdb = this.repo.getVDB(vdbName, "1");
        if (vdb == null) {
            return null;
        }
        TransformationMetadata metadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (metadata == null) {
            return null;
        }
        Schema schema = metadata.getMetadataStore().getSchema(schemaName);
        if (schema == null) {
            return null;
        }
        return DDLStringVisitor.getDDLString((Schema)schema, null, null);
    }

    public int getPort(int transport) {
        return this.transports.get(transport).getPort();
    }

    TranslatorRepository getTranslatorRepository() {
        return this.translatorRepository;
    }

    ConcurrentHashMap<String, ConnectionFactoryProvider<?>> getConnectionFactoryProviders() {
        return this.connectionFactoryProviders;
    }

    protected SessionAwareCache<CachedResults> getRsCache() {
        return this.rs;
    }

    protected SessionAwareCache<PreparedPlan> getPpcCache() {
        return this.ppc;
    }

    public Admin getAdmin() {
        return EmbeddedAdminFactory.getInstance().createAdmin(this);
    }

    public static void createPreParser(VDBMetaData deployment) throws TeiidException {
        String preparserClass = deployment.getPropertyValue("preparser-class");
        if (preparserClass != null) {
            ClassLoader vdbClassLoader = (ClassLoader)deployment.getAttachment(ClassLoader.class);
            PreParser preParser = (PreParser)ReflectionHelper.create((String)preparserClass, Collections.emptyList(), (ClassLoader)vdbClassLoader);
            deployment.addAttchment(PreParser.class, (Object)preParser);
        }
    }

    static {
        LogManager.setLogListener((Logger)new JBossLogger());
    }

    static class ShutDownListener
    implements ContainerLifeCycleListener {
        private boolean shutdownInProgress = false;
        private boolean bootInProgress = false;
        private boolean running = false;

        ShutDownListener() {
        }

        @Override
        public boolean isShutdownInProgress() {
            return this.shutdownInProgress;
        }

        @Override
        public boolean isBootInProgress() {
            return this.bootInProgress;
        }

        public void addListener(ContainerLifeCycleListener.LifeCycleEventListener listener) {
        }

        public void setBootInProgress(boolean value) {
            this.bootInProgress = value;
        }

        public void setShutdownInProgress(boolean value) {
            this.shutdownInProgress = value;
        }

        public void started() {
            this.running = true;
        }

        @Override
        public boolean isStarted() {
            return this.running;
        }
    }

    class EmbeddedEventDistributorFactoryService
    extends AbstractEventDistributorFactoryService {
        EmbeddedEventDistributorFactoryService() {
        }

        @Override
        protected VDBRepository getVdbRepository() {
            return EmbeddedServer.this.repo;
        }

        @Override
        protected ObjectReplicator getObjectReplicator() {
            return EmbeddedServer.this.replicator;
        }

        @Override
        protected DQPCore getDQPCore() {
            return EmbeddedServer.this.dqp;
        }
    }

    private static class VDBValidationError
    extends TeiidRuntimeException {
        private VDBValidationError(BundleUtil.Event event, String message) {
            super(event, message);
        }
    }

    public static class SimpleConnectionFactoryProvider<T>
    implements ConnectionFactoryProvider<T> {
        private T connectionFactory;

        public SimpleConnectionFactoryProvider(T connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        @Override
        public T getConnectionFactory() throws TranslatorException {
            return this.connectionFactory;
        }
    }

    public static interface ConnectionFactoryProvider<T> {
        public T getConnectionFactory() throws TranslatorException;
    }

    protected class ProviderAwareConnectorManagerRepository
    extends ConnectorManagerRepository {
        public ProviderAwareConnectorManagerRepository() {
            super(true);
        }

        protected ConnectorManager createConnectorManager(String translatorName, String connectionName, ExecutionFactory<Object, Object> ef) throws ConnectorManagerRepository.ConnectorManagerException {
            return new ConnectorManager(translatorName, connectionName, ef){

                public Object getConnectionFactory() throws TranslatorException {
                    if (this.getConnectionName() == null) {
                        return null;
                    }
                    ConnectionFactoryProvider connectionFactoryProvider = (ConnectionFactoryProvider)EmbeddedServer.this.connectionFactoryProviders.get(this.getConnectionName());
                    if (connectionFactoryProvider != null) {
                        return connectionFactoryProvider.getConnectionFactory();
                    }
                    return super.getConnectionFactory();
                }
            };
        }
    }

    private final class EmbeddedConnectionImpl
    extends ConnectionImpl
    implements EmbeddedConnection {
        public EmbeddedConnectionImpl(ServerConnection serverConn, Properties info, String url) {
            super(serverConn, info, url);
        }

        @Override
        public CallableStatement prepareCall(Command command, EmbeddedRequestOptions options) throws SQLException {
            CallableStatementImpl csi = this.prepareCall(command.toString(), options.getResultSetType(), 1007);
            csi.setCommand((Object)command);
            return csi;
        }

        @Override
        public TeiidPreparedStatement prepareStatement(Command command, EmbeddedRequestOptions options) throws SQLException {
            PreparedStatementImpl psi = this.prepareStatement(command.toString(), options.getResultSetType(), 1007);
            psi.setCommand((Object)command);
            return psi;
        }
    }
}

